/*
 * Decompiled with CFR 0.152.
 */
package com.kyfexuwu.easycraftingtable;

import com.kyfexuwu.easycraftingtable.Config;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Mod(value="easycraftingtable")
public class Easycraftingtable {
    public static final String MODID = "easycraftingtable";
    private static final Logger LOGGER = LogUtils.getLogger();

    public Easycraftingtable(FMLJavaModLoadingContext context) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    public boolean isCrafterItem(Item item) {
        return Config.craftingTableItems.contains(item);
    }

    @SubscribeEvent
    public void onCraftingTableUsed(PlayerInteractEvent.RightClickItem event) {
        if (this.isCrafterItem(event.getItemStack().getItem())) {
            event.getEntity().openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)"container.crafting");
                }

                @Nullable
                public AbstractContainerMenu createMenu(int syncId, final Inventory playerInv, final Player player) {
                    return new CraftingMenu(syncId, playerInv, new ContainerLevelAccess(){

                        public <T> Optional<T> evaluate(BiFunction<Level, BlockPos, T> func) {
                            return Optional.of(func.apply(player.level(), player.blockPosition()));
                        }
                    }){

                        public boolean stillValid(Player player) {
                            return !Config.requireInInv || playerInv.contains(stack -> Easycraftingtable.this.isCrafterItem(stack.getItem())) || this.getCarried().is(holder -> Easycraftingtable.this.isCrafterItem((Item)holder.get()));
                        }
                    };
                }
            });
        }
    }
}

