/*
 * Decompiled with CFR 0.152.
 */
package com.kyfexuwu.easycraftingtable;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="easycraftingtable", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec.BooleanValue REQUIRE_IN_INVENTORY = BUILDER.comment("Whether it is required to have a crafting table in your inventory at all times after opening the crafting screen from the item").define("requireInInv", false);
    public static final ModConfigSpec.ConfigValue<List<? extends String>> CRAFTING_TABLE_ITEMS = BUILDER.comment("A list of items that will trigger the crafting table screen, as well as keep the crafting screen open (if requireInInventory is true)").defineListAllowEmpty("craftingTableItems", List.of("minecraft:crafting_table", "minecraft:crafter"), Config::validateItemName);
    public static final ModConfigSpec SPEC = BUILDER.build();
    public static boolean requireInInv;
    public static Set<Item> craftingTableItems;

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && BuiltInRegistries.ITEM.containsKey(ResourceLocation.parse((String)(itemName = (String)obj)));
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        requireInInv = (Boolean)REQUIRE_IN_INVENTORY.get();
        craftingTableItems = ((List)CRAFTING_TABLE_ITEMS.get()).stream().map(itemName -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet());
    }
}

