/*
 * Decompiled with CFR 0.152.
 */
package com.kyfexuwu.easycraftingtable;

import com.kyfexuwu.easycraftingtable.Config;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Mod(value="easycraftingtable")
public class Easycraftingtable {
    public static final String MODID = "easycraftingtable";
    private static final Logger LOGGER = LogUtils.getLogger();

    public Easycraftingtable(IEventBus modEventBus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    public static boolean isCrafterItem(Item item) {
        return Config.craftingTableItems.contains(item);
    }

    @SubscribeEvent
    public void onCraftingTableUsed(PlayerInteractEvent.RightClickItem event) {
        if (Easycraftingtable.isCrafterItem(event.getItemStack().getItem())) {
            event.getEntity().openMenu(new MenuProvider(this){

                public Component getDisplayName() {
                    return Component.translatable((String)"container.crafting");
                }

                @Nullable
                public AbstractContainerMenu createMenu(int syncId, final Inventory playerInv, final Player player) {
                    return new CraftingMenu(this, syncId, playerInv, new ContainerLevelAccess(){

                        public <T> Optional<T> evaluate(BiFunction<Level, BlockPos, T> func) {
                            return Optional.of(func.apply(player.level(), player.blockPosition()));
                        }
                    }){

                        public boolean stillValid(Player player) {
                            return !Config.requireInInv || playerInv.contains(stack -> Easycraftingtable.isCrafterItem(stack.getItem())) || this.getCarried().is(holder -> Easycraftingtable.isCrafterItem((Item)holder.value()));
                        }
                    };
                }
            });
        }
    }
}

