/*
 * Decompiled with CFR 0.152.
 */
package com.kyfexuwu.easycraftingtable;

import com.kyfexuwu.easycraftingtable.Easycraftingtable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractScrollWidget;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class ConfigScreen
extends Screen {
    protected final Screen lastScreen;
    public final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private Button addButton;
    private ArrayList<EditBox> inputs = new ArrayList();
    private AbstractScrollWidget scroller;
    private boolean shouldSave = false;
    private Button doneButton;

    public ConfigScreen(Screen lastScreen) {
        super((Component)Component.translatable((String)"easycraftingtable.configuration.title"));
        this.lastScreen = lastScreen;
    }

    protected void init() {
        this.addTitle();
        this.addContents();
        this.addFooter();
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void addTitle() {
        this.layout.addToHeader((LayoutElement)new StringWidget(this.title, this.font));
    }

    private EditBox box(String val) {
        int n = this.layout.getX() + this.layout.getWidth() / 2 + 10;
        int n2 = this.layout.getWidth() / 2 - 40;
        Objects.requireNonNull(this.font);
        EditBox toReturn = new EditBox(this.font, n, 0, n2, 9 * 2, (Component)Component.literal((String)""));
        toReturn.insertText(val);
        toReturn.active = true;
        toReturn.visible = true;
        return toReturn;
    }

    private void recalc(double startY) {
        int i;
        for (i = 0; i < this.inputs.size(); ++i) {
            Objects.requireNonNull(this.font);
            this.inputs.get(i).setY((int)(startY + (double)(i * (9 * 2 + 10))));
        }
        Objects.requireNonNull(this.font);
        this.addButton.setY((int)(startY + (double)(i * (9 * 2 + 10))));
    }

    protected void addContents() {
        if (!Easycraftingtable.SPEC.isLoaded()) {
            this.layout.addToContents((LayoutElement)new StringWidget((Component)Component.translatable((String)"easycraftingtable.configuration.must_load_world"), this.font));
            return;
        }
        this.shouldSave = true;
        this.scroller = new AbstractScrollWidget(20, this.layout.getHeaderHeight(), this.layout.getWidth() - 40, this.layout.getHeight() - this.layout.getHeaderHeight() - this.layout.getFooterHeight(), (Component)Component.empty()){

            public boolean mouseClicked(double mouseX, double mouseY, int p_240172_) {
                for (EditBox input : ConfigScreen.this.inputs) {
                    if (input.mouseClicked(mouseX, mouseY + this.scrollAmount(), p_240172_)) {
                        input.setFocused(true);
                        return true;
                    }
                    input.setFocused(false);
                }
                if (ConfigScreen.this.addButton.mouseClicked(mouseX, mouseY, p_240172_)) {
                    return true;
                }
                if (ConfigScreen.this.doneButton.mouseClicked(mouseX, mouseY, p_240172_)) {
                    return true;
                }
                return super.mouseClicked(mouseX, mouseY, p_240172_);
            }

            public boolean keyPressed(int p_276060_, int p_276046_, int p_276030_) {
                for (EditBox input : ConfigScreen.this.inputs) {
                    input.keyPressed(p_276060_, p_276046_, p_276030_);
                }
                return super.keyPressed(p_276060_, p_276046_, p_276030_);
            }

            public boolean charTyped(char p_94732_, int p_94733_) {
                for (EditBox input : ConfigScreen.this.inputs) {
                    input.charTyped(p_94732_, p_94733_);
                }
                return super.charTyped(p_94732_, p_94733_);
            }

            protected int getInnerHeight() {
                return ConfigScreen.this.addButton.getY() + ConfigScreen.this.addButton.getHeight() + 50;
            }

            protected double scrollRate() {
                return 10.0;
            }

            protected void renderContents(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
                MutableComponent allowedItems = Component.translatable((String)"easycraftingtable.configuration.allowedItems");
                guiGraphics.drawString(ConfigScreen.this.font, (Component)allowedItems, this.getX() + this.width / 2 - ConfigScreen.this.font.width((FormattedText)allowedItems) - 10, this.getY() + 10, 0xFFFFFF);
                ConfigScreen.this.recalc(this.getY() + 10);
                for (EditBox input : ConfigScreen.this.inputs) {
                    input.renderWidget(guiGraphics, mouseX, (int)((double)mouseY + this.scrollAmount()), v);
                }
                ConfigScreen.this.addButton.render(guiGraphics, mouseX, (int)((double)mouseY + this.scrollAmount()), v);
            }

            protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            }
        };
        this.layout.addToContents((LayoutElement)this.scroller);
        for (String val : (List)Easycraftingtable.CRAFTING_TABLE_ITEMS.get()) {
            EditBox box = this.box(val);
            this.inputs.add(box);
        }
        Button.Builder builder = new Button.Builder((Component)Component.literal((String)"+"), self -> {
            EditBox box = this.box("");
            this.inputs.add(box);
        });
        int n = this.layout.getX() + this.layout.getWidth() * 3 / 4;
        Objects.requireNonNull(this.font);
        int n2 = n - 9;
        Objects.requireNonNull(this.font);
        Objects.requireNonNull(this.font);
        this.addButton = builder.bounds(n2, 0, 9 * 2, 9 * 2).build();
    }

    protected void addFooter() {
        this.doneButton = Button.builder((Component)CommonComponents.GUI_DONE, p -> this.onClose()).width(200).build();
        this.layout.addToFooter((LayoutElement)this.doneButton);
    }

    protected void repositionElements() {
        if (this.scroller != null) {
            this.scroller.setWidth(this.layout.getWidth() - 40);
        }
        this.layout.arrangeElements();
        for (EditBox input : this.inputs) {
            input.setX(this.layout.getX() + this.layout.getWidth() / 2 + 10);
            input.setWidth(this.layout.getWidth() / 2 - 40);
        }
        if (this.addButton != null) {
            int n = this.layout.getX() + this.layout.getWidth() * 3 / 4;
            Objects.requireNonNull(this.font);
            this.addButton.setX(n - 9);
        }
    }

    public void onClose() {
        if (this.shouldSave) {
            Easycraftingtable.CRAFTING_TABLE_ITEMS.set(this.inputs.stream().map(EditBox::getValue).toList());
        }
        this.minecraft.setScreen(this.lastScreen);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderDirtBackground(guiGraphics);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }
}

