/*
 * Decompiled with CFR 0.152.
 */
package com.kyfexuwu.easycraftingtable;

import com.kyfexuwu.easycraftingtable.ConfigScreen;
import com.mojang.logging.LogUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mod(value="easycraftingtable")
public class Easycraftingtable {
    public static final String MODID = "easycraftingtable";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static Set<AbstractContainerMenu> permaValidInvs = new HashSet<AbstractContainerMenu>();
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> CRAFTING_TABLE_ITEMS = BUILDER.comment("A list of items that will open their screen on click\nTested vanilla blocks:" + List.of("", "minecraft:crafting_table", "minecraft:stonecutter", "minecraft:cartography_table", "minecraft:smithing_table", "minecraft:grindstone", "minecraft:loom", "minecraft:anvil (and its variants, though they do need to be added separately)").stream().collect(Collectors.joining("\n  "))).defineListAllowEmpty(List.of("allowedItems"), () -> List.of("minecraft:crafting_table"), Easycraftingtable::validateItemName);
    public static final ForgeConfigSpec SPEC = BUILDER.build();

    public Easycraftingtable() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SPEC);
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> new ConfigScreen((Screen)screen)));
    }

    public static boolean isValid(Item item) {
        return ((List)CRAFTING_TABLE_ITEMS.get()).contains(BuiltInRegistries.ITEM.getKey((Object)item).toString());
    }

    public static void shouldPermaValidInv(Player player, CallbackInfoReturnable<Boolean> returner) {
        if (permaValidInvs.contains(player.containerMenu)) {
            returner.setReturnValue((Object)true);
            returner.cancel();
        }
    }

    public static void onCraftingTableUsed(ItemStack item, Player player, Level level) {
        Item item2 = item.getItem();
        if (item2 instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item2;
            blockItem.getBlock().defaultBlockState().use(level, player, InteractionHand.MAIN_HAND, new BlockHitResult(player.position(), Direction.DOWN, player.blockPosition(), false));
            permaValidInvs.add(player.containerMenu);
        }
    }

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && BuiltInRegistries.ITEM.containsKey(ResourceLocation.tryParse((String)(itemName = (String)obj)));
    }
}

