/*
 * Decompiled with CFR 0.152.
 */
package com.r4g3baby.simplescore.bukkit;

import com.r4g3baby.simplescore.BukkitPlugin;
import com.r4g3baby.simplescore.api.scoreboard.Scoreboard;
import com.r4g3baby.simplescore.api.scoreboard.data.Priority;
import com.r4g3baby.simplescore.api.scoreboard.data.Provider;
import com.r4g3baby.simplescore.bukkit.command.MainCmd;
import com.r4g3baby.simplescore.bukkit.config.MainConfig;
import com.r4g3baby.simplescore.bukkit.listener.PlayerListener;
import com.r4g3baby.simplescore.bukkit.protocol.ProtocolHandler;
import com.r4g3baby.simplescore.bukkit.protocol.legacy.LegacyProtocolHandler;
import com.r4g3baby.simplescore.bukkit.protocol.modern.ModernProtocolHandler;
import com.r4g3baby.simplescore.bukkit.protocol.modern.TeamsProtocolHandler;
import com.r4g3baby.simplescore.bukkit.protocol.util.ServerVersion;
import com.r4g3baby.simplescore.bukkit.scoreboard.ScoreboardTask;
import com.r4g3baby.simplescore.bukkit.scoreboard.VarReplacer;
import com.r4g3baby.simplescore.bukkit.scoreboard.data.Viewer;
import com.r4g3baby.simplescore.bukkit.worldguard.WorldGuardAPI;
import com.r4g3baby.simplescore.core.BaseManager;
import com.r4g3baby.simplescore.lib.jetbrains.annotations.NotNull;
import com.r4g3baby.simplescore.lib.jetbrains.annotations.Nullable;
import com.r4g3baby.simplescore.lib.kotlin.Metadata;
import com.r4g3baby.simplescore.lib.kotlin.collections.CollectionsKt;
import com.r4g3baby.simplescore.lib.kotlin.jvm.functions.Function1;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.Intrinsics;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.SourceDebugExtension;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\u0018\u0010$\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u001c2\u0006\u0010%\u001a\u00020\u001bH\u0016J\u001e\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u001c2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0016J\u001e\u0010(\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u001c2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010\u001f2\u0006\u0010,\u001a\u00020\u001eH\u0016J\u0015\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u0002H\u0000\u00a2\u0006\u0002\b/J\u0015\u00100\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u0002H\u0000\u00a2\u0006\u0002\b1J\u0017\u00102\u001a\u0004\u0018\u00010\u001f2\u0006\u0010,\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b3J\u001d\u00106\u001a\u00020\u00112\u0006\u00107\u001a\u00020\u001f2\u0006\u00108\u001a\u000209H\u0000\u00a2\u0006\u0002\b:J\u001d\u0010<\u001a\u00020\u00112\u0006\u00107\u001a\u00020\u001f2\u0006\u0010=\u001a\u00020>H\u0000\u00a2\u0006\u0002\b?J\u001c\u0010A\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u001c0!2\u0006\u00108\u001a\u000209H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@RX\u0096.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R \u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u001c0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u001c0!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001f0!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010#R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010@\u001a\u001a\u0012\u0004\u0012\u00020\u001b\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u001c0!0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/r4g3baby/simplescore/bukkit/BukkitManager;", "Lcom/r4g3baby/simplescore/core/BaseManager;", "Lorg/bukkit/entity/Player;", "Lorg/bukkit/configuration/file/YamlConfiguration;", "plugin", "Lcom/r4g3baby/simplescore/BukkitPlugin;", "<init>", "(Lcom/r4g3baby/simplescore/BukkitPlugin;)V", "varReplacer", "Lcom/r4g3baby/simplescore/bukkit/scoreboard/VarReplacer;", "getVarReplacer", "()Lcom/r4g3baby/simplescore/bukkit/scoreboard/VarReplacer;", "trailsAndTailsUpdate3", "Lcom/r4g3baby/simplescore/bukkit/protocol/util/ServerVersion;", "protocolHandler", "Lcom/r4g3baby/simplescore/bukkit/protocol/ProtocolHandler;", "onEnable", "", "onDisable", "value", "Lcom/r4g3baby/simplescore/bukkit/config/MainConfig;", "config", "getConfig", "()Lcom/r4g3baby/simplescore/bukkit/config/MainConfig;", "loadConfiguration", "scoreboardsMap", "", "", "Lcom/r4g3baby/simplescore/api/scoreboard/Scoreboard;", "viewersMap", "Ljava/util/UUID;", "Lcom/r4g3baby/simplescore/bukkit/scoreboard/data/Viewer;", "scoreboards", "", "getScoreboards", "()Ljava/util/List;", "getScoreboard", "name", "addScoreboard", "scoreboard", "removeScoreboard", "viewers", "getViewers", "getViewer", "uniqueID", "getOrCreateViewer", "player", "getOrCreateViewer$bukkit", "createViewer", "createViewer$bukkit", "removeViewer", "removeViewer$bukkit", "worldProvider", "Lcom/r4g3baby/simplescore/api/scoreboard/data/Provider;", "onViewerChangeWorld", "viewer", "world", "Lorg/bukkit/World;", "onViewerChangeWorld$bukkit", "regionProvider", "onViewerChangeLocation", "location", "Lorg/bukkit/Location;", "onViewerChangeLocation$bukkit", "worldScoreboardsCache", "getForWorld", "bukkit"})
@SourceDebugExtension(value={"SMAP\nBukkitManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BukkitManager.kt\ncom/r4g3baby/simplescore/bukkit/BukkitManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n1869#2,2:173\n1869#2,2:177\n295#2,2:179\n1617#2,9:181\n1869#2:190\n1870#2:192\n1626#2:193\n295#2,2:194\n1617#2,9:197\n1869#2:206\n1870#2:208\n1626#2:209\n1869#2,2:210\n216#3,2:175\n216#3:196\n217#3:212\n1#4:191\n1#4:207\n*S KotlinDebug\n*F\n+ 1 BukkitManager.kt\ncom/r4g3baby/simplescore/bukkit/BukkitManager\n*L\n50#1:173,2\n73#1:177,2\n142#1:179,2\n152#1:181,9\n152#1:190\n152#1:192\n152#1:193\n152#1:194,2\n163#1:197,9\n163#1:206\n163#1:208\n163#1:209\n163#1:210,2\n68#1:175,2\n161#1:196\n161#1:212\n152#1:191\n163#1:207\n*E\n"})
public final class BukkitManager
extends BaseManager<Player, YamlConfiguration> {
    @NotNull
    private final BukkitPlugin plugin;
    @NotNull
    private final VarReplacer varReplacer;
    @NotNull
    private final ServerVersion trailsAndTailsUpdate3;
    @NotNull
    private final ProtocolHandler protocolHandler;
    private MainConfig config;
    @NotNull
    private final Map<String, Scoreboard<Player>> scoreboardsMap;
    @NotNull
    private final Map<UUID, Viewer> viewersMap;
    @NotNull
    private final Provider worldProvider;
    @NotNull
    private final Provider regionProvider;
    @NotNull
    private final Map<String, List<Scoreboard<Player>>> worldScoreboardsCache;

    public BukkitManager(@NotNull BukkitPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        super(plugin);
        this.plugin = plugin;
        this.varReplacer = new VarReplacer(this.plugin);
        this.trailsAndTailsUpdate3 = ServerVersion.copy$default(ServerVersion.Companion.getTrailsAndTailsUpdate(), 0, 0, 3, 3, null);
        this.protocolHandler = ServerVersion.Companion.isBellow(this.trailsAndTailsUpdate3) ? (ServerVersion.Companion.isBellow(ServerVersion.Companion.getAquaticUpdate()) ? (ProtocolHandler)new LegacyProtocolHandler() : (ProtocolHandler)new TeamsProtocolHandler()) : (ProtocolHandler)new ModernProtocolHandler();
        this.scoreboardsMap = new ConcurrentHashMap();
        this.viewersMap = new ConcurrentHashMap();
        this.worldProvider = this.plugin.getProvider().withContext("world");
        this.regionProvider = this.plugin.getProvider().withContext("region");
        this.worldScoreboardsCache = new LinkedHashMap();
    }

    @NotNull
    public VarReplacer getVarReplacer() {
        return this.varReplacer;
    }

    @Override
    public void onEnable() {
        super.onEnable();
        this.plugin.getCommand(this.plugin.getName()).setExecutor((CommandExecutor)new MainCmd(this.plugin));
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this.plugin);
        if (this.getConfig().getScoreboardTaskAsync()) {
            this.plugin.getScheduler().runTaskTimerAsync(20L, this.getConfig().getTaskUpdateTime(), new ScoreboardTask(this, this.protocolHandler));
        } else {
            this.plugin.getScheduler().runTaskTimer(20L, this.getConfig().getTaskUpdateTime(), new ScoreboardTask(this, this.protocolHandler));
        }
    }

    @Override
    public void onDisable() {
        HandlerList.unregisterAll((Plugin)((Plugin)this.plugin));
        Collection collection = this.plugin.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player = (Player)element$iv;
            boolean bl = false;
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            this.removeViewer$bukkit(uUID);
        }
        super.onDisable();
    }

    @NotNull
    public MainConfig getConfig() {
        MainConfig mainConfig = this.config;
        if (mainConfig != null) {
            return mainConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException("config");
        return null;
    }

    @Override
    public void loadConfiguration() {
        Map.Entry element$iv;
        this.config = new MainConfig(this.plugin);
        super.loadConfiguration();
        this.worldScoreboardsCache.clear();
        Object $this$forEach$iv = this.getConfig().getScoreboards();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            String name = entry.getKey();
            this.scoreboardsMap.remove(name);
        }
        Collection collection = this.plugin.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        $this$forEach$iv = collection;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            Player player = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(player);
            Viewer viewer = this.getOrCreateViewer$bukkit(player);
            if (viewer.getScoreboard(this.plugin.getProvider()) != null) {
                Scoreboard<Player> forcedScoreboard;
                boolean bl2 = false;
                Scoreboard<Player> scoreboard = this.plugin.getManager().getScoreboard(forcedScoreboard.getName());
                viewer.setScoreboard(scoreboard, this.plugin.getProvider(), Priority.Highest);
            }
            World world = player.getWorld();
            Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
            this.onViewerChangeWorld$bukkit(viewer, world);
            Location location = player.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            this.onViewerChangeLocation$bukkit(viewer, location);
        }
    }

    @Override
    @NotNull
    public List<Scoreboard<Player>> getScoreboards() {
        List list;
        List $this$_get_scoreboards__u24lambda_u244 = list = (List)new ArrayList();
        boolean bl = false;
        $this$_get_scoreboards__u24lambda_u244.addAll(this.getConfig().getScoreboards().values());
        $this$_get_scoreboards__u24lambda_u244.addAll(this.scoreboardsMap.values());
        return list;
    }

    @Override
    @Nullable
    public Scoreboard<Player> getScoreboard(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Scoreboard<Player> scoreboard = this.getConfig().getScoreboards().get(name);
        if (scoreboard == null) {
            scoreboard = this.scoreboardsMap.get(name);
        }
        return scoreboard;
    }

    @Override
    @Nullable
    public Scoreboard<Player> addScoreboard(@NotNull Scoreboard<Player> scoreboard) {
        Intrinsics.checkNotNullParameter(scoreboard, "scoreboard");
        return this.scoreboardsMap.put(scoreboard.getName(), scoreboard);
    }

    @Override
    @Nullable
    public Scoreboard<Player> removeScoreboard(@NotNull Scoreboard<Player> scoreboard) {
        Intrinsics.checkNotNullParameter(scoreboard, "scoreboard");
        return this.scoreboardsMap.remove(scoreboard.getName());
    }

    @Override
    @NotNull
    public List<Viewer> getViewers() {
        return CollectionsKt.toList((Iterable)this.viewersMap.values());
    }

    @Nullable
    public Viewer getViewer(@NotNull UUID uniqueID) {
        Intrinsics.checkNotNullParameter(uniqueID, "uniqueID");
        return this.viewersMap.get(uniqueID);
    }

    @NotNull
    public final Viewer getOrCreateViewer$bukkit(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        Viewer viewer = this.getViewer(uUID);
        if (viewer == null) {
            viewer = this.createViewer$bukkit(player);
        }
        return viewer;
    }

    @NotNull
    public final Viewer createViewer$bukkit(@NotNull Player player) {
        Viewer viewer;
        Intrinsics.checkNotNullParameter(player, "player");
        Viewer viewer2 = viewer = new Viewer(player);
        boolean bl = false;
        this.viewersMap.put(player.getUniqueId(), viewer2);
        this.plugin.getScheduler().runTaskAsync(BukkitManager::createViewer$lambda$6$lambda$5);
        return viewer;
    }

    @Nullable
    public final Viewer removeViewer$bukkit(@NotNull UUID uniqueID) {
        Player player;
        Viewer viewer;
        Intrinsics.checkNotNullParameter(uniqueID, "uniqueID");
        Viewer viewer2 = viewer = this.viewersMap.remove(uniqueID);
        boolean bl = false;
        Object object = viewer2;
        Player player2 = object != null && (object = ((Viewer)object).getReference()) != null ? (Player)((Reference)object).get() : (player = null);
        if (player != null && player.isOnline()) {
            this.protocolHandler.removeObjective(player);
        }
        return viewer;
    }

    public final void onViewerChangeWorld$bukkit(@NotNull Viewer viewer, @NotNull World world) {
        Intrinsics.checkNotNullParameter(viewer, "viewer");
        Intrinsics.checkNotNullParameter(world, "world");
        Player player = (Player)viewer.getReference().get();
        if (player == null) {
            return;
        }
        Player player2 = player;
        List<Scoreboard<Player>> scoreboards = this.getForWorld(world);
        if (!((Collection)scoreboards).isEmpty()) {
            Object v1;
            block4: {
                Iterable $this$firstOrNull$iv = scoreboards;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Scoreboard it = (Scoreboard)element$iv;
                    boolean bl = false;
                    if (!it.canSee(player2, this.getVarReplacer())) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            Scoreboard scoreboard = v1;
            viewer.setScoreboard(scoreboard, this.worldProvider, Priority.Low);
        } else {
            viewer.removeScoreboard(this.worldProvider);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void onViewerChangeLocation$bukkit(@NotNull Viewer viewer, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(viewer, "viewer");
        Intrinsics.checkNotNullParameter(location, "location");
        Player player = (Player)viewer.getReference().get();
        if (player == null) {
            return;
        }
        Player player2 = player;
        List<String> scoreboards = WorldGuardAPI.INSTANCE.getScoreboardFlag(player2, location);
        if (!((Collection)scoreboards).isEmpty()) {
            Object v1;
            block5: {
                void $this$firstOrNull$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = scoreboards;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Scoreboard<Player> it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    String it = (String)element$iv$iv;
                    boolean bl2 = false;
                    if (this.getScoreboard(it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Scoreboard it = (Scoreboard)element$iv;
                    boolean bl = false;
                    if (!it.canSee(player2, this.getVarReplacer())) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            Scoreboard scoreboard = v1;
            viewer.setScoreboard(scoreboard, this.regionProvider, Priority.Normal);
        } else {
            viewer.removeScoreboard(this.regionProvider);
        }
    }

    private final List<Scoreboard<Player>> getForWorld(World world) {
        List list = this.worldScoreboardsCache.computeIfAbsent(world.getName(), arg_0 -> BukkitManager.getForWorld$lambda$16(arg_0 -> BukkitManager.getForWorld$lambda$15(this, world, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(list, "computeIfAbsent(...)");
        return list;
    }

    private static final void createViewer$lambda$6$lambda$5() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List getForWorld$lambda$15(BukkitManager this$0, World $world, String it) {
        List list;
        Intrinsics.checkNotNullParameter(it, "it");
        List list2 = list = (List)new ArrayList();
        boolean bl = false;
        Map<Predicate<String>, List<String>> $this$forEach$iv = this$0.getConfig().getWorlds();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Predicate<String>, List<String>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$forEach$iv2;
            void $this$mapNotNullTo$iv$iv;
            Map.Entry<Predicate<String>, List<String>> element$iv;
            Map.Entry<Predicate<String>, List<String>> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            Predicate<String> predicate = entry.getKey();
            List<String> scoreboards = entry.getValue();
            if (!predicate.test($world.getName())) continue;
            Iterable $this$mapNotNull$iv = scoreboards;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Scoreboard<Player> it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl3 = false;
                String it2 = (String)element$iv$iv;
                boolean bl4 = false;
                if (this$0.getScoreboard(it2) == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Scoreboard scoreboard = (Scoreboard)element$iv2;
                boolean bl6 = false;
                list2.add(scoreboard);
            }
        }
        return list;
    }

    private static final List getForWorld$lambda$16(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }
}

