/*
 * Decompiled with CFR 0.152.
 */
package com.r4g3baby.simplescore.bukkit.config;

import com.r4g3baby.simplescore.BukkitPlugin;
import com.r4g3baby.simplescore.api.scoreboard.ScoreboardLine;
import com.r4g3baby.simplescore.api.scoreboard.condition.Condition;
import com.r4g3baby.simplescore.bukkit.config.MainConfig;
import com.r4g3baby.simplescore.core.config.BaseScoreboardsConfig;
import com.r4g3baby.simplescore.core.scoreboard.Scoreboard;
import com.r4g3baby.simplescore.core.scoreboard.ScoreboardScore;
import com.r4g3baby.simplescore.core.scoreboard.condition.Negate;
import com.r4g3baby.simplescore.core.scoreboard.line.AnimatedLine;
import com.r4g3baby.simplescore.core.scoreboard.line.BlankLine;
import com.r4g3baby.simplescore.core.scoreboard.line.StaticLine;
import com.r4g3baby.simplescore.lib.jetbrains.annotations.NotNull;
import com.r4g3baby.simplescore.lib.jetbrains.annotations.Nullable;
import com.r4g3baby.simplescore.lib.kotlin.Metadata;
import com.r4g3baby.simplescore.lib.kotlin.collections.CollectionsKt;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.DefaultConstructorMarker;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.Intrinsics;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.SourceDebugExtension;
import com.r4g3baby.simplescore.lib.kotlin.text.StringsKt;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0014J0\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00160\u0015*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J0\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u001e0\u0015*\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u001e*\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\"\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\u001e*\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u0018\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020#0\u0015*\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006$"}, d2={"Lcom/r4g3baby/simplescore/bukkit/config/ScoreboardsConfig;", "Lcom/r4g3baby/simplescore/core/config/BaseScoreboardsConfig;", "Lorg/bukkit/entity/Player;", "Lorg/bukkit/configuration/file/YamlConfiguration;", "plugin", "Lcom/r4g3baby/simplescore/BukkitPlugin;", "mainConfig", "Lcom/r4g3baby/simplescore/bukkit/config/MainConfig;", "<init>", "(Lcom/r4g3baby/simplescore/BukkitPlugin;Lcom/r4g3baby/simplescore/bukkit/config/MainConfig;)V", "resourceName", "", "getResourceName", "()Ljava/lang/String;", "parseConfigFile", "reader", "Ljava/io/Reader;", "loadVariables", "", "config", "parseScoreboardScores", "", "Lcom/r4g3baby/simplescore/core/scoreboard/ScoreboardScore;", "Lorg/bukkit/configuration/ConfigurationSection;", "defaultHideNumber", "", "defaultVisibleFor", "", "defaultRenderEvery", "parseScoreboardLines", "Lcom/r4g3baby/simplescore/api/scoreboard/ScoreboardLine;", "path", "parseStaticLine", "parseAnimatedLine", "parseConditions", "Lcom/r4g3baby/simplescore/api/scoreboard/condition/Condition;", "bukkit"})
@SourceDebugExtension(value={"SMAP\nScoreboardsConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScoreboardsConfig.kt\ncom/r4g3baby/simplescore/bukkit/config/ScoreboardsConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,230:1\n1869#2,2:231\n1878#2,2:233\n1880#2:237\n1869#2,2:238\n1761#2,3:240\n1878#2,2:243\n1880#2:247\n1563#2:248\n1634#2,3:249\n1878#2,3:252\n1617#2,9:255\n1869#2:264\n1870#2:266\n1626#2:267\n216#3,2:235\n216#3,2:245\n1#4:265\n1#4:268\n*S KotlinDebug\n*F\n+ 1 ScoreboardsConfig.kt\ncom/r4g3baby/simplescore/bukkit/config/ScoreboardsConfig\n*L\n34#1:231,2\n54#1:233,2\n54#1:237\n77#1:238,2\n107#1:240,3\n109#1:243,2\n109#1:247\n127#1:248\n127#1:249,3\n175#1:252,3\n220#1:255,9\n220#1:264\n220#1:266\n220#1:267\n56#1:235,2\n120#1:245,2\n220#1:265\n*E\n"})
public final class ScoreboardsConfig
extends BaseScoreboardsConfig<Player, YamlConfiguration> {
    @NotNull
    private final BukkitPlugin plugin;
    @NotNull
    private final MainConfig mainConfig;
    @NotNull
    private final String resourceName;

    public ScoreboardsConfig(@NotNull BukkitPlugin plugin, @NotNull MainConfig mainConfig) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(mainConfig, "mainConfig");
        super(plugin.getDataFolder());
        this.plugin = plugin;
        this.mainConfig = mainConfig;
        this.resourceName = "configs/scoreboards.yml";
    }

    @Override
    @NotNull
    protected String getResourceName() {
        return this.resourceName;
    }

    @Override
    @NotNull
    protected YamlConfiguration parseConfigFile(@Nullable Reader reader) {
        YamlConfiguration yamlConfiguration;
        if (reader != null) {
            YamlConfiguration yamlConfiguration2 = YamlConfiguration.loadConfiguration((Reader)reader);
            Intrinsics.checkNotNull(yamlConfiguration2);
            yamlConfiguration = yamlConfiguration2;
        } else {
            yamlConfiguration = new YamlConfiguration();
        }
        return yamlConfiguration;
    }

    @Override
    protected void loadVariables(@NotNull YamlConfiguration config) {
        Intrinsics.checkNotNullParameter(config, "config");
        Set set = config.getKeys(false);
        Intrinsics.checkNotNullExpressionValue(set, "getKeys(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConfigurationSection section;
            String name = (String)element$iv;
            boolean bl = false;
            if (config.getConfigurationSection(name) == null) continue;
            boolean defaultHideNumber = section.getBoolean("defaultHideNumber", false);
            int defaultVisibleFor = section.getInt("defaultVisibleFor", 20);
            int defaultRenderEvery = section.getInt("defaultRenderEvery", 10);
            List<ScoreboardLine<Player>> titles = this.parseScoreboardLines(section, "titles", defaultVisibleFor, defaultRenderEvery);
            List<ScoreboardScore<Player>> scores = this.parseScoreboardScores(section, defaultHideNumber, defaultVisibleFor, defaultRenderEvery);
            List<Condition<Player>> conditions = this.parseConditions(section);
            Map<String, Scoreboard<Scoreboard<Player>>> map = this.getScoreboards();
            Intrinsics.checkNotNull(name);
            map.put(name, new Scoreboard<Player>(name, titles, scores, conditions));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<ScoreboardScore<Player>> parseScoreboardScores(ConfigurationSection $this$parseScoreboardScores, boolean defaultHideNumber, int defaultVisibleFor, int defaultRenderEvery) {
        List list;
        if ($this$parseScoreboardScores.isList("scores")) {
            List list2;
            List scoresMapList = $this$parseScoreboardScores.getMapList("scores");
            List scores = list2 = (List)new ArrayList();
            boolean bl = false;
            Intrinsics.checkNotNull(scoresMapList);
            Iterable $this$forEachIndexed$iv = scoresMapList;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void scoreMap;
                ConfigurationSection configurationSection;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Map map = (Map)item$iv;
                int i = n;
                boolean bl2 = false;
                ConfigurationSection $this$parseScoreboardScores_u24lambda_u245_u24lambda_u244_u24lambda_u242 = configurationSection = new MemoryConfiguration().createSection($this$parseScoreboardScores.getCurrentPath() + ".scores[" + i + ']');
                boolean bl3 = false;
                Intrinsics.checkNotNull(scoreMap);
                void $this$forEach$iv = scoreMap;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator2.next();
                    boolean bl4 = false;
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    $this$parseScoreboardScores_u24lambda_u245_u24lambda_u244_u24lambda_u242.addDefault(String.valueOf(key), value);
                }
                ConfigurationSection scoreSec = configurationSection;
                Object object = scoreSec.get("score");
                if (object == null || (object = object.toString()) == null) {
                    ConfigurationSection $this$parseScoreboardScores_u24lambda_u245_u24lambda_u244_u24lambda_u243 = $this$parseScoreboardScores;
                    boolean bl5 = false;
                    this.plugin.getLogger().warning("Missing 'score' value for '" + scoreSec.getCurrentPath() + "'.");
                    continue;
                }
                Object score = object;
                Intrinsics.checkNotNull(scoreSec);
                List<ScoreboardLine<Player>> lines = this.parseScoreboardLines(scoreSec, "lines", defaultVisibleFor, defaultRenderEvery);
                List<Condition<Player>> conditions = this.parseConditions(scoreSec);
                Object hideNumber = scoreSec.get("hideNumber");
                if (!(hideNumber instanceof Boolean)) {
                    hideNumber = defaultHideNumber;
                }
                scores.add(new ScoreboardScore<Player>((String)score, lines, (boolean)((Boolean)hideNumber), conditions));
            }
            list = list2;
        } else if ($this$parseScoreboardScores.isConfigurationSection("scores")) {
            List list3;
            ConfigurationSection section = $this$parseScoreboardScores.getConfigurationSection("scores");
            List scores = list3 = (List)new ArrayList();
            boolean bl = false;
            Set set = section.getKeys(false);
            Intrinsics.checkNotNullExpressionValue(set, "getKeys(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ConfigurationSection scoreSec;
                String score = (String)element$iv;
                boolean bl6 = false;
                if (section.getConfigurationSection(score) == null) {
                    ConfigurationSection $this$parseScoreboardScores_u24lambda_u248_u24lambda_u247_u24lambda_u246 = $this$parseScoreboardScores;
                    boolean bl7 = false;
                    Intrinsics.checkNotNull(section);
                    Intrinsics.checkNotNull(score);
                    List<ScoreboardLine<Player>> lines = this.parseScoreboardLines(section, score, defaultVisibleFor, defaultRenderEvery);
                    scores.add(new ScoreboardScore(score, lines, false, null, 12, null));
                    continue;
                }
                List<ScoreboardLine<Player>> lines = this.parseScoreboardLines(scoreSec, "lines", defaultVisibleFor, defaultRenderEvery);
                boolean hideNumber = scoreSec.getBoolean("hideNumber", defaultHideNumber);
                List<Condition<Player>> conditions = this.parseConditions(scoreSec);
                Intrinsics.checkNotNull(score);
                scores.add(new ScoreboardScore<Player>(score, lines, hideNumber, conditions));
            }
            list = list3;
        } else {
            this.plugin.getLogger().warning("Invalid or missing 'scores' value for '" + $this$parseScoreboardScores.getCurrentPath() + "'.");
            return CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ScoreboardLine<Player>> parseScoreboardLines(ConfigurationSection $this$parseScoreboardLines, String path, int defaultVisibleFor, int defaultRenderEvery) {
        Iterable<ScoreboardLine<Object>> iterable;
        if ($this$parseScoreboardLines.isString(path)) {
            String text = $this$parseScoreboardLines.getString(path);
            Intrinsics.checkNotNull(text);
            iterable = CollectionsKt.listOf(StringsKt.isBlank(text) ? (com.r4g3baby.simplescore.core.scoreboard.line.ScoreboardLine)new BlankLine(null, 1, null) : (com.r4g3baby.simplescore.core.scoreboard.line.ScoreboardLine)new StaticLine(text, defaultRenderEvery, null, null, 12, null));
        } else if ($this$parseScoreboardLines.isList(path)) {
            boolean bl;
            Iterable $this$any$iv;
            block18: {
                List list = $this$parseScoreboardLines.getList(path);
                Intrinsics.checkNotNullExpressionValue(list, "getList(...)");
                $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv;
                        Object it = element$iv = iterator2.next();
                        boolean bl2 = false;
                        if (!(!(it instanceof String))) continue;
                        bl = true;
                        break block18;
                    }
                    bl = false;
                }
            }
            if (bl) {
                Iterable lineList = $this$any$iv = (List)new ArrayList();
                boolean bl3 = false;
                List list = $this$parseScoreboardLines.getList(path);
                Intrinsics.checkNotNullExpressionValue(list, "getList(...)");
                Iterable $this$forEachIndexed$iv = list;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    boolean bl4;
                    ConfigurationSection configurationSection;
                    void line;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object t = item$iv;
                    int i = n;
                    boolean bl5 = false;
                    if (!(line instanceof Map)) {
                        if (line instanceof String) {
                            lineList.add(new StaticLine((String)line, defaultRenderEvery, null, null, 12, null));
                            continue;
                        }
                        this.plugin.getLogger().warning("Invalid frame value for '" + $this$parseScoreboardLines.getCurrentPath() + '.' + path + '[' + i + "]'.");
                        continue;
                    }
                    ConfigurationSection $this$parseScoreboardLines_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411 = configurationSection = new MemoryConfiguration().createSection($this$parseScoreboardLines.getCurrentPath() + '.' + path + '[' + i + ']');
                    boolean bl6 = false;
                    Map $this$forEach$iv = (Map)line;
                    boolean $i$f$forEach = false;
                    Iterator iterator3 = $this$forEach$iv.entrySet().iterator();
                    while (iterator3.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry entry = element$iv = iterator3.next();
                        boolean bl7 = false;
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        $this$parseScoreboardLines_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.addDefault(String.valueOf(key), value);
                    }
                    ConfigurationSection section = configurationSection;
                    if (section.contains("frames")) {
                        Intrinsics.checkNotNull(section);
                        bl4 = lineList.add(this.parseAnimatedLine(section, defaultVisibleFor, defaultRenderEvery));
                        continue;
                    }
                    Intrinsics.checkNotNull(section);
                    bl4 = lineList.add(this.parseStaticLine(section, defaultRenderEvery));
                }
                iterable = $this$any$iv;
            } else {
                void $this$mapTo$iv$iv;
                List list = $this$parseScoreboardLines.getStringList(path);
                Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable bl3 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String item$iv = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl8 = false;
                    Intrinsics.checkNotNull(it);
                    collection.add(new AnimatedLine.Frame((String)it, defaultVisibleFor, defaultRenderEvery));
                }
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 6;
                List list2 = null;
                List list3 = null;
                List list4 = (List)destination$iv$iv;
                iterable = CollectionsKt.listOf(new AnimatedLine(list4, list3, list2, n, defaultConstructorMarker));
            }
        } else if ($this$parseScoreboardLines.isConfigurationSection(path)) {
            iterable = $this$parseScoreboardLines.contains("frames") ? CollectionsKt.listOf(this.parseAnimatedLine($this$parseScoreboardLines, defaultVisibleFor, defaultRenderEvery)) : CollectionsKt.listOf(this.parseStaticLine($this$parseScoreboardLines, defaultRenderEvery));
        } else {
            this.plugin.getLogger().warning("Invalid or missing '" + path + "' value for '" + $this$parseScoreboardLines.getCurrentPath() + "'.");
            return CollectionsKt.emptyList();
        }
        return iterable;
    }

    private final ScoreboardLine<Player> parseStaticLine(ConfigurationSection $this$parseStaticLine, int defaultRenderEvery) {
        List textEffects = CollectionsKt.emptyList();
        List<Condition<Player>> conditions = this.parseConditions($this$parseStaticLine);
        String string = $this$parseStaticLine.getString("text");
        if (string == null) {
            ConfigurationSection $this$parseStaticLine_u24lambda_u2415 = $this$parseStaticLine;
            boolean bl = false;
            this.plugin.getLogger().warning("Missing 'text' value for '" + $this$parseStaticLine_u24lambda_u2415.getCurrentPath() + "'.");
            return new BlankLine<Player>(conditions);
        }
        String text = string;
        Object renderEvery = $this$parseStaticLine.get("renderEvery");
        if (!(renderEvery instanceof Integer)) {
            renderEvery = defaultRenderEvery;
        }
        return !StringsKt.isBlank(text) ? (ScoreboardLine)new StaticLine<Player>(text, ((Number)renderEvery).intValue(), textEffects, conditions) : (ScoreboardLine)new BlankLine<Player>(conditions);
    }

    /*
     * WARNING - void declaration
     */
    private final ScoreboardLine<Player> parseAnimatedLine(ConfigurationSection $this$parseAnimatedLine, int defaultVisibleFor, int defaultRenderEvery) {
        List textEffects = CollectionsKt.emptyList();
        List<Condition<Player>> conditions = this.parseConditions($this$parseAnimatedLine);
        List list = $this$parseAnimatedLine.getList("frames");
        if (list == null) {
            ConfigurationSection $this$parseAnimatedLine_u24lambda_u2416 = $this$parseAnimatedLine;
            boolean bl = false;
            if ($this$parseAnimatedLine_u24lambda_u2416.isString("frames")) {
                String string = $this$parseAnimatedLine_u24lambda_u2416.getString("frames");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                return new StaticLine<Player>(string, defaultRenderEvery, textEffects, conditions);
            }
            this.plugin.getLogger().warning("Missing 'frames' value for '" + $this$parseAnimatedLine_u24lambda_u2416.getCurrentPath() + "'.");
            return new BlankLine<Player>(conditions);
        }
        List textFrames = list;
        List frames = new ArrayList();
        Iterable $this$forEachIndexed$iv = textFrames;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void frame;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv;
            int i = n;
            boolean bl = false;
            void var17_19 = frame;
            if (var17_19 instanceof String) {
                frames.add(new AnimatedLine.Frame((String)frame, defaultVisibleFor, defaultRenderEvery));
                continue;
            }
            if (var17_19 instanceof Map) {
                Object text;
                Object renderEvery;
                Object visibleFor = ((Map)frame).get("visibleFor");
                if (!(visibleFor instanceof Integer)) {
                    visibleFor = defaultVisibleFor;
                }
                if (!((renderEvery = ((Map)frame).get("renderEvery")) instanceof Integer)) {
                    renderEvery = defaultRenderEvery;
                }
                if (((Map)frame).get("text") == null) {
                    ConfigurationSection $this$parseAnimatedLine_u24lambda_u2418_u24lambda_u2417 = $this$parseAnimatedLine;
                    boolean bl2 = false;
                    this.plugin.getLogger().warning("Missing text value for frame '" + $this$parseAnimatedLine_u24lambda_u2418_u24lambda_u2417.getCurrentPath() + '[' + i + "]'.");
                    continue;
                }
                frames.add(new AnimatedLine.Frame(text.toString(), ((Number)visibleFor).intValue(), ((Number)renderEvery).intValue()));
                continue;
            }
            this.plugin.getLogger().warning("Invalid frame value for '" + $this$parseAnimatedLine.getCurrentPath() + '[' + i + "]'.");
        }
        return new AnimatedLine<Player>(frames, textEffects, conditions);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Condition<Player>> parseConditions(ConfigurationSection $this$parseConditions) {
        List list;
        if ($this$parseConditions.isString("conditions")) {
            String name = $this$parseConditions.getString("conditions");
            Intrinsics.checkNotNull(name);
            Condition<Player> condition = ScoreboardsConfig.parseConditions$getCondition(this, name);
            if (condition == null) {
                ConfigurationSection $this$parseConditions_u24lambda_u2420 = $this$parseConditions;
                boolean bl = false;
                this.plugin.getLogger().warning("Unknown condition '" + name + "' in '" + $this$parseConditions_u24lambda_u2420.getCurrentPath() + ".conditions'.");
                return CollectionsKt.emptyList();
            }
            list = CollectionsKt.listOf(condition);
        } else if ($this$parseConditions.isList("conditions")) {
            void $this$mapNotNullTo$iv$iv;
            List list2 = $this$parseConditions.getStringList("conditions");
            Intrinsics.checkNotNullExpressionValue(list2, "getStringList(...)");
            Iterable $this$mapNotNull$iv = list2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull(it);
                Condition<Player> condition = ScoreboardsConfig.parseConditions$getCondition(this, it);
                if (condition == null) {
                    ConfigurationSection $this$parseConditions_u24lambda_u2422_u24lambda_u2421 = $this$parseConditions;
                    boolean bl3 = false;
                    this.plugin.getLogger().warning("Unknown condition '" + it + "' in '" + $this$parseConditions_u24lambda_u2422_u24lambda_u2421.getCurrentPath() + ".conditions'.");
                    condition = null;
                }
                if (condition == null) continue;
                Condition<Player> it$iv$iv = condition;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final Condition<Player> parseConditions$getCondition(ScoreboardsConfig this$0, String name) {
        Condition condition;
        if (StringsKt.startsWith$default(name, "!", false, 2, null)) {
            Negate negate;
            String string = name.substring(1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String name2 = string;
            Condition condition2 = this$0.mainConfig.getConditions().get(name2);
            if (condition2 != null) {
                Condition it = condition2;
                boolean bl = false;
                negate = new Negate(it);
            } else {
                negate = null;
            }
            condition = negate;
        } else {
            condition = this$0.mainConfig.getConditions().get(name);
        }
        return condition;
    }
}

