/*
 * Decompiled with CFR 0.152.
 */
package com.r4g3baby.simplescore.bukkit.scoreboard.data;

import com.r4g3baby.simplescore.api.scoreboard.Scoreboard;
import com.r4g3baby.simplescore.api.scoreboard.data.Priority;
import com.r4g3baby.simplescore.api.scoreboard.data.Provider;
import com.r4g3baby.simplescore.lib.jetbrains.annotations.NotNull;
import com.r4g3baby.simplescore.lib.jetbrains.annotations.Nullable;
import com.r4g3baby.simplescore.lib.kotlin.Metadata;
import com.r4g3baby.simplescore.lib.kotlin.jvm.functions.Function2;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.Intrinsics;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.SourceDebugExtension;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.entity.Player;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001/B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\bJ(\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00122\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00122\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u0018\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00122\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u001a\u0010 \u001a\u00020\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\rH\u0016J\b\u0010%\u001a\u00020\u001bH\u0002J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u00c6\u0003J\u0019\u0010'\u001a\u00020\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u00c6\u0001J\u0013\u0010(\u001a\u00020\u00142\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020.H\u00d6\u0001R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00060"}, d2={"Lcom/r4g3baby/simplescore/bukkit/scoreboard/data/Viewer;", "Lcom/r4g3baby/simplescore/api/scoreboard/data/Viewer;", "Lorg/bukkit/entity/Player;", "reference", "Ljava/lang/ref/WeakReference;", "<init>", "(Ljava/lang/ref/WeakReference;)V", "player", "(Lorg/bukkit/entity/Player;)V", "getReference", "()Ljava/lang/ref/WeakReference;", "entries", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/r4g3baby/simplescore/api/scoreboard/data/Provider;", "Lcom/r4g3baby/simplescore/bukkit/scoreboard/data/Viewer$ScoreboardEntry;", "hiding", "Ljava/util/concurrent/CopyOnWriteArrayList;", "cachedScoreboard", "Lcom/r4g3baby/simplescore/api/scoreboard/Scoreboard;", "isCacheDirty", "", "scoreboard", "getScoreboard", "()Lcom/r4g3baby/simplescore/api/scoreboard/Scoreboard;", "isScoreboardHidden", "()Z", "setScoreboard", "", "provider", "priority", "Lcom/r4g3baby/simplescore/api/scoreboard/data/Priority;", "removeScoreboard", "setPriority", "getPriority", "hideScoreboard", "showScoreboard", "isHidingScoreboard", "invalidateCache", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "ScoreboardEntry", "bukkit"})
@SourceDebugExtension(value={"SMAP\nViewer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Viewer.kt\ncom/r4g3baby/simplescore/bukkit/scoreboard/data/Viewer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1999#2,14:80\n*S KotlinDebug\n*F\n+ 1 Viewer.kt\ncom/r4g3baby/simplescore/bukkit/scoreboard/data/Viewer\n*L\n30#1:80,14\n*E\n"})
public final class Viewer
implements com.r4g3baby.simplescore.api.scoreboard.data.Viewer<Player> {
    @NotNull
    private final WeakReference<Player> reference;
    @NotNull
    private final ConcurrentHashMap<Provider, ScoreboardEntry> entries;
    @NotNull
    private final CopyOnWriteArrayList<Provider> hiding;
    @Nullable
    private Scoreboard<Player> cachedScoreboard;
    private boolean isCacheDirty;

    public Viewer(@NotNull WeakReference<Player> reference) {
        Intrinsics.checkNotNullParameter(reference, "reference");
        this.reference = reference;
        this.entries = new ConcurrentHashMap();
        this.hiding = new CopyOnWriteArrayList();
        this.isCacheDirty = true;
    }

    @Override
    @NotNull
    public WeakReference<Player> getReference() {
        return this.reference;
    }

    public Viewer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this(new WeakReference<Player>(player));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Scoreboard<Player> getScoreboard() {
        if (this.isCacheDirty) {
            Object object;
            Object v1;
            void $this$maxByOrNull$iv;
            Set<Map.Entry<Provider, ScoreboardEntry>> set = this.entries.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, "<get-entries>(...)");
            Iterable iterable = set;
            Viewer viewer = this;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = maxElem$iv;
                } else {
                    Map.Entry it = (Map.Entry)maxElem$iv;
                    boolean bl = false;
                    Comparable maxValue$iv = (Comparable)((Object)((ScoreboardEntry)it.getValue()).getPriority());
                    do {
                        Object e$iv = iterator$iv.next();
                        Map.Entry it2 = (Map.Entry)e$iv;
                        $i$a$-maxByOrNull-Viewer$scoreboard$1 = false;
                        Comparable v$iv = (Comparable)((Object)((ScoreboardEntry)it2.getValue()).getPriority());
                        if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = maxElem$iv;
                }
            }
            viewer.cachedScoreboard = (object = (Map.Entry)v1) != null && (object = (ScoreboardEntry)object.getValue()) != null ? ((ScoreboardEntry)object).getScoreboard() : null;
            this.isCacheDirty = false;
        }
        return this.cachedScoreboard;
    }

    @Override
    public boolean isScoreboardHidden() {
        return !((Collection)this.hiding).isEmpty();
    }

    @Override
    public void setScoreboard(@Nullable Scoreboard<Player> scoreboard, @NotNull Provider provider, @NotNull Priority priority) {
        Intrinsics.checkNotNullParameter(provider, "provider");
        Intrinsics.checkNotNullParameter((Object)priority, "priority");
        ((Map)this.entries).put(provider, new ScoreboardEntry(scoreboard, priority));
        this.invalidateCache();
    }

    @Override
    @Nullable
    public Scoreboard<Player> getScoreboard(@NotNull Provider provider) {
        Intrinsics.checkNotNullParameter(provider, "provider");
        ScoreboardEntry scoreboardEntry = this.entries.get(provider);
        return scoreboardEntry != null ? scoreboardEntry.getScoreboard() : null;
    }

    @Override
    @Nullable
    public Scoreboard<Player> removeScoreboard(@NotNull Provider provider) {
        Intrinsics.checkNotNullParameter(provider, "provider");
        ScoreboardEntry removed = this.entries.remove(provider);
        if (removed != null) {
            this.invalidateCache();
        }
        ScoreboardEntry scoreboardEntry = removed;
        return scoreboardEntry != null ? scoreboardEntry.getScoreboard() : null;
    }

    @Override
    public void setPriority(@Nullable Priority priority, @NotNull Provider provider) {
        Intrinsics.checkNotNullParameter(provider, "provider");
        this.entries.computeIfPresent(provider, (arg_0, arg_1) -> Viewer.setPriority$lambda$2((arg_0, arg_1) -> Viewer.setPriority$lambda$1(priority, arg_0, arg_1), arg_0, arg_1));
        this.invalidateCache();
    }

    @Override
    @Nullable
    public Priority getPriority(@NotNull Provider provider) {
        Intrinsics.checkNotNullParameter(provider, "provider");
        ScoreboardEntry scoreboardEntry = this.entries.get(provider);
        return scoreboardEntry != null ? scoreboardEntry.getPriority() : null;
    }

    @Override
    public boolean hideScoreboard(@NotNull Provider provider) {
        Intrinsics.checkNotNullParameter(provider, "provider");
        return this.hiding.addIfAbsent(provider);
    }

    @Override
    public boolean showScoreboard(@NotNull Provider provider) {
        Intrinsics.checkNotNullParameter(provider, "provider");
        return this.hiding.remove(provider);
    }

    @Override
    public boolean isHidingScoreboard(@NotNull Provider provider) {
        Intrinsics.checkNotNullParameter(provider, "provider");
        return this.hiding.contains(provider);
    }

    private final void invalidateCache() {
        this.isCacheDirty = true;
    }

    @NotNull
    public final WeakReference<Player> component1() {
        return this.reference;
    }

    @NotNull
    public final Viewer copy(@NotNull WeakReference<Player> reference) {
        Intrinsics.checkNotNullParameter(reference, "reference");
        return new Viewer(reference);
    }

    public static /* synthetic */ Viewer copy$default(Viewer viewer, WeakReference weakReference, int n, Object object) {
        if ((n & 1) != 0) {
            weakReference = viewer.reference;
        }
        return viewer.copy(weakReference);
    }

    @NotNull
    public String toString() {
        return "Viewer(reference=" + this.reference + ')';
    }

    public int hashCode() {
        return this.reference.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Viewer)) {
            return false;
        }
        Viewer viewer = (Viewer)other;
        return Intrinsics.areEqual(this.reference, viewer.reference);
    }

    @Override
    public void setScoreboard(@Nullable Scoreboard<Player> scoreboard, @NotNull Provider provider) {
        com.r4g3baby.simplescore.api.scoreboard.data.Viewer.super.setScoreboard(scoreboard, provider);
    }

    private static final ScoreboardEntry setPriority$lambda$1(Priority $priority, Provider provider, ScoreboardEntry entry) {
        Intrinsics.checkNotNullParameter(provider, "<unused var>");
        Intrinsics.checkNotNullParameter(entry, "entry");
        Priority priority = $priority;
        if (priority == null) {
            priority = Priority.Normal;
        }
        return ScoreboardEntry.copy$default(entry, null, priority, 1, null);
    }

    private static final ScoreboardEntry setPriority$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return (ScoreboardEntry)$tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J%\u0010\u000f\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/r4g3baby/simplescore/bukkit/scoreboard/data/Viewer$ScoreboardEntry;", "", "scoreboard", "Lcom/r4g3baby/simplescore/api/scoreboard/Scoreboard;", "Lorg/bukkit/entity/Player;", "priority", "Lcom/r4g3baby/simplescore/api/scoreboard/data/Priority;", "<init>", "(Lcom/r4g3baby/simplescore/api/scoreboard/Scoreboard;Lcom/r4g3baby/simplescore/api/scoreboard/data/Priority;)V", "getScoreboard", "()Lcom/r4g3baby/simplescore/api/scoreboard/Scoreboard;", "getPriority", "()Lcom/r4g3baby/simplescore/api/scoreboard/data/Priority;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "bukkit"})
    private static final class ScoreboardEntry {
        @Nullable
        private final Scoreboard<Player> scoreboard;
        @NotNull
        private final Priority priority;

        public ScoreboardEntry(@Nullable Scoreboard<Player> scoreboard, @NotNull Priority priority) {
            Intrinsics.checkNotNullParameter((Object)priority, "priority");
            this.scoreboard = scoreboard;
            this.priority = priority;
        }

        @Nullable
        public final Scoreboard<Player> getScoreboard() {
            return this.scoreboard;
        }

        @NotNull
        public final Priority getPriority() {
            return this.priority;
        }

        @Nullable
        public final Scoreboard<Player> component1() {
            return this.scoreboard;
        }

        @NotNull
        public final Priority component2() {
            return this.priority;
        }

        @NotNull
        public final ScoreboardEntry copy(@Nullable Scoreboard<Player> scoreboard, @NotNull Priority priority) {
            Intrinsics.checkNotNullParameter((Object)priority, "priority");
            return new ScoreboardEntry(scoreboard, priority);
        }

        public static /* synthetic */ ScoreboardEntry copy$default(ScoreboardEntry scoreboardEntry, Scoreboard scoreboard, Priority priority, int n, Object object) {
            if ((n & 1) != 0) {
                scoreboard = scoreboardEntry.scoreboard;
            }
            if ((n & 2) != 0) {
                priority = scoreboardEntry.priority;
            }
            return scoreboardEntry.copy(scoreboard, priority);
        }

        @NotNull
        public String toString() {
            return "ScoreboardEntry(scoreboard=" + this.scoreboard + ", priority=" + (Object)((Object)this.priority) + ')';
        }

        public int hashCode() {
            int result = this.scoreboard == null ? 0 : this.scoreboard.hashCode();
            result = result * 31 + this.priority.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScoreboardEntry)) {
                return false;
            }
            ScoreboardEntry scoreboardEntry = (ScoreboardEntry)other;
            if (!Intrinsics.areEqual(this.scoreboard, scoreboardEntry.scoreboard)) {
                return false;
            }
            return this.priority == scoreboardEntry.priority;
        }
    }
}

