/*
 * Decompiled with CFR 0.152.
 */
package com.r4g3baby.simplescore.bukkit.util;

import com.r4g3baby.simplescore.bukkit.protocol.util.ServerVersion;
import com.r4g3baby.simplescore.core.util.Reflection;
import com.r4g3baby.simplescore.lib.jetbrains.annotations.NotNull;
import com.r4g3baby.simplescore.lib.jetbrains.annotations.Nullable;
import com.r4g3baby.simplescore.lib.kotlin.Metadata;
import com.r4g3baby.simplescore.lib.kotlin.Pair;
import com.r4g3baby.simplescore.lib.kotlin.TuplesKt;
import com.r4g3baby.simplescore.lib.kotlin.collections.MapsKt;
import com.r4g3baby.simplescore.lib.kotlin.internal.ProgressionUtilKt;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.Intrinsics;
import java.util.Map;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/r4g3baby/simplescore/bukkit/util/Adventure;", "", "<init>", "()V", "miniMessage", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "textSerializer", "Lnet/kyori/adventure/text/serializer/legacy/LegacyComponentSerializer;", "parseToString", "", "text", "namedToMiniTag", "", "", "vanillaToMini", "bukkit"})
public final class Adventure {
    @NotNull
    public static final Adventure INSTANCE;
    @Nullable
    private static final MiniMessage miniMessage;
    @Nullable
    private static final LegacyComponentSerializer textSerializer;
    @NotNull
    private static final Map<Character, String> namedToMiniTag;

    private Adventure() {
    }

    @NotNull
    public final String parseToString(@NotNull String text) {
        String string;
        Intrinsics.checkNotNullParameter(text, "text");
        if (textSerializer != null && miniMessage != null) {
            String string2 = textSerializer.serialize(miniMessage.deserialize((Object)this.vanillaToMini(text)));
            Intrinsics.checkNotNull(string2);
            string = string2;
        } else {
            string = text;
        }
        return string;
    }

    private final String vanillaToMini(String text) {
        if (text.length() <= 1) {
            return text;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '\u00a7' && i + 1 < text.length()) {
                String tagName;
                char nextChar = Character.toLowerCase(text.charAt(i + 1));
                if (nextChar == 'x' && i + 14 <= text.length()) {
                    StringBuilder hexCode = new StringBuilder();
                    boolean validHex = true;
                    int j = 3;
                    int n = ProgressionUtilKt.getProgressionLastElement(3, 13, 2);
                    if (j <= n) {
                        while (true) {
                            if (!('0' <= (char = Character.toLowerCase(text.charAt(i + j))) ? char < ':' : false)) {
                                boolean bl = 'a' <= char ? char < 'g' : false;
                                if (bl) {
                                } else {
                                    validHex = false;
                                    break;
                                }
                            }
                            hexCode.append(text.charAt(i + j));
                            if (j == n) break;
                            j += 2;
                        }
                    }
                    if (validHex) {
                        result.append("<#" + hexCode + '>');
                        i += 14;
                        continue;
                    }
                }
                if ((tagName = namedToMiniTag.get(Character.valueOf(nextChar))) != null) {
                    result.append('<' + tagName + '>');
                    i += 2;
                    continue;
                }
            }
            result.append(c);
            ++i;
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    static {
        boolean isAdventureSupported;
        INSTANCE = new Adventure();
        boolean bl = isAdventureSupported = Reflection.INSTANCE.classExists("net.kyori.adventure.text.minimessage.MiniMessage") && Reflection.INSTANCE.classExists("net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer");
        if (isAdventureSupported) {
            miniMessage = MiniMessage.builder().strict(false).build();
            LegacyComponentSerializer.Builder builder = LegacyComponentSerializer.builder().character('\u00a7');
            Intrinsics.checkNotNullExpressionValue(builder, "character(...)");
            LegacyComponentSerializer.Builder legacySerializerBuilder = builder;
            boolean hexColorsSupported = ServerVersion.Companion.atOrAbove(ServerVersion.Companion.getNetherUpdate());
            textSerializer = hexColorsSupported ? legacySerializerBuilder.useUnusualXRepeatedCharacterHexFormat().hexColors().build() : legacySerializerBuilder.build();
        } else {
            miniMessage = null;
            textSerializer = null;
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to(Character.valueOf('0'), "black"), TuplesKt.to(Character.valueOf('1'), "dark_blue"), TuplesKt.to(Character.valueOf('2'), "dark_green"), TuplesKt.to(Character.valueOf('3'), "dark_aqua"), TuplesKt.to(Character.valueOf('4'), "dark_red"), TuplesKt.to(Character.valueOf('5'), "dark_purple"), TuplesKt.to(Character.valueOf('6'), "gold"), TuplesKt.to(Character.valueOf('7'), "gray"), TuplesKt.to(Character.valueOf('8'), "dark_gray"), TuplesKt.to(Character.valueOf('9'), "blue"), TuplesKt.to(Character.valueOf('a'), "green"), TuplesKt.to(Character.valueOf('b'), "aqua"), TuplesKt.to(Character.valueOf('c'), "red"), TuplesKt.to(Character.valueOf('d'), "light_purple"), TuplesKt.to(Character.valueOf('e'), "yellow"), TuplesKt.to(Character.valueOf('f'), "white"), TuplesKt.to(Character.valueOf('k'), "obf"), TuplesKt.to(Character.valueOf('l'), "b"), TuplesKt.to(Character.valueOf('m'), "st"), TuplesKt.to(Character.valueOf('n'), "u"), TuplesKt.to(Character.valueOf('o'), "i"), TuplesKt.to(Character.valueOf('r'), "reset")};
        namedToMiniTag = MapsKt.mapOf(pairArray);
    }
}

