/*
 * Decompiled with CFR 0.152.
 */
package com.r4g3baby.simplescore.core.i18n;

import com.r4g3baby.simplescore.api.Platform;
import com.r4g3baby.simplescore.core.util.ColorsKt;
import com.r4g3baby.simplescore.lib.jetbrains.annotations.NotNull;
import com.r4g3baby.simplescore.lib.jetbrains.annotations.Nullable;
import com.r4g3baby.simplescore.lib.kotlin.Metadata;
import com.r4g3baby.simplescore.lib.kotlin.io.CloseableKt;
import com.r4g3baby.simplescore.lib.kotlin.jvm.functions.Function1;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.Intrinsics;
import com.r4g3baby.simplescore.lib.kotlin.text.Charsets;
import com.r4g3baby.simplescore.lib.kotlin.text.StringsKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0003\u0019\u001a\u001bB\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J1\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0012\"\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/r4g3baby/simplescore/core/i18n/I18n;", "V", "", "Lcom/r4g3baby/simplescore/api/i18n/I18n;", "platform", "Lcom/r4g3baby/simplescore/api/Platform;", "<init>", "(Lcom/r4g3baby/simplescore/api/Platform;)V", "defaultBundle", "Ljava/util/ResourceBundle;", "customBundle", "messageFormatCache", "Ljava/util/HashMap;", "", "Ljava/text/MessageFormat;", "trans", "key", "args", "", "prefixed", "", "(Ljava/lang/String;[Ljava/lang/Object;Z)Ljava/lang/String;", "loadTranslations", "", "language", "PluginResClassLoader", "UTF8PropertiesControl", "NullBundle", "core"})
public final class I18n<V>
implements com.r4g3baby.simplescore.api.i18n.I18n {
    @NotNull
    private final Platform<V> platform;
    private ResourceBundle defaultBundle;
    private ResourceBundle customBundle;
    @NotNull
    private final HashMap<String, MessageFormat> messageFormatCache;

    public I18n(@NotNull Platform<V> platform) {
        Intrinsics.checkNotNullParameter(platform, "platform");
        this.platform = platform;
        this.messageFormatCache = new HashMap();
    }

    @Override
    @NotNull
    public String trans(@NotNull String key, @NotNull Object[] args, boolean prefixed) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(args, "args");
        String prefix = prefixed ? this.trans("prefix", new Object[0], false) : null;
        StringBuilder $this$trans_u24lambda_u240 = charSequence = new StringBuilder();
        boolean bl = false;
        String string = prefix;
        boolean bl2 = string != null ? !StringsKt.isBlank(string) : false;
        if (bl2) {
            String[] stringArray = new String[]{prefix, " "};
            StringsKt.append($this$trans_u24lambda_u240, stringArray);
        }
        try {
            try {
                ResourceBundle resourceBundle = this.customBundle;
                if (resourceBundle == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("customBundle");
                    resourceBundle = null;
                }
                $this$trans_u24lambda_u240.append(resourceBundle.getString(key));
            }
            catch (MissingResourceException missingResourceException) {
                ResourceBundle resourceBundle = this.defaultBundle;
                if (resourceBundle == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("defaultBundle");
                    resourceBundle = null;
                }
                $this$trans_u24lambda_u240.append(resourceBundle.getString(key));
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.platform.getLogger().warning("Missing translation key: " + key + '.');
        }
        String translation = ColorsKt.translateColorCodes(charSequence.toString());
        if (args.length == 0) {
            return translation;
        }
        charSequence = this.messageFormatCache.computeIfAbsent(translation, arg_0 -> I18n.trans$lambda$2(arg_0 -> I18n.trans$lambda$1(translation, arg_0), arg_0)).format(args);
        Intrinsics.checkNotNullExpressionValue(charSequence, "format(...)");
        return charSequence;
    }

    public final void loadTranslations(@NotNull String language) {
        I18n i18n;
        ResourceBundle resourceBundle;
        I18n i18n2;
        Locale locale;
        Intrinsics.checkNotNullParameter(language, "language");
        String[] stringArray = new String[]{"_", "-", ".", "\\", "/"};
        List parts = StringsKt.split$default((CharSequence)language, stringArray, false, 0, 6, null);
        switch (parts.size()) {
            case 1: {
                locale = new Locale((String)parts.get(0));
                break;
            }
            case 2: {
                locale = new Locale((String)parts.get(0), (String)parts.get(1));
                break;
            }
            case 3: {
                locale = new Locale((String)parts.get(0), (String)parts.get(1), (String)parts.get(2));
                break;
            }
            default: {
                locale = new Locale(language);
            }
        }
        Locale locale2 = locale;
        ResourceBundle.clearCache();
        I18n i18n3 = this;
        try {
            i18n2 = i18n3;
            resourceBundle = ResourceBundle.getBundle("lang/messages", locale2, UTF8PropertiesControl.INSTANCE);
        }
        catch (MissingResourceException missingResourceException) {
            i18n2 = i18n3;
            resourceBundle = NullBundle.INSTANCE;
        }
        ResourceBundle resourceBundle2 = resourceBundle;
        Intrinsics.checkNotNull(resourceBundle2);
        i18n2.defaultBundle = resourceBundle2;
        i18n3 = this;
        try {
            i18n = i18n3;
            resourceBundle = ResourceBundle.getBundle("messages", locale2, new PluginResClassLoader<V>(this.platform), UTF8PropertiesControl.INSTANCE);
        }
        catch (MissingResourceException missingResourceException) {
            i18n = i18n3;
            resourceBundle = NullBundle.INSTANCE;
        }
        resourceBundle2 = resourceBundle;
        Intrinsics.checkNotNull(resourceBundle2);
        i18n.customBundle = resourceBundle2;
    }

    @Override
    @NotNull
    public String t(@NotNull String key, @NotNull Object[] args, boolean prefixed) {
        return com.r4g3baby.simplescore.api.i18n.I18n.super.t(key, args, prefixed);
    }

    private static final MessageFormat trans$lambda$1(String $translation, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new MessageFormat($translation);
    }

    private static final MessageFormat trans$lambda$2(Function1 $tmp0, Object p0) {
        return (MessageFormat)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c2\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0016J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0007H\u00d6\u0001\u00a8\u0006\u0010"}, d2={"Lcom/r4g3baby/simplescore/core/i18n/I18n$NullBundle;", "Ljava/util/ResourceBundle;", "<init>", "()V", "handleGetObject", "", "key", "", "getKeys", "Ljava/util/Enumeration;", "equals", "", "other", "hashCode", "", "toString", "core"})
    private static final class NullBundle
    extends ResourceBundle {
        @NotNull
        public static final NullBundle INSTANCE = new NullBundle();

        private NullBundle() {
        }

        @Override
        @Nullable
        protected Object handleGetObject(@NotNull String key) {
            Intrinsics.checkNotNullParameter(key, "key");
            return null;
        }

        @Override
        @NotNull
        public Enumeration<String> getKeys() {
            Enumeration<String> enumeration = Collections.emptyEnumeration();
            Intrinsics.checkNotNullExpressionValue(enumeration, "emptyEnumeration(...)");
            return enumeration;
        }

        @NotNull
        public String toString() {
            return "NullBundle";
        }

        public int hashCode() {
            return -615132371;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NullBundle)) {
                return false;
            }
            NullBundle cfr_ignored_0 = (NullBundle)other;
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/r4g3baby/simplescore/core/i18n/I18n$PluginResClassLoader;", "V", "", "Ljava/lang/ClassLoader;", "platform", "Lcom/r4g3baby/simplescore/api/Platform;", "<init>", "(Lcom/r4g3baby/simplescore/api/Platform;)V", "dataFolder", "Ljava/io/File;", "getResource", "Ljava/net/URL;", "name", "", "getResourceAsStream", "Ljava/io/InputStream;", "core"})
    private static final class PluginResClassLoader<V>
    extends ClassLoader {
        @NotNull
        private final File dataFolder;

        public PluginResClassLoader(@NotNull Platform<V> platform) {
            Intrinsics.checkNotNullParameter(platform, "platform");
            super(platform.getClass().getClassLoader());
            this.dataFolder = platform.getDataFolder();
        }

        @Override
        @Nullable
        public URL getResource(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            File file = new File(this.dataFolder, name);
            if (file.exists()) {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        @Nullable
        public InputStream getResourceAsStream(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            File file = new File(this.dataFolder, name);
            if (file.exists()) {
                return new FileInputStream(file);
            }
            return null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/r4g3baby/simplescore/core/i18n/I18n$UTF8PropertiesControl;", "Ljava/util/ResourceBundle$Control;", "<init>", "()V", "newBundle", "Ljava/util/ResourceBundle;", "baseName", "", "locale", "Ljava/util/Locale;", "format", "loader", "Ljava/lang/ClassLoader;", "reload", "", "toString", "core"})
    private static final class UTF8PropertiesControl
    extends ResourceBundle.Control {
        @NotNull
        public static final UTF8PropertiesControl INSTANCE = new UTF8PropertiesControl();

        private UTF8PropertiesControl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public ResourceBundle newBundle(@Nullable String baseName, @Nullable Locale locale, @Nullable String format, @Nullable ClassLoader loader, boolean reload) {
            String resourceName = this.toResourceName(this.toBundleName(baseName, locale), "properties");
            InputStream stream = null;
            if (reload) {
                URLConnection connection;
                URL url;
                ClassLoader classLoader = loader;
                URL uRL = url = classLoader != null ? classLoader.getResource(resourceName) : null;
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                ClassLoader classLoader = loader;
                stream = classLoader != null ? classLoader.getResourceAsStream(resourceName) : null;
            }
            InputStream inputStream = stream;
            if (inputStream != null) {
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    InputStream inputStream2 = it;
                    Charset charset = Charsets.UTF_8;
                    ResourceBundle resourceBundle = new PropertyResourceBundle(new InputStreamReader(inputStream2, charset));
                    return resourceBundle;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            return null;
        }

        @NotNull
        public String toString() {
            return "UTF8PropertiesControl";
        }
    }
}

