/*
 * Decompiled with CFR 0.152.
 */
package com.r4g3baby.simplescore.core.scoreboard.effect;

import com.r4g3baby.simplescore.api.scoreboard.effect.TextEffect;
import com.r4g3baby.simplescore.core.util.ColorsKt;
import com.r4g3baby.simplescore.lib.jetbrains.annotations.NotNull;
import com.r4g3baby.simplescore.lib.kotlin.Metadata;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/r4g3baby/simplescore/core/scoreboard/effect/FillEffect;", "Lcom/r4g3baby/simplescore/api/scoreboard/effect/TextEffect;", "length", "", "<init>", "(I)V", "apply", "", "text", "core"})
public final class FillEffect
implements TextEffect {
    private final int length;

    public FillEffect(int length) {
        this.length = length;
    }

    @Override
    @NotNull
    public String apply(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        int padding = this.length - ColorsKt.stripColorCodes(text).length();
        if (padding <= 0) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text.length() + padding);
        int i = 1;
        int n = padding / 2;
        if (i <= n) {
            while (true) {
                sb.append(" ");
                if (i == n) break;
                ++i;
            }
        }
        sb.append(text);
        i = 1;
        n = padding / 2;
        if (i <= n) {
            while (true) {
                sb.append(" ");
                if (i == n) break;
                ++i;
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }
}

