/*
 * Decompiled with CFR 0.152.
 */
package com.r4g3baby.simplescore.core.util;

import com.r4g3baby.simplescore.lib.jetbrains.annotations.NotNull;
import com.r4g3baby.simplescore.lib.kotlin.Metadata;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.Intrinsics;
import com.r4g3baby.simplescore.lib.kotlin.text.Regex;
import com.r4g3baby.simplescore.lib.kotlin.text.StringsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004\u001a\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"COLOR_CHAR", "", "ALT_COLOR_CHAR", "HEX_CHARS", "", "COLOR_CHARS", "translateColorCodes", "text", "colorRegex", "Lcom/r4g3baby/simplescore/lib/kotlin/text/Regex;", "stripColorCodes", "core"})
public final class ColorsKt {
    private static final char COLOR_CHAR = '\u00a7';
    private static final char ALT_COLOR_CHAR = '&';
    @NotNull
    private static final String HEX_CHARS = "0123456789AaBbCcDdEeFf";
    @NotNull
    private static final String COLOR_CHARS = "0123456789abcdefklmnor";
    @NotNull
    private static final Regex colorRegex = new Regex("[\u00a7&]x(?:[\u00a7&][a-fA-F0-9]){6}|[\u00a7&][0-9a-fk-orA-FK-OR]");

    @NotNull
    public static final String translateColorCodes(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        if (text.length() <= 1) {
            return text;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '&' && i + 1 < text.length()) {
                char nextChar = text.charAt(i + 1);
                if (nextChar == '#' && i + 7 < text.length()) {
                    StringBuilder hexCode = new StringBuilder("\u00a7x");
                    boolean validHex = true;
                    for (int j = 2; j < 8; ++j) {
                        char hexChar = text.charAt(i + j);
                        if (!StringsKt.contains$default((CharSequence)HEX_CHARS, hexChar, false, 2, null)) {
                            validHex = false;
                            break;
                        }
                        hexCode.append('\u00a7').append(hexChar);
                    }
                    if (validHex) {
                        result.append((CharSequence)hexCode);
                        i += 8;
                        continue;
                    }
                }
                if (StringsKt.contains$default((CharSequence)COLOR_CHARS, nextChar, false, 2, null)) {
                    result.append('\u00a7').append(nextChar);
                    i += 2;
                    continue;
                }
            }
            result.append(c);
            ++i;
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public static final String stripColorCodes(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        return colorRegex.replace((CharSequence)text, "");
    }
}

