/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.endlessids.asm;

import com.falsepattern.endlessids.asm.EndlessIDsTransformer;
import com.falsepattern.endlessids.asm.FCCompat;
import com.falsepattern.endlessids.config.GeneralConfig;
import com.falsepattern.endlessids.mixin.plugin.Mixin;
import com.gtnewhorizon.gtnhmixins.IEarlyMixinLoader;
import com.gtnewhorizon.gtnhmixins.builders.IMixins;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;

@IFMLLoadingPlugin.MCVersion(value="1.7.10")
@IFMLLoadingPlugin.Name(value="endlessids_core")
@IFMLLoadingPlugin.TransformerExclusions(value={"com.falsepattern.endlessids.asm", "com.falsepattern.endlessids.config.GeneralConfig"})
@IFMLLoadingPlugin.DependsOn(value={"falsepatternlib"})
public class EndlessIDsCore
implements IFMLLoadingPlugin,
IEarlyMixinLoader {
    public static boolean deobfuscated;

    public EndlessIDsCore() {
        try {
            if (Launch.classLoader.getClassBytes("ru.fewizz.neid.asm.Plugin") != null || Launch.classLoader.getClassBytes("com.gtnewhorizons.neid.asm.NEIDTransformer") != null) {
                EndlessIDsCore.loudCrash("EndlessIDs replaces NotEnoughIDs! Please uninstall NotEnoughIDs!");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] getASMTransformerClass() {
        deobfuscated = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        LaunchClassLoader cl = Launch.classLoader;
        Field field = LaunchClassLoader.class.getDeclaredField("transformerExceptions");
        field.setAccessible(true);
        Set exceptions = (Set)field.get(cl);
        if (exceptions.contains("code.elix_x.coremods")) {
            EndlessIDsTransformer.logger.info("AntiIDConflict detected!");
            EndlessIDsTransformer.logger.info("Removing ASM protections so that we can fix its code.");
            exceptions.remove("code.elix_x.coremods");
            exceptions.add("code.elix_x.coremods.antiidconflict.core");
            exceptions.add("code.elix_x.coremods.antiidconflict.ByteCodeTester");
        }
        return new String[]{EndlessIDsTransformer.class.getName()};
    }

    private static void loudCrash(String message) {
        for (int i = 0; i < 100; ++i) {
            EndlessIDsTransformer.logger.fatal(message);
        }
        Error err = new Error(message);
        err.setStackTrace(new StackTraceElement[0]);
        throw err;
    }

    public String getModContainerClass() {
        if (GeneralConfig.extendBiome) {
            FMLInjectionData.containers.add("com.falsepattern.endlessids.containers.BiomeContainer");
        }
        if (GeneralConfig.extendBlockItem) {
            FMLInjectionData.containers.add("com.falsepattern.endlessids.containers.BlockItemContainer");
        }
        if (GeneralConfig.extendDataWatcher) {
            FMLInjectionData.containers.add("com.falsepattern.endlessids.containers.DataWatcherContainer");
        }
        if (GeneralConfig.extendEnchantment) {
            FMLInjectionData.containers.add("com.falsepattern.endlessids.containers.EnchantmentContainer");
        }
        if (GeneralConfig.extendPotion) {
            FMLInjectionData.containers.add("com.falsepattern.endlessids.containers.PotionContainer");
        }
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public String getMixinConfig() {
        return "mixins.endlessids.early.json";
    }

    public List<String> getMixins(Set<String> loadedCoreMods) {
        return IMixins.getEarlyMixins(Mixin.class, loadedCoreMods);
    }

    static {
        if (GeneralConfig.extendBlockItem) {
            try {
                if (Launch.classLoader.getClassBytes("fastcraft.Tweaker") != null) {
                    FCCompat.patchConfig();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

