/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.endlessids.asm.transformer.chunk;

import com.falsepattern.endlessids.asm.EndlessIDsCore;
import com.falsepattern.endlessids.asm.EndlessIDsTransformer;
import com.falsepattern.lib.turboasm.ClassNodeHandle;
import com.falsepattern.lib.turboasm.TurboClassTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ChunkProviderSuperPatcher
implements TurboClassTransformer {
    public static final String[] CLASS_BiomeGenBase;
    public static final String[] CLASS_IChunkProvider;
    public static final String[] CLASS_ChunkProviderGenerate;
    public static final String[] CLASS_Chunk;
    public static final String[] FIELD_biomeID;
    public static final String[] METHOD_getBiomeArray;
    private static State<AbstractInsnNode> STATE0;
    private static State<AbstractInsnNode> STATE1;
    private static State<AbstractInsnNode> STATE2;
    private static State<AbstractInsnNode> STATE3;
    private static State<AbstractInsnNode> STATE4;
    private static State<AbstractInsnNode> STATE5;
    private static State<AbstractInsnNode> STATE6;
    private static State<AbstractInsnNode> STATE7;
    private static State<AbstractInsnNode> STATE8;
    private static State<AbstractInsnNode> STATE9;
    private static State<AbstractInsnNode> STATE9_Y;
    private static State<AbstractInsnNode> STATE10;
    private static State<AbstractInsnNode> STATE11;
    private static State<AbstractInsnNode> STATE12;
    private static State<AbstractInsnNode> STATE13;
    private static State<AbstractInsnNode> STATE14;
    private static State<AbstractInsnNode> STATE14_ABD1;
    private static State<AbstractInsnNode> STATE14_ABD1_BD1;
    private static State<AbstractInsnNode> STATE14_ABD1_BA2;
    private static State<AbstractInsnNode> STATE14_ABD1_BA3;
    private static State<AbstractInsnNode> STATE14_C1;
    private static State<AbstractInsnNode> STATE15;
    private static State<AbstractInsnNode> STATE16;
    private static State<AbstractInsnNode> STATE17;
    private static State<AbstractInsnNode> STATE_FINAL;

    private static boolean scanForBrokenCall(MethodNode method) {
        InsnList instructions = method.instructions;
        int insnCount = instructions.size();
        for (int i = 0; i < insnCount; ++i) {
            AbstractInsnNode insn = instructions.get(i);
            if (insn.getOpcode() != 182) continue;
            MethodInsnNode invoke = (MethodInsnNode)insn;
            if (!ChunkProviderSuperPatcher.anyMatch(invoke.owner, CLASS_Chunk) || !ChunkProviderSuperPatcher.anyMatch(invoke.name, METHOD_getBiomeArray) || !invoke.desc.equals("()[B")) continue;
            return true;
        }
        return false;
    }

    private static boolean anyMatch(List<String> str, String[] candidates) {
        for (String s : str) {
            for (String candidate : candidates) {
                if (!s.equals(candidate)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean anyMatch(String str, String[] candidates) {
        for (String candidate : candidates) {
            if (!str.equals(candidate)) continue;
            return true;
        }
        return false;
    }

    private static boolean anyMatch(String str, String[] candidates, String prefix, String suffix) {
        for (String candidate : candidates) {
            if (!str.equals(prefix + candidate + suffix)) continue;
            return true;
        }
        return false;
    }

    private static <T extends AbstractInsnNode> State<AbstractInsnNode> typeCheck(Class<T> clazz, Supplier<State<AbstractInsnNode>> okState) {
        return ChunkProviderSuperPatcher.casting(clazz, (insn, memory) -> (State)okState.get());
    }

    private static <T extends AbstractInsnNode> State<AbstractInsnNode> casting(Class<T> clazz, Function<T, State<AbstractInsnNode>> okState) {
        return ChunkProviderSuperPatcher.casting(clazz, (insn, memory) -> (State)okState.apply(insn));
    }

    private static <T extends AbstractInsnNode> State<AbstractInsnNode> casting(Class<T> clazz, State<T> okState) {
        return (insn, memory) -> {
            if (insn instanceof LineNumberNode) {
                return null;
            }
            if (clazz.isInstance(insn)) {
                return (State)okState.apply(clazz.cast(insn), memory);
            }
            return STATE0;
        };
    }

    private static Memory findTheTarget(MethodNode method, ClassNode cn) {
        InsnList insnList = method.instructions;
        State currentState = STATE0;
        Memory memory = new Memory();
        memory.initLocals(method, cn);
        ListIterator iter = insnList.iterator();
        while (iter.hasNext()) {
            State newState;
            AbstractInsnNode insn = (AbstractInsnNode)iter.next();
            if (insn instanceof FrameNode) {
                FrameNode frame = (FrameNode)insn;
                memory.recordFrame(frame);
                memory.updateLocalsState(frame);
            }
            if ((newState = (State)currentState.apply(insn, memory)) == null) continue;
            if (newState == STATE_FINAL) {
                while (iter.hasNext()) {
                    AbstractInsnNode insn2 = (AbstractInsnNode)iter.next();
                    if (!(insn2 instanceof FrameNode)) continue;
                    memory.recordFrame((FrameNode)insn2);
                }
                return memory;
            }
            currentState = newState;
        }
        return null;
    }

    public String owner() {
        return "EndlessIDs";
    }

    public String name() {
        return "ChunkProviderSuperPatcher";
    }

    public boolean shouldTransformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        if ("net.minecraft.world.chunk.storage.AnvilChunkLoader".equals(className)) {
            return false;
        }
        ClassNode cn = classNode.getNode();
        if (cn == null) {
            return false;
        }
        for (MethodNode method : cn.methods) {
            if (!ChunkProviderSuperPatcher.scanForBrokenCall(method)) continue;
            return true;
        }
        return false;
    }

    public boolean transformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode cn = classNode.getNode();
        if (cn == null) {
            return false;
        }
        boolean patched = false;
        for (MethodNode method : cn.methods) {
            Memory memory = ChunkProviderSuperPatcher.findTheTarget(method, cn);
            if (memory == null) continue;
            patched = true;
            EndlessIDsTransformer.logger.debug("[ChunkProvider patcher]: Match found in method " + method.name);
            InsnList insnList = method.instructions;
            for (LocalVariableNode node : method.localVariables) {
                if (!node.desc.equals("[B") || node.index != memory.biomeArrayIndex) continue;
                node.desc = "[S";
            }
            MethodInsnNode getBiomeArray = memory.getBiomeArrayInsn;
            insnList.set((AbstractInsnNode)getBiomeArray, (AbstractInsnNode)new MethodInsnNode(182, getBiomeArray.owner, "getBiomeShortArray", "()[S", false));
            insnList.set((AbstractInsnNode)memory.castInsn, (AbstractInsnNode)new InsnNode(147));
            insnList.set((AbstractInsnNode)memory.arrayStoreInsn, (AbstractInsnNode)new InsnNode(86));
            ChunkProviderSuperPatcher.patchStackFrames(memory, method, cn);
        }
        if (!patched) {
            EndlessIDsTransformer.logger.debug("[ChunkProvider patcher]: No matches found in class! This is not explicitly an error, because the patch might be applied by a mixin instead!");
        }
        return patched;
    }

    private static void patchStackFrames(Memory memory, MethodNode method, ClassNode owner) {
        memory.locals.clear();
        memory.initLocals(method, owner);
        for (FrameNode frame : memory.framesLeaveUnpatched) {
            memory.updateLocalsState(frame);
        }
        int localToPatch = memory.biomeArrayIndex;
        for (FrameNode frame : memory.framesToPatch) {
            int currentLocalIndex = memory.locals.size() - 1;
            if (frame.local != null) {
                switch (frame.type) {
                    case -1: 
                    case 0: {
                        if (frame.local.size() <= localToPatch || !"[B".equals(frame.local.get(localToPatch))) break;
                        frame.local.set(localToPatch, "[S");
                        break;
                    }
                    case 1: {
                        int indexInFrame;
                        if (currentLocalIndex >= localToPatch || currentLocalIndex + frame.local.size() < localToPatch || !"[B".equals(frame.local.get(indexInFrame = localToPatch - currentLocalIndex - 1))) break;
                        frame.local.set(indexInFrame, "[S");
                    }
                }
            }
            memory.updateLocalsState(frame);
        }
    }

    static {
        STATE0 = null;
        STATE1 = null;
        STATE2 = null;
        STATE3 = null;
        STATE4 = null;
        STATE5 = null;
        STATE6 = null;
        STATE7 = null;
        STATE8 = null;
        STATE9 = null;
        STATE9_Y = null;
        STATE10 = null;
        STATE11 = null;
        STATE12 = null;
        STATE13 = null;
        STATE14 = null;
        STATE14_ABD1 = null;
        STATE14_ABD1_BD1 = null;
        STATE14_ABD1_BA2 = null;
        STATE14_ABD1_BA3 = null;
        STATE14_C1 = null;
        STATE15 = null;
        STATE16 = null;
        STATE17 = null;
        STATE_FINAL = null;
        if (EndlessIDsCore.deobfuscated) {
            CLASS_BiomeGenBase = new String[]{"net/minecraft/world/biome/BiomeGenBase"};
            CLASS_IChunkProvider = new String[]{"net/minecraft/world/chunk/IChunkProvider"};
            CLASS_ChunkProviderGenerate = new String[]{"net/minecraft/world/gen/ChunkProviderGenerate"};
            CLASS_Chunk = new String[]{"net/minecraft/world/chunk/Chunk"};
            FIELD_biomeID = new String[]{"biomeID"};
            METHOD_getBiomeArray = new String[]{"getBiomeArray"};
        } else {
            CLASS_BiomeGenBase = new String[]{"ahu", "net/minecraft/world/biome/BiomeGenBase"};
            CLASS_IChunkProvider = new String[]{"apu", "net/minecraft/world/chunk/IChunkProvider"};
            CLASS_ChunkProviderGenerate = new String[]{"aqz", "net/minecraft/world/gen/ChunkProviderGenerate"};
            CLASS_Chunk = new String[]{"apx", "net/minecraft/world/chunk/Chunk"};
            FIELD_biomeID = new String[]{"ay", "field_76756_M"};
            METHOD_getBiomeArray = new String[]{"m", "func_76605_m"};
        }
        STATE_FINAL = (insn, memory) -> STATE_FINAL;
        STATE0 = ChunkProviderSuperPatcher.casting(VarInsnNode.class, (insn, memory) -> {
            memory.reset();
            if (insn.getOpcode() == 25) {
                memory.chunkIndex = insn.var;
                memory.startingInsn = insn;
                return STATE1;
            }
            return STATE0;
        });
        STATE1 = ChunkProviderSuperPatcher.casting(MethodInsnNode.class, (insn, memory) -> {
            if (insn.getOpcode() == 182 && ChunkProviderSuperPatcher.anyMatch(insn.owner, CLASS_Chunk) && ChunkProviderSuperPatcher.anyMatch(insn.name, METHOD_getBiomeArray) && insn.desc.equals("()[B")) {
                memory.getBiomeArrayInsn = insn;
                return STATE2;
            }
            return STATE0;
        });
        STATE2 = ChunkProviderSuperPatcher.casting(VarInsnNode.class, (insn, memory) -> {
            if (insn.getOpcode() == 58) {
                memory.biomeArrayIndex = insn.var;
                memory.startPatchingFrames();
                return STATE3;
            }
            return STATE0;
        });
        STATE3 = ChunkProviderSuperPatcher.typeCheck(LabelNode.class, () -> STATE4);
        STATE4 = ChunkProviderSuperPatcher.casting(InsnNode.class, (T insn) -> insn.getOpcode() == 3 ? STATE5 : STATE0);
        STATE5 = ChunkProviderSuperPatcher.casting(VarInsnNode.class, (insn, memory) -> {
            if (insn.getOpcode() == 54) {
                memory.iteratorIndex = insn.var;
                return STATE6;
            }
            return STATE0;
        });
        STATE6 = ChunkProviderSuperPatcher.typeCheck(LabelNode.class, () -> STATE7);
        STATE7 = ChunkProviderSuperPatcher.casting(FrameNode.class, (insn, memory) -> ChunkProviderSuperPatcher.anyMatch((String)memory.locals.get(memory.chunkIndex), CLASS_Chunk) && memory.locals.get(memory.biomeArrayIndex).equals("[B") && memory.locals.get(memory.iteratorIndex).equals(1) ? STATE8 : STATE0);
        STATE8 = ChunkProviderSuperPatcher.casting(VarInsnNode.class, (insn, memory) -> insn.getOpcode() == 21 && insn.var == memory.iteratorIndex ? STATE9 : STATE0);
        STATE9 = ChunkProviderSuperPatcher.casting(VarInsnNode.class, (insn, memory) -> insn.getOpcode() == 25 && insn.var == memory.biomeArrayIndex ? STATE10 : STATE9_Y);
        STATE9_Y = ChunkProviderSuperPatcher.casting(FieldInsnNode.class, (T insn) -> insn.getOpcode() == 180 && ChunkProviderSuperPatcher.anyMatch(insn.desc, CLASS_BiomeGenBase, "[L", ";") ? STATE10 : STATE0);
        STATE10 = ChunkProviderSuperPatcher.casting(InsnNode.class, (T insn) -> insn.getOpcode() == 190 ? STATE11 : STATE0);
        STATE11 = ChunkProviderSuperPatcher.casting(JumpInsnNode.class, (T insn) -> insn.getOpcode() == 162 ? STATE12 : STATE0);
        STATE12 = ChunkProviderSuperPatcher.typeCheck(LabelNode.class, () -> STATE13);
        STATE13 = ChunkProviderSuperPatcher.casting(VarInsnNode.class, (insn, memory) -> insn.getOpcode() == 25 && insn.var == memory.biomeArrayIndex ? STATE14 : STATE0);
        STATE14 = ChunkProviderSuperPatcher.casting(VarInsnNode.class, (insn, memory) -> {
            if (insn.getOpcode() == 21 && insn.var == memory.iteratorIndex) {
                if (insn.getNext() instanceof FieldInsnNode) {
                    return STATE14_C1;
                }
                return STATE14_ABD1;
            }
            return STATE0;
        });
        STATE14_ABD1 = ChunkProviderSuperPatcher.casting(VarInsnNode.class, (insn, memory) -> {
            if (insn.getOpcode() == 25) {
                if (ChunkProviderSuperPatcher.anyMatch((String)memory.locals.get(insn.var), CLASS_BiomeGenBase, "[L", ";")) {
                    return STATE14_ABD1_BA2;
                }
                return STATE14_ABD1_BD1;
            }
            return STATE0;
        });
        STATE14_ABD1_BD1 = ChunkProviderSuperPatcher.casting(FieldInsnNode.class, (insn, memory) -> {
            if (insn.getOpcode() == 180) {
                if (ChunkProviderSuperPatcher.anyMatch(insn.desc, CLASS_BiomeGenBase, "[L", ";")) {
                    return STATE14_ABD1_BA2;
                }
                if (ChunkProviderSuperPatcher.anyMatch(insn.desc, CLASS_BiomeGenBase, "L", ";")) {
                    return STATE15;
                }
            }
            return STATE0;
        });
        STATE14_ABD1_BA2 = ChunkProviderSuperPatcher.casting(VarInsnNode.class, (insn, memory) -> insn.getOpcode() == 21 && insn.var == memory.iteratorIndex ? STATE14_ABD1_BA3 : STATE0);
        STATE14_ABD1_BA3 = ChunkProviderSuperPatcher.casting(InsnNode.class, (T insn) -> insn.getOpcode() == 50 ? STATE15 : STATE0);
        STATE14_C1 = ChunkProviderSuperPatcher.casting(FieldInsnNode.class, (insn, memory) -> {
            if (insn.getOpcode() == 178 && ChunkProviderSuperPatcher.anyMatch(insn.desc, CLASS_BiomeGenBase, "L", ";")) {
                return STATE15;
            }
            return STATE0;
        });
        STATE15 = ChunkProviderSuperPatcher.casting(FieldInsnNode.class, (T insn) -> insn.getOpcode() == 180 && ChunkProviderSuperPatcher.anyMatch(insn.owner, CLASS_BiomeGenBase) && ChunkProviderSuperPatcher.anyMatch(insn.name, FIELD_biomeID) & insn.desc.equals("I") ? STATE16 : STATE0);
        STATE16 = ChunkProviderSuperPatcher.casting(InsnNode.class, (insn, memory) -> {
            if (insn.getOpcode() == 145) {
                memory.castInsn = insn;
                return STATE17;
            }
            return STATE0;
        });
        STATE17 = ChunkProviderSuperPatcher.casting(InsnNode.class, (insn, memory) -> {
            if (insn.getOpcode() == 84) {
                memory.arrayStoreInsn = insn;
                return STATE_FINAL;
            }
            return STATE0;
        });
    }

    private static class Memory {
        final List<Object> locals = new ArrayList<Object>();
        List<Object> localsAtPatchStart;
        List<FrameNode> framesLeaveUnpatched = new ArrayList<FrameNode>();
        List<FrameNode> framesToPatch = new ArrayList<FrameNode>();
        boolean patchingFrames;
        VarInsnNode startingInsn;
        MethodInsnNode getBiomeArrayInsn;
        InsnNode castInsn;
        InsnNode arrayStoreInsn;
        int chunkIndex;
        int biomeArrayIndex;
        int iteratorIndex;

        public void startPatchingFrames() {
            this.localsAtPatchStart = new ArrayList<Object>(this.locals);
            this.patchingFrames = true;
        }

        public void recordFrame(FrameNode frame) {
            if (this.patchingFrames) {
                this.framesToPatch.add(frame);
            } else {
                this.framesLeaveUnpatched.add(frame);
            }
        }

        public void reset() {
            this.localsAtPatchStart = null;
            this.framesLeaveUnpatched.addAll(this.framesToPatch);
            this.framesToPatch.clear();
            this.patchingFrames = false;
            this.startingInsn = null;
            this.getBiomeArrayInsn = null;
            this.castInsn = null;
            this.arrayStoreInsn = null;
            this.chunkIndex = 0;
            this.biomeArrayIndex = 0;
            this.iteratorIndex = 0;
        }

        private static int getDescriptorNameEnd(String desc, int index) {
            char c = desc.charAt(index);
            switch (c) {
                case '[': {
                    return Memory.getDescriptorNameEnd(desc, index + 1);
                }
                case 'L': {
                    while (desc.charAt(++index) != ';') {
                    }
                    break;
                }
            }
            return index + 1;
        }

        private static List<Object> parseDesc(String desc) {
            ArrayList<Object> result = new ArrayList<Object>();
            desc = desc.substring(1, desc.indexOf(41));
            for (int i = 0; i < desc.length(); ++i) {
                String name;
                int end = Memory.getDescriptorNameEnd(desc, i);
                switch (name = desc.substring(i, end)) {
                    case "I": 
                    case "S": 
                    case "B": 
                    case "Z": {
                        result.add(Opcodes.INTEGER);
                        break;
                    }
                    case "F": {
                        result.add(Opcodes.FLOAT);
                        break;
                    }
                    case "D": {
                        result.add(Opcodes.DOUBLE);
                        result.add(Opcodes.DOUBLE);
                        break;
                    }
                    case "J": {
                        result.add(Opcodes.LONG);
                        result.add(Opcodes.LONG);
                        break;
                    }
                    default: {
                        result.add(name);
                    }
                }
                i = end - 1;
            }
            return result;
        }

        public void initLocals(MethodNode method, ClassNode owner) {
            this.locals.clear();
            if ((method.access & 8) == 0) {
                this.locals.add("L" + owner.name + ";");
            }
            this.locals.addAll(Memory.parseDesc(method.desc));
        }

        public void updateLocalsState(FrameNode frame) {
            switch (frame.type) {
                case -1: 
                case 0: {
                    this.locals.clear();
                }
                case 1: {
                    if (frame.local == null) break;
                    for (Object local : frame.local) {
                        if (Objects.equals(local, Opcodes.DOUBLE) || Objects.equals(local, Opcodes.LONG)) {
                            this.locals.add(local);
                        }
                        this.locals.add(local);
                    }
                    break;
                }
                case 2: {
                    int removeCount = frame.local.size();
                    for (int i = removeCount - 1; i >= 0 && !this.locals.isEmpty(); --i) {
                        Object removed = this.locals.remove(this.locals.size() - 1);
                        if (!Objects.equals(removed, Opcodes.DOUBLE) && !Objects.equals(removed, Opcodes.LONG)) continue;
                        this.locals.remove(this.locals.size() - 1);
                    }
                    break;
                }
            }
        }

        @Generated
        public Memory() {
        }

        @Generated
        public List<Object> getLocals() {
            return this.locals;
        }

        @Generated
        public List<Object> getLocalsAtPatchStart() {
            return this.localsAtPatchStart;
        }

        @Generated
        public List<FrameNode> getFramesLeaveUnpatched() {
            return this.framesLeaveUnpatched;
        }

        @Generated
        public List<FrameNode> getFramesToPatch() {
            return this.framesToPatch;
        }

        @Generated
        public boolean isPatchingFrames() {
            return this.patchingFrames;
        }

        @Generated
        public VarInsnNode getStartingInsn() {
            return this.startingInsn;
        }

        @Generated
        public MethodInsnNode getGetBiomeArrayInsn() {
            return this.getBiomeArrayInsn;
        }

        @Generated
        public InsnNode getCastInsn() {
            return this.castInsn;
        }

        @Generated
        public InsnNode getArrayStoreInsn() {
            return this.arrayStoreInsn;
        }

        @Generated
        public int getChunkIndex() {
            return this.chunkIndex;
        }

        @Generated
        public int getBiomeArrayIndex() {
            return this.biomeArrayIndex;
        }

        @Generated
        public int getIteratorIndex() {
            return this.iteratorIndex;
        }

        @Generated
        public void setLocalsAtPatchStart(List<Object> localsAtPatchStart) {
            this.localsAtPatchStart = localsAtPatchStart;
        }

        @Generated
        public void setFramesLeaveUnpatched(List<FrameNode> framesLeaveUnpatched) {
            this.framesLeaveUnpatched = framesLeaveUnpatched;
        }

        @Generated
        public void setFramesToPatch(List<FrameNode> framesToPatch) {
            this.framesToPatch = framesToPatch;
        }

        @Generated
        public void setPatchingFrames(boolean patchingFrames) {
            this.patchingFrames = patchingFrames;
        }

        @Generated
        public void setStartingInsn(VarInsnNode startingInsn) {
            this.startingInsn = startingInsn;
        }

        @Generated
        public void setGetBiomeArrayInsn(MethodInsnNode getBiomeArrayInsn) {
            this.getBiomeArrayInsn = getBiomeArrayInsn;
        }

        @Generated
        public void setCastInsn(InsnNode castInsn) {
            this.castInsn = castInsn;
        }

        @Generated
        public void setArrayStoreInsn(InsnNode arrayStoreInsn) {
            this.arrayStoreInsn = arrayStoreInsn;
        }

        @Generated
        public void setChunkIndex(int chunkIndex) {
            this.chunkIndex = chunkIndex;
        }

        @Generated
        public void setBiomeArrayIndex(int biomeArrayIndex) {
            this.biomeArrayIndex = biomeArrayIndex;
        }

        @Generated
        public void setIteratorIndex(int iteratorIndex) {
            this.iteratorIndex = iteratorIndex;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Memory)) {
                return false;
            }
            Memory other = (Memory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isPatchingFrames() != other.isPatchingFrames()) {
                return false;
            }
            if (this.getChunkIndex() != other.getChunkIndex()) {
                return false;
            }
            if (this.getBiomeArrayIndex() != other.getBiomeArrayIndex()) {
                return false;
            }
            if (this.getIteratorIndex() != other.getIteratorIndex()) {
                return false;
            }
            List<Object> this$locals = this.getLocals();
            List<Object> other$locals = other.getLocals();
            if (this$locals == null ? other$locals != null : !((Object)this$locals).equals(other$locals)) {
                return false;
            }
            List<Object> this$localsAtPatchStart = this.getLocalsAtPatchStart();
            List<Object> other$localsAtPatchStart = other.getLocalsAtPatchStart();
            if (this$localsAtPatchStart == null ? other$localsAtPatchStart != null : !((Object)this$localsAtPatchStart).equals(other$localsAtPatchStart)) {
                return false;
            }
            List<FrameNode> this$framesLeaveUnpatched = this.getFramesLeaveUnpatched();
            List<FrameNode> other$framesLeaveUnpatched = other.getFramesLeaveUnpatched();
            if (this$framesLeaveUnpatched == null ? other$framesLeaveUnpatched != null : !((Object)this$framesLeaveUnpatched).equals(other$framesLeaveUnpatched)) {
                return false;
            }
            List<FrameNode> this$framesToPatch = this.getFramesToPatch();
            List<FrameNode> other$framesToPatch = other.getFramesToPatch();
            if (this$framesToPatch == null ? other$framesToPatch != null : !((Object)this$framesToPatch).equals(other$framesToPatch)) {
                return false;
            }
            VarInsnNode this$startingInsn = this.getStartingInsn();
            VarInsnNode other$startingInsn = other.getStartingInsn();
            if (this$startingInsn == null ? other$startingInsn != null : !this$startingInsn.equals(other$startingInsn)) {
                return false;
            }
            MethodInsnNode this$getBiomeArrayInsn = this.getGetBiomeArrayInsn();
            MethodInsnNode other$getBiomeArrayInsn = other.getGetBiomeArrayInsn();
            if (this$getBiomeArrayInsn == null ? other$getBiomeArrayInsn != null : !this$getBiomeArrayInsn.equals(other$getBiomeArrayInsn)) {
                return false;
            }
            InsnNode this$castInsn = this.getCastInsn();
            InsnNode other$castInsn = other.getCastInsn();
            if (this$castInsn == null ? other$castInsn != null : !this$castInsn.equals(other$castInsn)) {
                return false;
            }
            InsnNode this$arrayStoreInsn = this.getArrayStoreInsn();
            InsnNode other$arrayStoreInsn = other.getArrayStoreInsn();
            return !(this$arrayStoreInsn == null ? other$arrayStoreInsn != null : !this$arrayStoreInsn.equals(other$arrayStoreInsn));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Memory;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPatchingFrames() ? 79 : 97);
            result = result * 59 + this.getChunkIndex();
            result = result * 59 + this.getBiomeArrayIndex();
            result = result * 59 + this.getIteratorIndex();
            List<Object> $locals = this.getLocals();
            result = result * 59 + ($locals == null ? 43 : ((Object)$locals).hashCode());
            List<Object> $localsAtPatchStart = this.getLocalsAtPatchStart();
            result = result * 59 + ($localsAtPatchStart == null ? 43 : ((Object)$localsAtPatchStart).hashCode());
            List<FrameNode> $framesLeaveUnpatched = this.getFramesLeaveUnpatched();
            result = result * 59 + ($framesLeaveUnpatched == null ? 43 : ((Object)$framesLeaveUnpatched).hashCode());
            List<FrameNode> $framesToPatch = this.getFramesToPatch();
            result = result * 59 + ($framesToPatch == null ? 43 : ((Object)$framesToPatch).hashCode());
            VarInsnNode $startingInsn = this.getStartingInsn();
            result = result * 59 + ($startingInsn == null ? 43 : $startingInsn.hashCode());
            MethodInsnNode $getBiomeArrayInsn = this.getGetBiomeArrayInsn();
            result = result * 59 + ($getBiomeArrayInsn == null ? 43 : $getBiomeArrayInsn.hashCode());
            InsnNode $castInsn = this.getCastInsn();
            result = result * 59 + ($castInsn == null ? 43 : $castInsn.hashCode());
            InsnNode $arrayStoreInsn = this.getArrayStoreInsn();
            result = result * 59 + ($arrayStoreInsn == null ? 43 : $arrayStoreInsn.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ChunkProviderSuperPatcher.Memory(locals=" + this.getLocals() + ", localsAtPatchStart=" + this.getLocalsAtPatchStart() + ", framesLeaveUnpatched=" + this.getFramesLeaveUnpatched() + ", framesToPatch=" + this.getFramesToPatch() + ", patchingFrames=" + this.isPatchingFrames() + ", startingInsn=" + this.getStartingInsn() + ", getBiomeArrayInsn=" + this.getGetBiomeArrayInsn() + ", castInsn=" + this.getCastInsn() + ", arrayStoreInsn=" + this.getArrayStoreInsn() + ", chunkIndex=" + this.getChunkIndex() + ", biomeArrayIndex=" + this.getBiomeArrayIndex() + ", iteratorIndex=" + this.getIteratorIndex() + ")";
        }
    }

    public static interface State<T extends AbstractInsnNode>
    extends BiFunction<T, Memory, State<AbstractInsnNode>> {
    }
}

