/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.endlessids.managers;

import com.falsepattern.chunk.api.ArrayUtil;
import com.falsepattern.chunk.api.DataManager;
import com.falsepattern.endlessids.Hooks;
import com.falsepattern.endlessids.mixin.helpers.ChunkBiomeHook;
import java.nio.ByteBuffer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.chunk.Chunk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BiomeManager
implements DataManager.PacketDataManager,
DataManager.ChunkDataManager {
    public String domain() {
        return "endlessids";
    }

    public String id() {
        return "biome";
    }

    public int maxPacketSize() {
        return 512;
    }

    public void writeToBuffer(Chunk chunk, int subChunkMask, boolean forceUpdate, ByteBuffer data) {
        data.asShortBuffer().put(((ChunkBiomeHook)chunk).getBiomeShortArray());
        data.position(data.position() + this.maxPacketSize());
    }

    public void readFromBuffer(Chunk chunk, int subChunkMask, boolean forceUpdate, ByteBuffer buffer) {
        short[] arr = ((ChunkBiomeHook)chunk).getBiomeShortArray();
        if (arr == null) {
            arr = new short[256];
            ((ChunkBiomeHook)chunk).setBiomeShortArray(arr);
        }
        buffer.asShortBuffer().get(arr);
        buffer.position(buffer.position() + this.maxPacketSize());
    }

    public boolean chunkPrivilegedAccess() {
        return true;
    }

    public void writeChunkToNBT(Chunk chunk, NBTTagCompound nbt) {
        byte[] arr = Hooks.shortToByteArray(((ChunkBiomeHook)chunk).getBiomeShortArray());
        nbt.func_74773_a("Biomes16v2", arr);
    }

    public void readChunkFromNBT(Chunk chunk, NBTTagCompound nbt) {
        short[] data = ((ChunkBiomeHook)chunk).getBiomeShortArray();
        if (data == null) {
            data = new short[256];
            ((ChunkBiomeHook)chunk).setBiomeShortArray(data);
        }
        if (nbt.func_150297_b("Biomes16v2", 7)) {
            Hooks.byteToShortArray(nbt.func_74770_j("Biomes16v2"), 0, data, 0, data.length * 2);
        } else if (nbt.func_150297_b("Biomes16", 7)) {
            Hooks.byteToShortArrayLegacy(nbt.func_74770_j("Biomes16"), data);
        } else if (nbt.func_150297_b("Biomes", 7)) {
            Hooks.scatter(nbt.func_74770_j("Biomes"), data);
        }
    }

    public void cloneChunk(Chunk fromVanilla, Chunk toVanilla) {
        ChunkBiomeHook from = (ChunkBiomeHook)fromVanilla;
        ChunkBiomeHook to = (ChunkBiomeHook)toVanilla;
        to.setBiomeShortArray(ArrayUtil.copyArray((short[])from.getBiomeShortArray(), (short[])to.getBiomeShortArray()));
    }

    @NotNull
    public String version() {
        return "endlessids";
    }

    @Nullable
    public String newInstallDescription() {
        return "EndlessIDs extended biome data. Vanilla biome data is limited to 256 biomes. This allows for 65536 biomes.";
    }

    @NotNull
    public String uninstallMessage() {
        return "EndlessIDs extended biome data has been uninstalled. Biomes are limited to 256,\nand any biomes with IDs above 255 in the save will be corrupted.";
    }

    @Nullable
    public String versionChangeMessage(String priorVersion) {
        return null;
    }
}

