/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.endlessids.managers;

import com.falsepattern.chunk.api.ArrayUtil;
import com.falsepattern.chunk.api.DataManager;
import com.falsepattern.endlessids.mixin.helpers.SubChunkBlockHook;
import com.falsepattern.endlessids.util.DataUtil;
import java.nio.ByteBuffer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockMetaManager
implements DataManager.PacketDataManager,
DataManager.SubChunkDataManager,
DataManager.BlockPacketDataManager {
    public String domain() {
        return "endlessids";
    }

    public String id() {
        return "metadata";
    }

    public int maxPacketSize() {
        return 131076;
    }

    public void writeToBuffer(Chunk chunk, int subChunkMask, boolean forceUpdate, ByteBuffer data) {
        ExtendedBlockStorage[] subChunkList = chunk.func_76587_i();
        int storageFlags = 0;
        int start = data.position() + 4;
        data.position(start);
        for (int i = 0; i < 16; ++i) {
            if ((subChunkMask & 1 << i) == 0 || subChunkList[i] == null) continue;
            SubChunkBlockHook subChunk = (SubChunkBlockHook)subChunkList[i];
            storageFlags |= subChunk.eid$getMetadataMask() << i * 2;
            NibbleArray m1Low = subChunk.eid$getM1Low();
            data.put(m1Low.field_76585_a);
            NibbleArray m1High = subChunk.eid$getM1High();
            if (m1High == null) continue;
            data.put(m1High.field_76585_a);
            byte[] m2 = subChunk.eid$getM2();
            if (m2 == null) continue;
            data.put(m2);
        }
        data.putInt(start - 4, storageFlags);
    }

    public void readFromBuffer(Chunk chunk, int subChunkMask, boolean forceUpdate, ByteBuffer buffer) {
        ExtendedBlockStorage[] subChunkList = chunk.func_76587_i();
        int storageFlags = buffer.getInt();
        for (int i = 0; i < 16; ++i) {
            if ((subChunkMask & 1 << i) == 0 || subChunkList[i] == null) continue;
            SubChunkBlockHook subChunk = (SubChunkBlockHook)subChunkList[i];
            int storageFlag = storageFlags >>> i * 2 & 3;
            NibbleArray m1Low = subChunk.eid$getM1Low();
            buffer.get(m1Low.field_76585_a);
            if (storageFlag == 1) {
                subChunk.eid$setM1High(null);
                subChunk.eid$setM2(null);
                continue;
            }
            NibbleArray m1High = subChunk.eid$getM1High();
            if (m1High == null) {
                m1High = subChunk.eid$createM1High();
            }
            buffer.get(m1High.field_76585_a);
            if (storageFlag == 2) {
                subChunk.eid$setM2(null);
                continue;
            }
            byte[] m2 = subChunk.eid$getM2();
            if (m2 == null) {
                m2 = subChunk.eid$createM2();
            }
            buffer.get(m2);
        }
    }

    public boolean subChunkPrivilegedAccess() {
        return true;
    }

    public void writeSubChunkToNBT(Chunk chunk, ExtendedBlockStorage subChunkVanilla, NBTTagCompound nbt) {
        SubChunkBlockHook subChunk = (SubChunkBlockHook)subChunkVanilla;
        NibbleArray m1Low = subChunk.eid$getM1Low();
        NibbleArray m1High = subChunk.eid$getM1High();
        byte[] m2 = subChunk.eid$getM2();
        nbt.func_74773_a("Data", m1Low.field_76585_a);
        if (m1High != null) {
            nbt.func_74773_a("Data1High", m1High.field_76585_a);
        }
        if (m2 != null) {
            nbt.func_74773_a("Data2", m2);
        }
    }

    private void readSubChunkFromNBTNotEnoughIDsDFU(SubChunkBlockHook subChunk, NBTTagCompound nbt) {
        byte[] data = nbt.func_74770_j("Data16");
        short[] dataShort = new short[data.length >>> 1];
        ByteBuffer.wrap(data).asShortBuffer().get(dataShort);
        byte[] m1Low = new byte[2048];
        byte[] m1High = new byte[2048];
        byte[] m2 = new byte[4096];
        for (int i = 0; i < dataShort.length; ++i) {
            short s = dataShort[i];
            int nI = i >>> 1;
            int mI = (i & 1) * 4;
            int n = nI;
            m1Low[n] = (byte)(m1Low[n] | (byte)((s & 0xF) << mI));
            int n2 = nI;
            m1High[n2] = (byte)(m1High[n2] | (byte)((s & 0xF0) >>> 4 << mI));
            m2[i] = (byte)((s & 0xFF00) >>> 8);
        }
        subChunk.eid$setM1Low(new NibbleArray(m1Low, 4));
        subChunk.eid$setM1High(new NibbleArray(m1High, 4));
        subChunk.eid$setM2(m2);
    }

    public void readSubChunkFromNBT(Chunk chunk, ExtendedBlockStorage subChunkVanilla, NBTTagCompound nbt) {
        SubChunkBlockHook subChunk = (SubChunkBlockHook)subChunkVanilla;
        if (nbt.func_74764_b("Data16")) {
            this.readSubChunkFromNBTNotEnoughIDsDFU(subChunk, nbt);
            return;
        }
        assert (nbt.func_74764_b("Data"));
        byte[] m1Low = nbt.func_74770_j("Data");
        byte[] m1High = nbt.func_74764_b("Data1High") ? nbt.func_74770_j("Data1High") : null;
        byte[] m2 = nbt.func_74764_b("Data2") ? nbt.func_74770_j("Data2") : null;
        subChunk.eid$setM1Low(DataUtil.ensureSubChunkNibbleArray(m1Low));
        subChunk.eid$setM1High(DataUtil.ensureSubChunkNibbleArray(m1High));
        subChunk.eid$setM2(DataUtil.ensureSubChunkByteArray(m2));
    }

    public void cloneSubChunk(Chunk fromChunk, ExtendedBlockStorage fromVanilla, ExtendedBlockStorage toVanilla) {
        SubChunkBlockHook from = (SubChunkBlockHook)fromVanilla;
        SubChunkBlockHook to = (SubChunkBlockHook)toVanilla;
        to.eid$setM1Low(ArrayUtil.copyArray((NibbleArray)from.eid$getM1Low(), (NibbleArray)to.eid$getM1Low()));
        to.eid$setM1High(ArrayUtil.copyArray((NibbleArray)from.eid$getM1High(), (NibbleArray)to.eid$getM1High()));
        to.eid$setM2(ArrayUtil.copyArray((byte[])from.eid$getM2(), (byte[])to.eid$getM2()));
    }

    @NotNull
    public String version() {
        return "1.6.12";
    }

    @Nullable
    public String newInstallDescription() {
        return "EndlessIDs extended block metadata. Vanilla worlds can be converted to EndlessIDs worlds safely.";
    }

    @NotNull
    public String uninstallMessage() {
        return "EndlessIDs extended block metadata removed. Any blocks with metadata above 15 will get corrupted.";
    }

    @Nullable
    public String versionChangeMessage(String priorVersion) {
        return null;
    }

    public void writeBlockToPacket(Chunk chunk, int x, int y, int z, S23PacketBlockChange packet) {
    }

    public void readBlockFromPacket(Chunk chunk, int x, int y, int z, S23PacketBlockChange packet) {
    }

    public void writeBlockPacketToBuffer(S23PacketBlockChange packet, PacketBuffer buffer) {
        buffer.writeShort(packet.field_148884_e & 0xFFFF);
    }

    public void readBlockPacketFromBuffer(S23PacketBlockChange packet, PacketBuffer buffer) {
        packet.field_148884_e = buffer.readUnsignedShort();
    }
}

