/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.endlessids.mixin.mixins.common.biome.jas;

import com.falsepattern.endlessids.mixin.helpers.ChunkBiomeHook;
import com.google.common.collect.ImmutableMap;
import jas.spawner.modern.spawner.creature.type.CreatureType;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={CreatureType.class})
public class ModernCreatureTypeMixin {
    @Shadow(remap=false)
    @Final
    public int defaultBiomeCap;
    @Shadow(remap=false)
    @Final
    public ImmutableMap<Integer, Integer> biomeCaps;

    @Overwrite(remap=false)
    public int getChunkCap(Chunk chunk) {
        if (chunk != null && this.defaultBiomeCap > 0) {
            short[] biomeArray;
            int chunkCap = 0;
            int counter = 0;
            for (short value : biomeArray = ((ChunkBiomeHook)chunk).getBiomeShortArray()) {
                int biomeID = value & 0xFFFF;
                int columnCap = (Integer)this.biomeCaps.getOrDefault((Object)biomeID, (Object)this.defaultBiomeCap);
                chunkCap += columnCap;
                ++counter;
            }
            return counter > 0 ? chunkCap / counter : -1;
        }
        return -1;
    }
}

