/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.endlessids.mixin.mixins.common.blockitem.vanilla;

import com.falsepattern.endlessids.EndlessIDs;
import com.falsepattern.endlessids.Hooks;
import com.falsepattern.endlessids.config.GeneralConfig;
import com.falsepattern.endlessids.mixin.helpers.SubChunkBlockHook;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ExtendedBlockStorage.class})
public abstract class ExtendedBlockStorageMixin
implements SubChunkBlockHook {
    @Shadow
    private int field_76682_b;
    @Shadow
    private int field_76683_c;
    @Shadow
    private byte[] field_76680_d;
    @Shadow
    private NibbleArray field_76681_e;
    private NibbleArray b2High;
    private byte[] b3;
    @Shadow
    private NibbleArray field_76678_f;
    private NibbleArray m1High;
    private byte[] m2;

    @Override
    public int eid$getID(int x, int y, int z) {
        int index = y << 8 | z << 4 | x;
        int id = this.field_76680_d[index] & 0xFF;
        if (this.field_76681_e != null) {
            id |= this.field_76681_e.func_76582_a(x, y, z) << 8;
            if (this.b2High != null) {
                id |= this.b2High.func_76582_a(x, y, z) << 12;
                if (this.b3 != null) {
                    id |= (this.b3[index] & 0xFF) << 16;
                }
            }
        }
        return id;
    }

    @Override
    public void eid$setID(int x, int y, int z, int id) {
        int index = y << 8 | z << 4 | x;
        this.field_76680_d[index] = (byte)(id & 0xFF);
        if (id > 255) {
            if (this.field_76681_e == null) {
                this.eid$createB2Low();
            }
            if (id > 4095) {
                if (this.b2High == null) {
                    this.eid$createB2High();
                }
                if (id > 65535 && this.b3 == null) {
                    this.eid$createB3();
                }
            }
        }
        if (this.field_76681_e != null) {
            this.field_76681_e.func_76581_a(x, y, z, id >>> 8 & 0xF);
            if (this.b2High != null) {
                this.b2High.func_76581_a(x, y, z, id >>> 12 & 0xF);
                if (this.b3 != null) {
                    this.b3[index] = (byte)(id >>> 16 & 0xFF);
                }
            }
        }
    }

    @Overwrite
    public Block func_150819_a(int x, int y, int z) {
        return Block.func_149729_e((int)this.eid$getID(x, y, z));
    }

    @Overwrite
    public void func_150818_a(int x, int y, int z, Block newBlock) {
        Block oldBlock = this.func_150819_a(x, y, z);
        if (oldBlock != Blocks.field_150350_a) {
            --this.field_76682_b;
            if (oldBlock.func_149653_t()) {
                --this.field_76683_c;
            }
        }
        if (newBlock != Blocks.field_150350_a) {
            ++this.field_76682_b;
            if (newBlock.func_149653_t()) {
                ++this.field_76683_c;
            }
        }
        int blockID = Hooks.getIdFromBlockWithCheck(newBlock, oldBlock);
        this.eid$setID(x, y, z, blockID);
    }

    @Overwrite
    public int func_76665_b(int x, int y, int z) {
        int meta = this.field_76678_f.func_76582_a(x, y, z);
        if (this.m1High != null) {
            meta |= this.m1High.func_76582_a(x, y, z) << 4;
            if (this.m2 != null) {
                meta |= (this.m2[y << 8 | z << 4 | x] & 0xFF) << 8;
            }
        }
        return meta;
    }

    @Overwrite
    public void func_76654_b(int x, int y, int z, int meta) {
        this.field_76678_f.func_76581_a(x, y, z, meta & 0xF);
        if (meta > 15) {
            if (this.m1High == null) {
                this.eid$createM1High();
            }
            if (meta > 255 && this.m2 == null) {
                this.eid$createM2();
            }
        }
        if (this.m1High != null) {
            this.m1High.func_76581_a(x, y, z, meta >>> 4 & 0xF);
            if (this.m2 != null) {
                this.m2[y << 8 | z << 4 | x] = (byte)(meta >>> 8 & 0xFF);
            }
        }
    }

    @Override
    public int eid$getMetadata(int x, int y, int z) {
        return this.func_76665_b(x, y, z);
    }

    @Override
    public void eid$setMetadata(int x, int y, int z, int id) {
        this.func_76654_b(x, y, z, id);
    }

    @Redirect(method={"removeInvalidBlocks"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/storage/ExtendedBlockStorage;getBlockByExtId(III)Lnet/minecraft/block/Block;"), require=1)
    private Block removeInvalidBlocks(ExtendedBlockStorage instance, int x, int y, int z) {
        Block block = instance.func_150819_a(x, y, z);
        if (block == null && GeneralConfig.removeInvalidBlocks) {
            instance.func_150818_a(x, y, z, Blocks.field_150350_a);
            block = Blocks.field_150350_a;
        }
        return block;
    }

    private UnsupportedOperationException emergencyCrash() {
        String crashMSG = "A mod that is incompatible with EndlessIDs has tried to access the block array of a chunk like in vanilla! Crashing in fear of potential world corruption!\nPlease report this issue on https://github.com/GTMEGA/EndlessIDs ASAP!";
        EndlessIDs.LOG.fatal("A mod that is incompatible with EndlessIDs has tried to access the block array of a chunk like in vanilla! Crashing in fear of potential world corruption!\nPlease report this issue on https://github.com/GTMEGA/EndlessIDs ASAP!");
        return new UnsupportedOperationException("A mod that is incompatible with EndlessIDs has tried to access the block array of a chunk like in vanilla! Crashing in fear of potential world corruption!\nPlease report this issue on https://github.com/GTMEGA/EndlessIDs ASAP!");
    }

    @Override
    public byte[] eid$getB1() {
        return this.field_76680_d;
    }

    @Override
    public void eid$setB1(byte[] data) {
        this.field_76680_d = data;
    }

    @Override
    public NibbleArray eid$getB2Low() {
        return this.field_76681_e;
    }

    @Override
    public void eid$setB2Low(NibbleArray data) {
        this.field_76681_e = data;
    }

    @Override
    public NibbleArray eid$createB2Low() {
        this.field_76681_e = new NibbleArray(4096, 4);
        return this.field_76681_e;
    }

    @Override
    public NibbleArray eid$getB2High() {
        return this.b2High;
    }

    @Override
    public void eid$setB2High(NibbleArray data) {
        this.b2High = data;
    }

    @Override
    public NibbleArray eid$createB2High() {
        this.b2High = new NibbleArray(4096, 4);
        return this.b2High;
    }

    @Override
    public byte[] eid$getB3() {
        return this.b3;
    }

    @Override
    public void eid$setB3(byte[] data) {
        this.b3 = data;
    }

    @Override
    public byte[] eid$createB3() {
        this.b3 = new byte[4096];
        return this.b3;
    }

    @Override
    public NibbleArray eid$getM1Low() {
        return this.field_76678_f;
    }

    @Override
    public void eid$setM1Low(NibbleArray m1Low) {
        this.field_76678_f = m1Low;
    }

    @Override
    public NibbleArray eid$getM1High() {
        return this.m1High;
    }

    @Override
    public void eid$setM1High(NibbleArray m1High) {
        this.m1High = m1High;
    }

    @Override
    public NibbleArray eid$createM1High() {
        this.m1High = new NibbleArray(4096, 4);
        return this.m1High;
    }

    @Override
    public byte[] eid$getM2() {
        return this.m2;
    }

    @Override
    public void eid$setM2(byte[] m2) {
        this.m2 = m2;
    }

    @Override
    public byte[] eid$createM2() {
        this.m2 = new byte[4096];
        return this.m2;
    }

    @Override
    public int eid$getBlockMask() {
        if (this.field_76681_e == null) {
            return 0;
        }
        if (this.b2High == null) {
            return 1;
        }
        if (this.b3 == null) {
            return 2;
        }
        return 3;
    }

    @Override
    public int eid$getMetadataMask() {
        if (this.m1High == null) {
            return 1;
        }
        if (this.m2 == null) {
            return 2;
        }
        return 3;
    }

    @Inject(method={"getBlockMSBArray", "createBlockMSBArray"}, at={@At(value="HEAD")}, expect=0)
    private void crashMSBArray(CallbackInfoReturnable<NibbleArray> cir) {
        throw this.emergencyCrash();
    }

    @Inject(method={"clearMSBArray"}, at={@At(value="HEAD")}, expect=0)
    private void crashMSBArray(CallbackInfo ci) {
        throw this.emergencyCrash();
    }

    @Inject(method={"setBlockMSBArray"}, at={@At(value="HEAD")}, expect=0)
    private void crashMSBArray(NibbleArray p_76673_1_, CallbackInfo ci) {
        throw this.emergencyCrash();
    }

    @Inject(method={"setBlockLSBArray"}, at={@At(value="HEAD")}, expect=0)
    private void crashLSBArray(byte[] p_76664_1_, CallbackInfo ci) {
        throw this.emergencyCrash();
    }

    @Inject(method={"getBlockLSBArray"}, at={@At(value="HEAD")}, expect=0)
    private void crashLSBArray(CallbackInfoReturnable<byte[]> cir) {
        throw this.emergencyCrash();
    }

    @Inject(method={"setBlockMetadataArray"}, at={@At(value="HEAD")}, expect=0)
    private void crashMetadataArray(NibbleArray p_76668_1_, CallbackInfo ci) {
        throw this.emergencyCrash();
    }

    @Inject(method={"getMetadataArray"}, at={@At(value="HEAD")}, expect=0)
    private void crashMetadataArray(CallbackInfoReturnable<NibbleArray> cir) {
        throw this.emergencyCrash();
    }
}

