/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.endlessids.mixin.mixins.common.entity.vanilla;

import com.falsepattern.endlessids.mixin.helpers.EntityRegistryAccessor;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.BitSet;
import net.minecraft.entity.EntityList;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;

@Mixin(value={EntityRegistry.class}, remap=false)
public abstract class EntityRegistryMixin
implements EntityRegistryAccessor {
    @Shadow
    private BitSet availableIndicies;

    @Override
    public BitSet eids$availableIndicies() {
        return this.availableIndicies;
    }

    @ModifyConstant(method={"<init>"}, constant={@Constant(intValue=256)}, require=1)
    private int extendIDs1(int constant) {
        return 32768;
    }

    @ModifyConstant(method={"<init>"}, constant={@Constant(intValue=255)}, require=1)
    private int extendIDs2(int constant) {
        return Short.MAX_VALUE;
    }

    @Overwrite
    private int validateAndClaimId(int id) {
        for (Integer key : EntityList.field_75623_d.keySet()) {
            this.availableIndicies.clear(key);
        }
        int realId = id;
        if (id < -128) {
            FMLLog.warning((String)"Compensating for modloader out of range compensation by mod : entityId %d for mod %s is now %d", (Object[])new Object[]{id, Loader.instance().activeModContainer().getModId(), realId += 3000});
        }
        if (realId < 0) {
            realId += 127;
        }
        if ((realId & Short.MIN_VALUE) != 0) {
            FMLLog.log((Level)Level.ERROR, (String)"The entity ID %d for mod %s is not in the range 1-32767 and may not work", (Object[])new Object[]{id, Loader.instance().activeModContainer().getModId()});
        }
        if (!this.availableIndicies.get(realId)) {
            FMLLog.severe((String)"The mod %s has attempted to register an entity ID %d which is already reserved. This could cause severe problems", (Object[])new Object[]{Loader.instance().activeModContainer().getModId(), id});
        }
        this.availableIndicies.clear(realId);
        return realId;
    }
}

