/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.endlessids.mixin.mixins.common.potion.thaumcraft;

import java.io.File;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.config.Configuration;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import thaumcraft.api.potions.PotionFluxTaint;
import thaumcraft.api.potions.PotionVisExhaust;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.lib.potions.PotionBlurredVision;
import thaumcraft.common.lib.potions.PotionDeathGaze;
import thaumcraft.common.lib.potions.PotionInfectiousVisExhaust;
import thaumcraft.common.lib.potions.PotionSunScorned;
import thaumcraft.common.lib.potions.PotionThaumarhia;
import thaumcraft.common.lib.potions.PotionUnnaturalHunger;
import thaumcraft.common.lib.potions.PotionWarpWard;

@Mixin(value={Config.class}, remap=false)
public abstract class ConfigMixin {
    @Shadow
    public static Configuration config;
    @Shadow
    public static int potionTaintPoisonID;
    @Shadow
    public static int potionVisExhaustID;
    @Shadow
    public static int potionInfVisExhaustID;
    @Shadow
    public static int potionUnHungerID;
    @Shadow
    public static int potionWarpWardID;
    @Shadow
    public static int potionDeathGazeID;
    @Shadow
    public static int potionBlurredID;
    @Shadow
    public static int potionSunScornedID;
    @Shadow
    public static int potionThaumarhiaID;
    @Unique
    private static final String EID$CATEGORY_POTION_IDS = "Potion_IDs";

    @Shadow
    public static void save() {
    }

    @Overwrite
    static int getNextPotionId(int id) {
        boolean next = true;
        while (next) {
            next = false;
            if (id > 0 && id < Potion.field_76425_a.length && Potion.field_76425_a[id] == null) continue;
            if (++id < Potion.field_76425_a.length) {
                next = true;
                continue;
            }
            id = -1;
        }
        return id;
    }

    @Inject(method={"initialize"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/common/config/Configuration;load()V")}, require=1)
    private static void addPotionIDsCategory(File file, CallbackInfo ci) {
        config.addCustomCategoryComment(EID$CATEGORY_POTION_IDS, "Potion IDs (extended by EndlessIDs)");
    }

    @Unique
    private static int eid$tryGetPotionFromConfigOrAuto(String name, int id) {
        id = ConfigMixin.getNextPotionId(id);
        return config.get(EID$CATEGORY_POTION_IDS, name, id).getInt();
    }

    @Inject(method={"initPotions"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private static void endlessIDsInitPotions(CallbackInfo ci) {
        ci.cancel();
        int id = 1000;
        id = ConfigMixin.eid$tryGetPotionFromConfigOrAuto("potion_1_flux_taint", id);
        if (id >= 0) {
            potionTaintPoisonID = id;
            PotionFluxTaint.instance = new PotionFluxTaint(potionTaintPoisonID, true, 0x663377);
            PotionFluxTaint.init();
            Thaumcraft.log.info("Initializing PotionFluxTaint with id {}", new Object[]{id});
        }
        if ((id = ConfigMixin.eid$tryGetPotionFromConfigOrAuto("potion_2_vis_exhaust", id)) >= 0) {
            potionVisExhaustID = id;
            PotionVisExhaust.instance = new PotionVisExhaust(potionVisExhaustID, true, 0x664477);
            PotionVisExhaust.init();
            Thaumcraft.log.info("Initializing PotionVisExhaust with id {}", new Object[]{id});
        }
        if ((id = ConfigMixin.eid$tryGetPotionFromConfigOrAuto("potion_3_infectious_vis_exhaust", id)) >= 0) {
            potionInfVisExhaustID = id;
            PotionInfectiousVisExhaust.instance = new PotionInfectiousVisExhaust(potionInfVisExhaustID, true, 0x665577);
            PotionInfectiousVisExhaust.init();
            Thaumcraft.log.info("Initializing PotionInfectiousVisExhaust with id {}", new Object[]{id});
        }
        if ((id = ConfigMixin.eid$tryGetPotionFromConfigOrAuto("potion_4_unnatural_hunger", id)) >= 0) {
            potionUnHungerID = id;
            PotionUnnaturalHunger.instance = new PotionUnnaturalHunger(potionUnHungerID, true, 0x446633);
            PotionUnnaturalHunger.init();
            Thaumcraft.log.info("Initializing PotionUnnaturalHunger with id {}", new Object[]{id});
        }
        if ((id = ConfigMixin.eid$tryGetPotionFromConfigOrAuto("potion_5_warp_ward", id)) >= 0) {
            potionWarpWardID = id;
            PotionWarpWard.instance = new PotionWarpWard(potionWarpWardID, false, 14742263);
            PotionWarpWard.init();
            Thaumcraft.log.info("Initializing PotionWarpWard with id {}", new Object[]{id});
        }
        if ((id = ConfigMixin.eid$tryGetPotionFromConfigOrAuto("potion_6_death_gaze", id)) >= 0) {
            potionDeathGazeID = id;
            PotionDeathGaze.instance = new PotionDeathGaze(potionDeathGazeID, true, 0x664433);
            PotionDeathGaze.init();
            Thaumcraft.log.info("Initializing PotionDeathGaze with id {}", new Object[]{id});
        }
        if ((id = ConfigMixin.eid$tryGetPotionFromConfigOrAuto("potion_7_blurred_vision", id)) >= 0) {
            potionBlurredID = id;
            PotionBlurredVision.instance = new PotionBlurredVision(potionBlurredID, true, 0x808080);
            PotionBlurredVision.init();
            Thaumcraft.log.info("Initializing PotionBlurredVision with id {}", new Object[]{id});
        }
        if ((id = ConfigMixin.eid$tryGetPotionFromConfigOrAuto("potion_8_sun_scorned", id)) >= 0) {
            potionSunScornedID = id;
            PotionSunScorned.instance = new PotionSunScorned(potionSunScornedID, true, 16308330);
            PotionSunScorned.init();
            Thaumcraft.log.info("Initializing PotionSunScorned with id {}", new Object[]{id});
        }
        if ((id = ConfigMixin.eid$tryGetPotionFromConfigOrAuto("potion_9_thaumarhia", id)) >= 0) {
            potionThaumarhiaID = id;
            PotionThaumarhia.instance = new PotionThaumarhia(potionThaumarhiaID, true, 0x664477);
            PotionThaumarhia.init();
            Thaumcraft.log.info("Initializing PotionThaumarhia with id {}", new Object[]{id});
        }
        ConfigMixin.save();
    }
}

