/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.endlessids.mixin.mixins.common.potion.vanilla;

import com.falsepattern.endlessids.EndlessIDs;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PotionEffect.class}, priority=2000)
public abstract class PotionEffectMixin {
    @Shadow
    private int field_76462_a;

    @Inject(method={"<init>(IIIZ)V"}, at={@At(value="RETURN")}, require=1)
    private void fixOutOfBoundsID(int p_i1576_1_, int p_i1576_2_, int p_i1576_3_, boolean p_i1576_4_, CallbackInfo ci) {
        int id = p_i1576_1_ & 0xFFFF;
        if (id != p_i1576_1_ && Potion.field_76425_a[id] == null) {
            int realId = id;
            if (Potion.field_76425_a[id &= 0xFF] == null) {
                id = realId;
            }
        }
        if (Potion.field_76425_a[id] == null) {
            EndlessIDs.LOG.error("Encountered invalid potion ID: {}. See the following stacktrace for more info.", new Object[]{p_i1576_1_});
            EndlessIDs.LOG.error("Stacktrace:", new Throwable());
            EndlessIDs.LOG.error("Recovering to a valid potion ID (usually movement speed)");
            for (int i = 0; i < Potion.field_76425_a.length; ++i) {
                if (Potion.field_76425_a[i] == null) continue;
                id = i;
                break;
            }
        }
        this.field_76462_a = id;
    }

    @Inject(method={"readCustomPotionEffectFromNBT"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private static void readCustomPotionEffectFromNBT(NBTTagCompound nbt, CallbackInfoReturnable<PotionEffect> cir) {
        int id = nbt.func_74764_b("IdExtended") ? nbt.func_74762_e("IdExtended") : nbt.func_74771_c("Id") & 0xFF;
        if (id >= 0 && id < Potion.field_76425_a.length && Potion.field_76425_a[id] != null) {
            byte b1 = nbt.func_74771_c("Amplifier");
            int i = nbt.func_74762_e("Duration");
            boolean flag = nbt.func_74767_n("Ambient");
            cir.setReturnValue((Object)new PotionEffect(id, i, (int)b1, flag));
        } else {
            cir.setReturnValue(null);
        }
    }

    @Shadow
    public abstract int func_76456_a();

    @Shadow
    public abstract int func_76458_c();

    @Shadow
    public abstract int func_76459_b();

    @Shadow
    public abstract boolean func_82720_e();

    @Inject(method={"writeCustomPotionEffectToNBT"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void writeCustomPotionEffectToNBTExtended(NBTTagCompound nbt, CallbackInfoReturnable<NBTTagCompound> cir) {
        int potionID = this.func_76456_a();
        if (potionID > 127) {
            nbt.func_74768_a("IdExtended", potionID);
            nbt.func_74774_a("Id", (byte)-1);
        } else {
            nbt.func_74774_a("Id", (byte)potionID);
        }
        nbt.func_74774_a("Amplifier", (byte)this.func_76458_c());
        nbt.func_74768_a("Duration", this.func_76459_b());
        nbt.func_74757_a("Ambient", this.func_82720_e());
        cir.setReturnValue((Object)nbt);
    }
}

