/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.endlessids.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class WeakIdentityHashMap<K, V> {
    private final HashMap<WeakReference<K>, V> mMap = new HashMap();
    private final ReferenceQueue<Object> mRefQueue = new ReferenceQueue();

    private void cleanUp() {
        Reference<Object> ref;
        while ((ref = this.mRefQueue.poll()) != null) {
            this.mMap.remove(ref);
        }
    }

    public void put(K key, V value) {
        this.cleanUp();
        this.mMap.put(new CmpWeakReference<K>(key, this.mRefQueue), value);
    }

    public V get(K key) {
        this.cleanUp();
        return this.mMap.get(new CmpWeakReference<K>(key));
    }

    public Collection<V> values() {
        this.cleanUp();
        return this.mMap.values();
    }

    public Set<Map.Entry<WeakReference<K>, V>> entrySet() {
        return this.mMap.entrySet();
    }

    public int size() {
        this.cleanUp();
        return this.mMap.size();
    }

    public boolean isEmpty() {
        this.cleanUp();
        return this.mMap.isEmpty();
    }

    private static class CmpWeakReference<K>
    extends WeakReference<K> {
        private final int mHashCode;

        public CmpWeakReference(K key) {
            super(key);
            this.mHashCode = System.identityHashCode(key);
        }

        public CmpWeakReference(K key, ReferenceQueue<Object> refQueue) {
            super(key, refQueue);
            this.mHashCode = System.identityHashCode(key);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            Object k = this.get();
            if (k != null && o instanceof CmpWeakReference) {
                return ((CmpWeakReference)o).get() == k;
            }
            return false;
        }

        public int hashCode() {
            return this.mHashCode;
        }
    }
}

