/*
 * Decompiled with CFR 0.152.
 */
package com.plusls.MasaGadget.impl.feature.entityInfo;

import com.google.common.collect.Queues;
import com.plusls.MasaGadget.game.Configs;
import com.plusls.MasaGadget.impl.feature.entityInfo.VillagerNextRestockTimeInfo;
import com.plusls.MasaGadget.impl.feature.entityInfo.VillagerTradeEnchantedBookInfo;
import com.plusls.MasaGadget.impl.feature.entityInfo.ZombieVillagerConvertTimeInfo;
import com.plusls.MasaGadget.util.MiscUtil;
import com.plusls.MasaGadget.util.SyncUtil;
import java.util.Queue;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_1641;
import net.minecraft.class_1646;
import net.minecraft.class_1937;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.event.Listener;
import top.hendrixshen.magiclib.api.event.minecraft.render.RenderEntityListener;
import top.hendrixshen.magiclib.api.event.minecraft.render.RenderLevelListener;
import top.hendrixshen.magiclib.api.render.context.RenderContext;
import top.hendrixshen.magiclib.impl.render.TextRenderer;

public class EntityInfoRenderer
implements RenderEntityListener,
RenderLevelListener {
    private static final EntityInfoRenderer instance = new EntityInfoRenderer();
    private final Queue<class_1297> queue = Queues.newConcurrentLinkedQueue();

    @ApiStatus.Internal
    public void init() {
        MagicLib.getInstance().getEventManager().register(RenderEntityListener.class, (Listener)this);
        MagicLib.getInstance().getEventManager().register(RenderLevelListener.class, (Listener)this);
    }

    private static TextRenderer rotationAround(@NotNull TextRenderer renderer, @NotNull class_2374 centerPos, double range) {
        class_243 camPos = class_310.method_1551().field_1773.method_19418().method_19326();
        float xAngle = (float)class_3532.method_15349((double)(camPos.method_10215() - centerPos.method_10215()), (double)(camPos.method_10216() - centerPos.method_10216()));
        float zAngle = (float)class_3532.method_15349((double)(camPos.method_10216() - centerPos.method_10216()), (double)(camPos.method_10215() - centerPos.method_10215()));
        return renderer.at(range * (double)class_3532.method_15362((float)xAngle) + centerPos.method_10216(), centerPos.method_10214(), range * (double)class_3532.method_15362((float)zAngle) + centerPos.method_10215());
    }

    public void preRenderEntity(class_1297 entity, RenderContext renderContext, float partialTicks) {
    }

    public void postRenderEntity(class_1297 entity, RenderContext renderContext, float partialTicks) {
        if (entity instanceof class_1646 && (Configs.renderNextRestockTime.getBooleanValue() || Configs.renderTradeEnchantedBook.getBooleanValue()) || entity instanceof class_1641 && Configs.renderZombieVillagerConvertTime.getBooleanValue()) {
            this.queue.add(entity);
        }
    }

    public void preRenderLevel(class_1937 level, RenderContext renderContext, float partialTicks) {
    }

    public void postRenderLevel(class_1937 level, RenderContext renderContext, float partialTicks) {
        for (class_1297 entity : this.queue) {
            if (entity instanceof class_1646) {
                class_2561 info;
                class_1646 villager = (class_1646)MiscUtil.cast((Object)SyncUtil.syncEntityDataFromIntegratedServer(entity));
                TextRenderer renderer = TextRenderer.create();
                if (Configs.renderNextRestockTime.getBooleanValue() && (info = VillagerNextRestockTimeInfo.getInfo(villager)) != null) {
                    renderer.addLine(info);
                }
                if (Configs.renderTradeEnchantedBook.getBooleanValue()) {
                    VillagerTradeEnchantedBookInfo.getInfo(villager).forEach(arg_0 -> ((TextRenderer)renderer).addLine(arg_0));
                }
                if (villager.method_6113()) {
                    class_243 position = entity.method_5836(partialTicks);
                    renderer.at(position.method_10216(), position.method_10214() + (double)0.4f, position.method_10215());
                } else {
                    EntityInfoRenderer.rotationAround(renderer, (class_2374)entity.method_5836(partialTicks), 0.6);
                }
                renderer.bgColor((int)(class_310.method_1551().field_1690.method_19343(0.25f) * 255.0f) << 24).fontScale((double)0.015f).seeThrough().render();
                continue;
            }
            if (!(entity instanceof class_1641)) continue;
            class_1641 zombieVillager = (class_1641)MiscUtil.cast((Object)SyncUtil.syncEntityDataFromIntegratedServer(entity));
            EntityInfoRenderer.rotationAround(TextRenderer.create(), (class_2374)entity.method_5836(partialTicks), 0.6).text(ZombieVillagerConvertTimeInfo.getInfo(zombieVillager)).bgColor((int)(class_310.method_1551().field_1690.method_19343(0.25f) * 255.0f) << 24).fontScale((double)0.015f).seeThrough().render();
        }
        this.queue.clear();
    }

    @Generated
    public static EntityInfoRenderer getInstance() {
        return instance;
    }
}

