/*
 * Decompiled with CFR 0.152.
 */
package infinityi.inventorymenu.action.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import infinityi.inventorymenu.InventoryMenu;
import infinityi.inventorymenu.action.Action;
import infinityi.inventorymenu.action.ActionType;
import infinityi.inventorymenu.menu.MenuLayout;
import java.util.Map;
import java.util.NavigableMap;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public record MenuNavigationAction(String navigate, class_2960 destination) implements Action
{
    public static final MapCodec<MenuNavigationAction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("action").forGetter(MenuNavigationAction::navigate), (App)class_2960.field_25139.optionalFieldOf("menu", (Object)class_2960.method_60654((String)"")).forGetter(MenuNavigationAction::destination)).apply((Applicative)instance, MenuNavigationAction::new));

    @Override
    public void execute(class_3222 player) {
        MenuLayout layout = InventoryMenu.getDataManager().playerData().currentMenu.get(player);
        switch (this.navigate) {
            case "close": {
                player.method_7346();
                break;
            }
            case "open": {
                InventoryMenu.getDataManager().menus().getMenu(this.destination).ifPresentOrElse(menuLayout -> menuLayout.open(player), () -> {
                    player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cThis menu doesn't exist"));
                    player.method_7346();
                });
                break;
            }
            case "next": {
                this.scroll_menu(player, layout, true);
                break;
            }
            case "previous": {
                this.scroll_menu(player, layout, false);
            }
        }
    }

    @Override
    public ActionType getType() {
        return ActionType.NAVIGATE;
    }

    public void scroll_menu(class_3222 player, MenuLayout currentLayout, Boolean isNext) {
        Map.Entry<Integer, MenuLayout> targetEntry;
        String name = (String)currentLayout.menu_group().getFirst();
        int currentIndex = (Integer)currentLayout.menu_group().getSecond();
        NavigableMap<Integer, MenuLayout> groupMenu = InventoryMenu.getDataManager().menus().getGroup(name);
        if (groupMenu.isEmpty() || groupMenu.size() == 1) {
            return;
        }
        Map.Entry<Integer, MenuLayout> entry = targetEntry = isNext != false ? groupMenu.higherEntry(currentIndex) : groupMenu.lowerEntry(currentIndex);
        if (targetEntry == null) {
            targetEntry = groupMenu.firstEntry();
        }
        MenuLayout nextLayout = targetEntry.getValue();
        nextLayout.open(player);
    }
}

