/*
 * Decompiled with CFR 0.152.
 */
package infinityi.inventorymenu.action.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import infinityi.inventorymenu.action.Action;
import infinityi.inventorymenu.action.ActionType;
import infinityi.inventorymenu.placeholder.providers.PlaceholderProvider;
import infinityi.inventorymenu.util.teleportutil.TeleportCost;
import infinityi.inventorymenu.util.teleportutil.tplocation.TPLocation;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public record TeleportAction(TPLocation target, TeleportCost cost, Boolean safe_check) implements Action,
PlaceholderProvider
{
    public static final MapCodec<TeleportAction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TPLocation.CODEC.fieldOf("pos").forGetter(TeleportAction::target), (App)TeleportCost.CODEC.optionalFieldOf("cost", (Object)TeleportCost.empty()).forGetter(TeleportAction::cost), (App)Codec.BOOL.optionalFieldOf("safe_check", (Object)false).forGetter(TeleportAction::safe_check)).apply((Applicative)instance, TeleportAction::new));

    public static Map<String, Supplier<Object>> createKeySuppliers(class_3222 player, TeleportAction action) {
        return Map.of("xp_cost", () -> action.cost.calcCost(player, action.target.getPos(player.method_51469().method_8503())), "xp_cost_type", () -> action.cost.isPoint().toString(), "target_pos", () -> {
            class_2338 pos = action.target.getPos(player.method_51469().method_8503());
            return String.format("X: %s Y: %s Z: %s", pos.method_10263(), pos.method_10264(), pos.method_10260());
        }, "target_name", () -> Optional.ofNullable(action.target.getPlayer(player.method_51469().method_8503())).map(s -> s.method_5477().getString()).orElse("?"), "distance", () -> action.target.getDistance(player));
    }

    public static boolean isDangerLocation(class_3218 world, class_2338 pos) {
        if (world == null || pos == null) {
            return true;
        }
        class_2338 floorPos = pos.method_10074();
        class_2338 headPos = pos.method_10084();
        world.method_22350(floorPos);
        if (!world.method_8320(floorPos).method_26212((class_1922)world, headPos)) {
            return true;
        }
        class_2680 feetState = world.method_8320(pos);
        class_2680 headState = world.method_8320(headPos);
        if (feetState.method_26228((class_1922)world, pos) || headState.method_26228((class_1922)world, headPos)) {
            return true;
        }
        return TeleportAction.isDangerBlock(feetState) || TeleportAction.isDangerBlock(headState);
    }

    public static int distanceBetween(class_2338 pos1, class_2338 pos2) {
        return pos1.method_65076((class_2382)pos2);
    }

    private static boolean isDangerBlock(class_2680 state) {
        return state.method_27852(class_2246.field_10164) || state.method_27852(class_2246.field_10036) || state.method_27852(class_2246.field_10029) || state.method_27852(class_2246.field_16999) || state.method_27852(class_2246.field_27879);
    }

    @Override
    public void execute(class_3222 player) {
        class_2338 pos = this.target.getPos(player.method_51469().method_8503());
        if (this.cost.hasCost(player, pos)) {
            this.target.teleport(player, this.safe_check, this.cost);
        } else {
            player.method_64398((class_2561)class_2561.method_43471((String)"Not enough experience.").method_27692(class_124.field_1061));
        }
    }

    @Override
    public ActionType getType() {
        return ActionType.TELEPORT;
    }

    @Override
    public Optional<String> getKey(String key, class_3222 player) {
        Map<String, Supplier<Object>> keySuppliers = TeleportAction.createKeySuppliers(player, this);
        return Optional.ofNullable(keySuppliers.get(key)).map(Supplier::get).map(String::valueOf);
    }

    @Deprecated
    private static int chebyshevDistance(class_2338 a, class_2338 b) {
        int dx = Math.abs(a.method_10263() - b.method_10263());
        int dy = Math.abs(a.method_10264() - b.method_10264());
        int dz = Math.abs(a.method_10260() - b.method_10260());
        return Math.max(dx, Math.max(dy, dz));
    }
}

