/*
 * Decompiled with CFR 0.152.
 */
package infinityi.inventorymenu.dataparser;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import infinityi.inventorymenu.InventoryMenu;
import infinityi.inventorymenu.menu.layout.MenuItem;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;

public class ItemDataManager
implements class_3302,
IdentifiableResourceReloadListener {
    private static final String MENU_ITEMS_DIR = "menu-item";
    private static final Map<class_2960, MenuItem> loadItems = new HashMap<class_2960, MenuItem>();

    protected Map<class_2960, MenuItem> prepare(class_3300 manager) {
        HashMap<class_2960, MenuItem> preparedData = new HashMap<class_2960, MenuItem>();
        Map foundResources = manager.method_14488(MENU_ITEMS_DIR, path -> path.method_12832().endsWith(".json"));
        for (Map.Entry entry : foundResources.entrySet()) {
            try (InputStreamReader reader = new InputStreamReader(((class_3298)entry.getValue()).method_14482());){
                JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                MenuItem element = (MenuItem)MenuItem.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(IllegalStateException::new);
                String path2 = ((class_2960)entry.getKey()).toString();
                path2 = path2.substring(0, path2.lastIndexOf(".")).replaceFirst("menu-item/", "");
                preparedData.put(class_2960.method_60654((String)path2), element);
            }
            catch (Exception e) {
                InventoryMenu.LOGGER.error("Error while reading file resource: {}", entry.getKey(), (Object)e);
            }
        }
        return preparedData;
    }

    protected void apply(Map<class_2960, MenuItem> prepared) {
        loadItems.clear();
        loadItems.putAll(prepared);
        if (loadItems.isEmpty()) {
            return;
        }
        InventoryMenu.LOGGER.info("Successfully loaded {} menu item.", (Object)loadItems.size());
    }

    public Optional<MenuItem> getItem(class_2960 identifier) {
        return Optional.ofNullable(loadItems.get(identifier));
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 manager, Executor prepareExecutor, Executor applyExecutor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.prepare(manager), prepareExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)synchronizer).method_18352(arg_0))).thenAcceptAsync(this::apply, applyExecutor);
    }

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"inventory-menu", (String)"item-menu-data-manager");
    }
}

