/*
 * Decompiled with CFR 0.152.
 */
package infinityi.inventorymenu.dataparser;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import infinityi.inventorymenu.InventoryMenu;
import infinityi.inventorymenu.menu.MenuLayout;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;

public class MenuDataManager
implements class_3302,
IdentifiableResourceReloadListener {
    private static final String MENUS_DIRECTORY = "menu";
    private final Map<class_2960, MenuLayout> loadedMenus = new HashMap<class_2960, MenuLayout>();
    private final Map<String, Map<Integer, MenuLayout>> groupedMenus = new HashMap<String, Map<Integer, MenuLayout>>();

    public Optional<MenuLayout> getMenu(class_2960 menuId) {
        return Optional.ofNullable(this.loadedMenus.get(menuId));
    }

    public NavigableMap<Integer, MenuLayout> getGroup(String groupName) {
        return new TreeMap<Integer, MenuLayout>(this.groupedMenus.getOrDefault(groupName, Collections.emptyMap()));
    }

    public class_2561 getMenuName(class_2960 menuId) {
        Optional<MenuLayout> menu = this.getMenu(menuId);
        if (menu.isEmpty()) {
            return class_2561.method_43473();
        }
        return menu.get().name();
    }

    public Set<class_2960> getIds() {
        return this.loadedMenus.keySet();
    }

    protected Map<class_2960, MenuLayout> prepare(class_3300 manager) {
        HashMap<class_2960, MenuLayout> preparedData = new HashMap<class_2960, MenuLayout>();
        Map foundResources = manager.method_14488(MENUS_DIRECTORY, path -> path.method_12832().endsWith(".json"));
        for (Map.Entry entry : foundResources.entrySet()) {
            try (InputStreamReader reader = new InputStreamReader(((class_3298)entry.getValue()).method_14482(), StandardCharsets.UTF_8);){
                JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                MenuLayout layout = (MenuLayout)MenuLayout.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(IllegalStateException::new);
                class_2960 originalId = (class_2960)entry.getKey();
                String path2 = originalId.method_12832();
                path2 = path2.substring(0, path2.lastIndexOf(".")).replaceFirst("^menu/", "");
                class_2960 menuId = class_2960.method_60655((String)originalId.method_12836(), (String)path2);
                preparedData.put(menuId, layout);
            }
            catch (Exception e) {
                InventoryMenu.LOGGER.error("Error while reading file resource: {}\n{}", entry.getKey(), (Object)e.getMessage());
            }
        }
        return preparedData;
    }

    protected void apply(Map<class_2960, MenuLayout> prepared) {
        this.loadedMenus.clear();
        this.groupedMenus.clear();
        this.loadedMenus.putAll(prepared);
        for (MenuLayout layout : this.loadedMenus.values()) {
            Pair<String, Integer> group = layout.menu_group();
            if (group == null || ((String)group.getFirst()).isEmpty()) continue;
            this.groupedMenus.computeIfAbsent((String)group.getFirst(), k -> new TreeMap()).put((Integer)group.getSecond(), layout);
        }
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 manager, Executor prepareExecutor, Executor applyExecutor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.prepare(manager), prepareExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)synchronizer).method_18352(arg_0))).thenAcceptAsync(this::apply, applyExecutor);
    }

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"inventory-menu", (String)"menu-data-manager");
    }
}

