/*
 * Decompiled with CFR 0.152.
 */
package infinityi.inventorymenu.menu;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import infinityi.inventorymenu.action.Action;
import infinityi.inventorymenu.action.type.MessageAction;
import infinityi.inventorymenu.action.type.NoAction;
import infinityi.inventorymenu.dataparser.ConfigManager;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_181;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.server.MinecraftServer;

public record MenuPredicate(class_2960 predicate, Action whenTrue, Action whenFalse) {
    public static final MenuPredicate EMPTY = new MenuPredicate(class_2960.method_60654((String)""), new NoAction(), new NoAction());
    public static final Codec<MenuPredicate> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_2960.field_25139.fieldOf("id").forGetter(MenuPredicate::predicate), (App)Action.CODEC.optionalFieldOf("on_true", (Object)new NoAction()).forGetter(MenuPredicate::whenTrue), (App)Action.CODEC.optionalFieldOf("on_false", (Object)new NoAction()).forGetter(MenuPredicate::whenFalse)).apply((Applicative)inst, MenuPredicate::new));

    public boolean test(class_3222 player, String context) {
        class_3218 serverWorld = player.method_51469();
        if (serverWorld == null) {
            return false;
        }
        MinecraftServer server = serverWorld.method_8503();
        class_8567 worldContext = new class_8567.class_8568(serverWorld).method_51874(class_181.field_1226, (Object)player).method_51874(class_181.field_24424, (Object)player.method_24515().method_46558()).method_51874(class_181.field_1231, (Object)player.method_48923().method_48802((class_1657)player)).method_51875(class_173.field_1173);
        class_47 lootContext = new class_47.class_48(worldContext).method_304(serverWorld.method_8412()).method_309(Optional.empty());
        boolean result = this.read(server).map(condition -> condition.test((Object)lootContext)).orElse(true);
        this.defaultMessage(player, result, context);
        if (!(this.whenTrue instanceof NoAction) && result) {
            this.whenTrue.execute(player);
        }
        if (!(this.whenFalse instanceof NoAction) && !result) {
            this.whenFalse.execute(player);
        }
        return result;
    }

    public Optional<class_5341> read(MinecraftServer server) {
        return server.method_58576().method_58294().method_46762(class_7924.field_50081).method_46746(class_5321.method_29179((class_5321)class_7924.field_50081, (class_2960)this.predicate)).map(class_6880::comp_349);
    }

    private void defaultMessage(class_3222 player, boolean result, String context) {
        if (!ConfigManager.getConfig().show_predicate_message) {
            return;
        }
        if (!(this.whenFalse instanceof NoAction) || result) {
            return;
        }
        if (context.equals("menu")) {
            new MessageAction(List.of(class_2561.method_43471((String)"\u00a7cYou can't open this menu")), false).execute(player);
        }
        if (context.equals("item")) {
            new MessageAction(List.of(class_2561.method_43471((String)"\u00a7cYou can't run this action")), false).execute(player);
        }
        player.method_7346();
    }
}

