/*
 * Decompiled with CFR 0.152.
 */
package infinityi.inventorymenu.placeholder.providers;

import infinityi.inventorymenu.placeholder.providers.PlaceholderProvider;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3442;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_3468;
import net.minecraft.class_7923;

public class PlayerProvider
implements PlaceholderProvider {
    public final class_3222 player;
    private final Map<String, Supplier<Object>> keySuppliers;

    public PlayerProvider(class_3222 player) {
        this.player = player;
        class_3218 world = player.method_51469();
        this.keySuppliers = Map.of("xp", () -> player.field_7520, "world_time", () -> this.getWorldHour(world), "name", () -> player.method_5477().getString(), "ping", () -> player.field_13987.method_52405(), "difficulty", () -> world.method_8407().method_15434(), "food_level", () -> player.method_7344().method_7586(), "world_name", () -> world.method_27983().method_29177().method_12832(), "max_health", () -> String.format("%.1f", Float.valueOf(player.method_6063())), "world_days", () -> String.valueOf(world.method_8510() / 24000L + 1L), "saturation", () -> String.format("%.1f", Float.valueOf(player.method_7344().method_7589())));
    }

    private static <T> class_3445<T> createStat(class_3448<T> type, Object value) {
        return type.method_14956(value);
    }

    @Override
    public Optional<String> getKey(String key, class_3222 player) {
        if (key.startsWith("stat.")) {
            return Optional.of(String.valueOf(this.getStatFromString(key)));
        }
        return Optional.ofNullable(this.keySuppliers.get(key)).map(Supplier::get).map(String::valueOf);
    }

    private String getWorldHour(class_3218 world) {
        long timeOfDay = world.method_8532();
        long gameTime = (timeOfDay + 6000L) % 24000L;
        int hours = (int)(gameTime / 1000L);
        int minutes = (int)((double)(gameTime % 1000L * 60L) / 1000.0);
        return String.format("%02d:%02d", hours, minutes);
    }

    public int getStatFromString(String statString) {
        Optional<class_3445> finalStatOpt;
        Object stringId;
        if (statString == null || !statString.startsWith("stat.")) {
            return 0;
        }
        String[] parts = statString.split("\\.", 3);
        if (parts.length < 3) {
            return 0;
        }
        String category = parts[1];
        String objectId = parts[2];
        class_3442 statHandler = this.player.method_14248();
        Optional statTypeOpt = class_7923.field_41193.method_17966(class_2960.method_60655((String)"minecraft", (String)category));
        if (statTypeOpt.isEmpty()) {
            return 0;
        }
        class_3448 statType = (class_3448)statTypeOpt.get();
        Object object = stringId = objectId.contains(":") ? objectId : "minecraft:" + objectId;
        if (statType == class_3468.field_15419) {
            class_2960 customStatId = class_2960.method_60654((String)stringId);
            finalStatOpt = class_7923.field_41183.method_17966(customStatId).map(arg_0 -> ((class_3448)class_3468.field_15419).method_14956(arg_0));
        } else {
            class_2960 objectIdentifier = class_2960.method_60654((String)stringId);
            class_2378 objectRegistry = statType.method_14959();
            finalStatOpt = Optional.ofNullable(objectRegistry.method_63535(objectIdentifier)).map(statObject -> PlayerProvider.createStat(statType, statObject));
        }
        return finalStatOpt.map(arg_0 -> ((class_3442)statHandler).method_15025(arg_0)).orElse(0);
    }
}

