/*
 * Decompiled with CFR 0.152.
 */
package infinityi.inventorymenu.util.teleportutil;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import infinityi.inventorymenu.action.type.TeleportAction;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_5699;

public record TeleportCost(List<Integer> amount, Integer saturation, Boolean isPoint) {
    public static final Codec<List<Integer>> AMOUNT = Codec.xor((Codec)Codec.INT, (Codec)Codec.list((Codec)Codec.INT, (int)2, (int)2)).xmap(either -> (List)either.map(l -> List.of(l, l), r -> r), Either::right);
    public static final Codec<TeleportCost> OBJ_COST = RecordCodecBuilder.create(inst -> inst.group((App)AMOUNT.fieldOf("amount").forGetter(TeleportCost::amount), (App)class_5699.field_33442.optionalFieldOf("saturation", (Object)1).forGetter(TeleportCost::saturation), (App)Codec.BOOL.optionalFieldOf("is_point", (Object)false).forGetter(TeleportCost::isPoint)).apply((Applicative)inst, TeleportCost::new));
    public static final Codec<TeleportCost> CODEC = Codec.xor((Codec)Codec.INT, OBJ_COST).xmap(either -> (TeleportCost)either.map(l -> new TeleportCost(List.of(l, l), 1, false), r -> r), Either::right).validate(tpCost -> {
        int min = tpCost.amount.getFirst();
        int max = tpCost.amount.getLast();
        if (min >= 0 && max >= 0 && min <= max) {
            return DataResult.success((Object)tpCost);
        }
        return DataResult.error(() -> "Invalid range for cost");
    });

    public static TeleportCost empty() {
        return new TeleportCost(List.of(Integer.valueOf(0), Integer.valueOf(0)), 1, false);
    }

    public boolean hasCost(class_3222 player, class_2338 pos) {
        if (this.amount.getFirst().equals(0)) {
            return true;
        }
        return player.field_7520 > this.calcCost(player, pos);
    }

    public void applyCost(class_3222 player, class_2338 pos) {
        int costInLevels = this.calcCost(player, pos);
        player.method_7316(-costInLevels);
    }

    public int calcCost(class_3222 player, class_2338 pos) {
        if (pos == null) {
            return 0;
        }
        if (Objects.equals(this.amount.getFirst(), this.amount.getLast())) {
            return this.amount.getFirst();
        }
        double distance = TeleportAction.distanceBetween(player.method_24515(), pos);
        if (distance == 0.0) {
            return 0;
        }
        return (int)((double)this.amount.getFirst().intValue() + (double)(this.amount.getLast() - this.amount.getFirst()) * (distance / (distance + (double)this.saturation.intValue())));
    }
}

