/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu.ride_casually.client;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.xiaoyu.ride_casually.ModKeyBindings;
import net.xiaoyu.ride_casually.RideConfig;
import net.xiaoyu.ride_casually.network.RidePacket;
import net.xiaoyu.ride_casually.util.RidePermissionUtil;
import net.xiaoyu.ride_casually.util.RideUtil;

@EventBusSubscriber(modid="ride_casually")
public class ClientEventHandler {
    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        Minecraft mc = Minecraft.getInstance();
        if (ModKeyBindings.RIDE_KEY.consumeClick() && mc.hitResult != null) {
            BlockHitResult blockHitResult;
            BlockPos pos;
            BlockState blockState;
            if (mc.hitResult.getType() == HitResult.Type.ENTITY) {
                EntityHitResult entityHitResult;
                Entity targetEntity;
                if (((Boolean)RideConfig.ALLOW_ENTITY_RIDING.get()).booleanValue() && RidePermissionUtil.isEntityRidingAllowed(targetEntity = (entityHitResult = (EntityHitResult)mc.hitResult).getEntity())) {
                    mc.level.playSound((Player)mc.player, targetEntity.getX(), targetEntity.getY(), targetEntity.getZ(), SoundEvents.HORSE_SADDLE, SoundSource.NEUTRAL, 3.0f, 1.0f);
                    PacketDistributor.sendToServer((CustomPacketPayload)new RidePacket(targetEntity.getId(), true, BlockPos.ZERO, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    RideUtil.addModRidingPlayer((Player)mc.player);
                }
            } else if (mc.hitResult.getType() == HitResult.Type.BLOCK && ((Boolean)RideConfig.ALLOW_BLOCK_RIDING.get()).booleanValue() && RidePermissionUtil.isBlockRidingAllowed(blockState = mc.level.getBlockState(pos = (blockHitResult = (BlockHitResult)mc.hitResult).getBlockPos()))) {
                PacketDistributor.sendToServer((CustomPacketPayload)new RidePacket(0, false, pos, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderTick(RenderLevelStageEvent event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && mc.player.isPassenger() && mc.options.keyShift.isDown()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new RidePacket(0, false, BlockPos.ZERO, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            RideUtil.removeModRidingPlayer((Player)mc.player);
        }
    }
}

