/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu.ride_casually.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public record BlockOffsetData(Optional<String> block_offsets, Optional<Map<String, String>> properties, Coordinates coordinates) {
    public static final Codec<BlockOffsetData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("block_offsets").forGetter(BlockOffsetData::block_offsets), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("properties").forGetter(BlockOffsetData::properties), (App)Coordinates.CODEC.fieldOf("coordinates").forGetter(BlockOffsetData::coordinates)).apply((Applicative)instance, BlockOffsetData::new));

    public boolean matches(BlockState state) {
        Block block = state.getBlock();
        boolean matches = true;
        if (this.block_offsets.isPresent()) {
            String blockOffset = this.block_offsets.get();
            if (blockOffset.startsWith("@")) {
                String modId = blockOffset.substring(1);
                ResourceLocation blockLocation = BuiltInRegistries.BLOCK.getKey((Object)block);
                matches = modId.equals(blockLocation.getNamespace());
            } else if (blockOffset.startsWith("#")) {
                String tagId = blockOffset.substring(1);
                ResourceLocation tagLocation = ResourceLocation.tryParse((String)tagId);
                TagKey tagKey = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)tagLocation);
                matches = block.builtInRegistryHolder().is(tagKey);
            } else {
                ResourceLocation blockLocation = BuiltInRegistries.BLOCK.getKey((Object)block);
                ResourceLocation targetLocation = ResourceLocation.tryParse((String)blockOffset);
                matches = blockLocation.equals((Object)targetLocation);
            }
            if (matches && this.properties.isPresent()) {
                Map<String, String> props = this.properties.get();
                StateDefinition stateDefinition = block.getStateDefinition();
                for (Map.Entry<String, String> entry : props.entrySet()) {
                    String propertyKey = entry.getKey();
                    String propertyValue = entry.getValue();
                    Property property = stateDefinition.getProperty(propertyKey);
                    if (property == null) continue;
                    matches = state.getValue(property).toString().equals(propertyValue);
                }
            }
        }
        return matches;
    }

    public record Coordinates(double offset_x, double offset_y, double offset_z) {
        public static final Codec<Coordinates> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("offset_x").forGetter(Coordinates::offset_x), (App)Codec.DOUBLE.fieldOf("offset_y").forGetter(Coordinates::offset_y), (App)Codec.DOUBLE.fieldOf("offset_z").forGetter(Coordinates::offset_z)).apply((Applicative)instance, Coordinates::new));
    }
}

