/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu.ride_casually.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.xiaoyu.ride_casually.util.BlockRideUtil;

public class BlockRideEntity
extends Entity {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"ride_casually");
    public static final DeferredHolder<EntityType<?>, EntityType<BlockRideEntity>> BLOCK_RIDE_ENTITY = ENTITY_TYPES.register("block_ride_entity", () -> EntityType.Builder.of(BlockRideEntity::new, (MobCategory)MobCategory.MISC).setTrackingRange(256).setUpdateInterval(20).sized(1.0E-4f, 1.0E-4f).build("block_ride_entity"));

    public BlockRideEntity(EntityType<BlockRideEntity> type, Level level) {
        super(type, level);
    }

    public BlockRideEntity(Level level, BlockPos pos) {
        super((EntityType)BLOCK_RIDE_ENTITY.get(), level);
        BlockRideUtil.Offset offset = BlockRideUtil.getOffset(level, pos);
        this.setPos((double)pos.getX() + offset.x, (double)pos.getY() + offset.y, (double)pos.getZ() + offset.z);
        this.noPhysics = true;
    }

    public static void register(IEventBus modEventBus) {
        ENTITY_TYPES.register(modEventBus);
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        Player player;
        Vec3 dismountLocation;
        if (passenger instanceof Player && (dismountLocation = BlockRideUtil.getDismountLocationForPassenger(player = (Player)passenger, this)) != null) {
            return dismountLocation;
        }
        return super.getDismountLocationForPassenger(passenger);
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        BlockRideUtil.removeBlockRideEntity(this);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return new ClientboundAddEntityPacket((Entity)this, serverEntity);
    }
}

