/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu.ride_casually.network;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.xiaoyu.ride_casually.RideConfig;
import net.xiaoyu.ride_casually.entity.BlockRideEntity;
import net.xiaoyu.ride_casually.event.BlockRideHandler;
import net.xiaoyu.ride_casually.network.RidePacket;
import net.xiaoyu.ride_casually.util.BlockRideUtil;
import net.xiaoyu.ride_casually.util.RidePermissionUtil;
import net.xiaoyu.ride_casually.util.RideUtil;

@EventBusSubscriber(modid="ride_casually")
public class NetworkHandler {
    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("ride_casually");
        registrar.playToServer(RidePacket.TYPE, RidePacket.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sender = (ServerPlayer)patt0$temp;
                if (payload.isBlockRide()) {
                    if (((Boolean)RideConfig.ALLOW_BLOCK_RIDING.get()).booleanValue()) {
                        BlockRideHandler.handleBlockRideRequest((Player)sender, payload.blockPos());
                    }
                } else if (((Boolean)RideConfig.ALLOW_ENTITY_RIDING.get()).booleanValue()) {
                    if (payload.startRiding()) {
                        Entity targetEntity = sender.level().getEntity(payload.entityId());
                        if (targetEntity != null && RidePermissionUtil.isEntityRidingAllowed(targetEntity)) {
                            RideUtil.addModRidingPlayer((Player)sender);
                            sender.startRiding(targetEntity);
                            RideUtil.syncWithPlayers(sender, targetEntity);
                        }
                    } else {
                        Entity vehicle = sender.getVehicle();
                        sender.stopRiding();
                        if (vehicle instanceof BlockRideEntity) {
                            vehicle.remove(Entity.RemovalReason.DISCARDED);
                            BlockRideUtil.removeBlockRideEntity((BlockRideEntity)vehicle);
                        }
                        RideUtil.removeModRidingPlayer((Player)sender);
                        RideUtil.syncWithPlayers(sender, vehicle);
                    }
                }
            }
        }));
    }
}

