/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu.ride_casually.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.state.BlockState;
import net.xiaoyu.ride_casually.RideCasually;
import net.xiaoyu.ride_casually.data.BlockOffsetData;
import net.xiaoyu.ride_casually.util.BlockRideUtil;

public class BlockOffsetUtil
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final BlockOffsetUtil INSTANCE = new BlockOffsetUtil();
    private final List<BlockOffsetData> blockOffsets = new ArrayList<BlockOffsetData>();
    private final List<BlockOffsetData> specificBlockOffsets = new ArrayList<BlockOffsetData>();
    private final Map<BlockState, BlockRideUtil.Offset> blockStateCache = new HashMap<BlockState, BlockRideUtil.Offset>();

    private BlockOffsetUtil() {
        super(GSON, "block_offsets");
    }

    public static BlockOffsetUtil getInstance() {
        return INSTANCE;
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.blockOffsets.clear();
        this.specificBlockOffsets.clear();
        this.blockStateCache.clear();
        RegistryOps registryOps = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY));
        ArrayList<BlockOffsetData> specificOffsets = new ArrayList<BlockOffsetData>();
        ArrayList<BlockOffsetData> defaultOffsets = new ArrayList<BlockOffsetData>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            try {
                BlockOffsetData data = (BlockOffsetData)BlockOffsetData.CODEC.parse((DynamicOps)registryOps, (Object)entry.getValue()).getOrThrow();
                if (data.block_offsets().isPresent()) {
                    specificOffsets.add(data);
                    continue;
                }
                defaultOffsets.add(data);
            }
            catch (Exception e) {
                RideCasually.LOGGER.error("Error loading block offset data: {}", (Object)e.getMessage());
            }
        }
        this.blockOffsets.addAll(specificOffsets);
        this.blockOffsets.addAll(defaultOffsets);
        this.specificBlockOffsets.addAll(specificOffsets);
    }

    public BlockRideUtil.Offset getOffsetForBlock(BlockState state) {
        BlockRideUtil.Offset cached = this.blockStateCache.get(state);
        if (cached != null) {
            return cached;
        }
        for (BlockOffsetData data : this.blockOffsets) {
            if (!data.matches(state)) continue;
            BlockRideUtil.Offset offset = new BlockRideUtil.Offset(data.coordinates().offset_x(), data.coordinates().offset_y(), data.coordinates().offset_z());
            this.blockStateCache.put(state, offset);
            return offset;
        }
        return null;
    }

    public BlockRideUtil.Offset getSpecificOffsetForBlock(BlockState state) {
        for (BlockOffsetData data : this.specificBlockOffsets) {
            if (!data.matches(state)) continue;
            return new BlockRideUtil.Offset(data.coordinates().offset_x(), data.coordinates().offset_y(), data.coordinates().offset_z());
        }
        return null;
    }
}

