/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu.ride_casually.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.xiaoyu.ride_casually.entity.BlockRideEntity;
import net.xiaoyu.ride_casually.util.BlockOffsetUtil;
import org.apache.commons.lang3.tuple.Pair;

public class BlockRideUtil {
    private static final Map<ResourceLocation, Map<BlockPos, Pair<BlockRideEntity, Vec3>>> OCCUPIED = new HashMap<ResourceLocation, Map<BlockPos, Pair<BlockRideEntity, Vec3>>>();

    public static Offset getOffset(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        VoxelShape shape = state.getShape((BlockGetter)level, pos);
        Offset specificOffset = BlockOffsetUtil.getInstance().getSpecificOffsetForBlock(state);
        if (specificOffset != null) {
            return specificOffset;
        }
        if (!shape.isEmpty()) {
            AABB bounds = shape.bounds();
            return new Offset(0.5, bounds.maxY, 0.5);
        }
        Offset defaultOffset = BlockOffsetUtil.getInstance().getOffsetForBlock(state);
        if (defaultOffset != null) {
            return defaultOffset;
        }
        return new Offset(0.5, 0.1, 0.5);
    }

    public static Vec3 getDismountLocationForPassenger(Player player, BlockRideEntity blockRideEntity) {
        Vec3 playerPos = player.position();
        return new Vec3(playerPos.x, playerPos.y + 1.0, playerPos.z);
    }

    public static boolean isPlayerInRange(Player player, BlockPos pos) {
        return true;
    }

    public static void handleBlockRideRequest(Player player, BlockPos pos) {
        Level level = player.level();
        if (!(level.isClientSide || BlockRideUtil.isPlayerSitting(player) && !(player.getVehicle() instanceof BlockRideEntity) || player.isShiftKeyDown() || !BlockRideUtil.isPlayerInRange(player, pos) || BlockRideUtil.isOccupied(level, pos) || !level.getBlockState(pos.above()).isAir())) {
            BlockRideEntity rideEntity;
            Entity entity = player.getVehicle();
            if (entity instanceof BlockRideEntity) {
                BlockRideEntity currentRideEntity = (BlockRideEntity)entity;
                player.stopRiding();
                currentRideEntity.ejectPassengers();
                currentRideEntity.remove(Entity.RemovalReason.DISCARDED);
            }
            if (BlockRideUtil.addBlockRideEntity(level, pos, rideEntity = new BlockRideEntity(level, pos), player.position())) {
                level.addFreshEntity((Entity)rideEntity);
                player.startRiding((Entity)rideEntity);
                level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.HORSE_SADDLE, SoundSource.NEUTRAL, 2.0f, 1.0f);
            }
        }
    }

    public static boolean addBlockRideEntity(Level level, BlockPos blockPos, BlockRideEntity entity, Vec3 playerPos) {
        if (!level.isClientSide) {
            ResourceLocation id = BlockRideUtil.getDimensionTypeId(level);
            if (!OCCUPIED.containsKey(id)) {
                OCCUPIED.put(id, new HashMap());
            }
            OCCUPIED.get(id).put(blockPos, (Pair<BlockRideEntity, Vec3>)Pair.of((Object)((Object)entity), (Object)playerPos));
            return true;
        }
        return false;
    }

    public static void removeBlockRideEntity(BlockRideEntity blockRideEntity) {
        BlockRideUtil.removeBlockRideEntity(blockRideEntity.level(), blockRideEntity.blockPosition());
    }

    public static boolean removeBlockRideEntity(Level level, BlockPos pos) {
        ResourceLocation id;
        if (!level.isClientSide && OCCUPIED.containsKey(id = BlockRideUtil.getDimensionTypeId(level))) {
            OCCUPIED.get(id).remove(pos);
            return true;
        }
        return false;
    }

    public static BlockRideEntity getBlockRideEntity(Level level, BlockPos pos) {
        ResourceLocation id;
        if (!level.isClientSide && OCCUPIED.containsKey(id = BlockRideUtil.getDimensionTypeId(level)) && OCCUPIED.get(id).containsKey(pos)) {
            return (BlockRideEntity)((Object)OCCUPIED.get(id).get(pos).getLeft());
        }
        return null;
    }

    public static boolean isOccupied(Level level, BlockPos pos) {
        ResourceLocation id = BlockRideUtil.getDimensionTypeId(level);
        if (OCCUPIED.containsKey(id) && OCCUPIED.get(id).containsKey(pos)) {
            BlockRideEntity entity = (BlockRideEntity)((Object)OCCUPIED.get(id).get(pos).getLeft());
            return entity != null && !entity.isRemoved();
        }
        return false;
    }

    public static boolean isPlayerSitting(Player player) {
        for (ResourceLocation i : OCCUPIED.keySet()) {
            for (Pair<BlockRideEntity, Vec3> pair : OCCUPIED.get(i).values()) {
                if (!((BlockRideEntity)((Object)pair.getLeft())).hasPassenger((Entity)player)) continue;
                return true;
            }
        }
        return false;
    }

    private static ResourceLocation getDimensionTypeId(Level level) {
        return level.dimension().location();
    }

    public static class Offset {
        public final double x;
        public final double y;
        public final double z;

        public Offset(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

