/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.blocks;

import com.mojang.serialization.MapCodec;
import net.Gabou.projectatmosphere.blocks.InstrumentBlock;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.Gabou.projectatmosphere.util.InstrumentUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WeatherVaneBlock
extends InstrumentBlock {
    public static final MapCodec<WeatherVaneBlock> CODEC = WeatherVaneBlock.simpleCodec(WeatherVaneBlock::new);

    public WeatherVaneBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends InstrumentBlock> codec() {
        return CODEC;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        if (!level.isClientSide) {
            level.scheduleTick(pos, (Block)this, 1);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BiomeInstanceKey key = new BiomeInstanceKey(AtmosphereUtils.getBiomeLocation(pos, (Level)level), pos);
        WindVector wind = ForecastOrchestrator.getCurrentWind(key, level.getGameTime());
        Direction dir = Direction.fromYRot((double)((float)Math.toDegrees(wind.angleRadians()))).getOpposite();
        if (dir != state.getValue((Property)FACING)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)FACING, (Comparable)dir), 2);
        }
        level.scheduleTick(pos, (Block)this, 20);
    }

    @Override
    public void display(Level level, Player player) {
        InstrumentUtils.displayWind(level, player);
    }
}

