/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.client.sound;

import net.Gabou.projectatmosphere.modules.tornado.TornadoInstance;
import net.Gabou.projectatmosphere.registry.ModSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TornadoRoarLoop
extends AbstractTickableSoundInstance {
    private final TornadoInstance tornado;
    private final float maxHearDistance;
    private float baseVolume;

    public TornadoRoarLoop(TornadoInstance tornado, float baseVolume, float maxHearDistance) {
        super((SoundEvent)ModSounds.TORNADO_ROAR.get(), SoundSource.WEATHER, Minecraft.getInstance().level.getRandom());
        this.tornado = tornado;
        this.baseVolume = baseVolume;
        this.maxHearDistance = maxHearDistance;
        this.looping = true;
        this.x = (float)tornado.position.x;
        this.y = (float)tornado.position.y;
        this.z = (float)tornado.position.z;
        this.volume = 0.0f;
        this.pitch = 1.0f;
    }

    public void tick() {
        if (this.tornado == null) {
            this.stop();
            return;
        }
        this.x = (float)this.tornado.position.x;
        this.y = (float)this.tornado.position.y;
        this.z = (float)this.tornado.position.z;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        double d = mc.player.position().distanceTo(this.tornado.position);
        float fade = Mth.clamp((float)(1.0f - (float)(d / (double)this.maxHearDistance)), (float)0.0f, (float)1.0f);
        this.volume = this.baseVolume * fade;
        this.pitch = 0.99f + 0.02f * Mth.sin((float)((float)(mc.level.getGameTime() % 100000L) * 0.025f));
    }

    public void setBaseVolume(float v) {
        this.baseVolume = Mth.clamp((float)v, (float)0.0f, (float)1.0f);
    }

    public void stopSound() {
        this.stop();
    }
}

