/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.config;

import com.Gabou.sereneseasonsplus.util.IScreen;
import java.util.ArrayList;
import java.util.List;
import net.Gabou.projectatmosphere.config.AtmoCommonConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class AtmoConfigScreen
extends Screen {
    private final Screen parent;
    private boolean forceSharedExecutor;
    private boolean displayUnitsImperial;
    private boolean enableTornadoes;
    private boolean enableStormDebris;
    private int maxStormDebrisPerChunk;
    private boolean autoRepairGlass;
    private boolean damageGlassOnTornado;
    private double tornadoCheckIntervalSec;
    private double tornadoBaseSpawnRadiusM;
    private double tornadoMinTempContrastC;
    private double tornadoHumidityMinPercent;
    private double tornadoPressureGradientGain;
    private double tornadoPressureGradientCap;
    private double tornadoShearMinSpeedDiffMps;
    private double tornadoShearMinDirDiffDeg;
    private double tornadoStormMultiplier;
    private double tornadoRiskMinToConsider;
    private double tornadoBaseTriggerChance;
    private double tornadoLapseRateCPer100m;
    private double tornadoAloftDeltaHM;
    private double tornadoIntensityMin;
    private double tornadoIntensityMax;
    private int tornadoCellCooldownMinutes;
    private double windBaseRetargetSec;
    private double windDirRetargetSec;
    private double windGustMeanSec;
    private double windGustDecayMps;
    private double windStormGustMult;
    private double windPushThresholdMps;
    private double windPlayerPushScale;
    private double windEntityPushScale;
    private double stormBoostMultiplier;
    private EditBox maxDebrisBox;
    private int cloudRenderDistance;
    private EditBox cloudDistanceBox;
    private EditBox tornadoCheckIntervalBox;
    private EditBox tornadoBaseSpawnRadiusBox;
    private EditBox tornadoMinTempContrastBox;
    private EditBox tornadoHumidityMinBox;
    private EditBox tornadoPressureGradientGainBox;
    private EditBox tornadoPressureGradientCapBox;
    private EditBox tornadoShearMinSpeedDiffBox;
    private EditBox tornadoShearMinDirDiffBox;
    private EditBox tornadoStormMultiplierBox;
    private EditBox tornadoRiskMinBox;
    private EditBox tornadoBaseTriggerChanceBox;
    private EditBox tornadoLapseRateBox;
    private EditBox tornadoAloftDeltaBox;
    private EditBox tornadoIntensityMinBox;
    private EditBox tornadoIntensityMaxBox;
    private EditBox tornadoCellCooldownBox;
    private EditBox windBaseRetargetBox;
    private EditBox windDirRetargetBox;
    private EditBox windGustMeanBox;
    private EditBox windGustDecayBox;
    private EditBox windStormGustMultBox;
    private EditBox windPushThresholdBox;
    private EditBox windPlayerPushScaleBox;
    private EditBox windEntityPushScaleBox;
    private EditBox stormBoostMultiplierBox;
    private final List<AbstractWidget> configWidgets = new ArrayList<AbstractWidget>();
    private final List<Integer> widgetBaseY = new ArrayList<Integer>();
    private final List<Title> titles = new ArrayList<Title>();
    private final List<Label> labels = new ArrayList<Label>();
    private int scrollOffset;
    private int maxScroll;

    public AtmoConfigScreen(Screen parent) {
        super((Component)Component.literal((String)"Project Atmosphere Config"));
        this.parent = parent;
    }

    protected void init() {
        this.configWidgets.clear();
        this.widgetBaseY.clear();
        this.titles.clear();
        this.labels.clear();
        this.displayUnitsImperial = (Boolean)AtmoCommonConfig.DISPLAY_UNITS_IMPERIAL.get();
        this.stormBoostMultiplier = (Double)AtmoCommonConfig.STORM_SEVERITY_BOOSTER.get();
        this.forceSharedExecutor = (Boolean)AtmoCommonConfig.FORCE_SHARED_EXECUTOR.get();
        this.enableTornadoes = (Boolean)AtmoCommonConfig.ENABLE_TORNADOES.get();
        this.enableStormDebris = (Boolean)AtmoCommonConfig.ENABLE_STORM_DEBRIS.get();
        this.maxStormDebrisPerChunk = (Integer)AtmoCommonConfig.MAX_STORM_DEBRIS_PER_CHUNK.get();
        this.autoRepairGlass = (Boolean)AtmoCommonConfig.AUTO_REPAIR_GLASS.get();
        this.damageGlassOnTornado = (Boolean)AtmoCommonConfig.DAMAGE_GLASS_ON_TORNADO.get();
        this.cloudRenderDistance = (Integer)AtmoCommonConfig.CLOUD_RENDER_DISTANCE.get();
        this.tornadoCheckIntervalSec = (Double)AtmoCommonConfig.TORNADO_CHECK_INTERVAL_SEC.get();
        this.tornadoBaseSpawnRadiusM = (Double)AtmoCommonConfig.TORNADO_BASE_SPAWN_RADIUS_M.get();
        this.tornadoMinTempContrastC = (Double)AtmoCommonConfig.TORNADO_MIN_TEMP_CONTRAST_C.get();
        this.tornadoHumidityMinPercent = (Double)AtmoCommonConfig.TORNADO_HUMIDITY_MIN_PERCENT.get();
        this.tornadoPressureGradientGain = (Double)AtmoCommonConfig.TORNADO_PRESSURE_GRADIENT_GAIN.get();
        this.tornadoPressureGradientCap = (Double)AtmoCommonConfig.TORNADO_PRESSURE_GRADIENT_CAP.get();
        this.tornadoShearMinSpeedDiffMps = (Double)AtmoCommonConfig.TORNADO_SHEAR_MIN_SPEED_DIFF_MPS.get();
        this.tornadoShearMinDirDiffDeg = (Double)AtmoCommonConfig.TORNADO_SHEAR_MIN_DIR_DIFF_DEG.get();
        this.tornadoStormMultiplier = (Double)AtmoCommonConfig.TORNADO_STORM_MULTIPLIER.get();
        this.tornadoRiskMinToConsider = (Double)AtmoCommonConfig.TORNADO_RISK_MIN_TO_CONSIDER.get();
        this.tornadoBaseTriggerChance = (Double)AtmoCommonConfig.TORNADO_BASE_TRIGGER_CHANCE.get();
        this.tornadoLapseRateCPer100m = (Double)AtmoCommonConfig.TORNADO_LAPSE_RATE_C_PER_100M.get();
        this.tornadoAloftDeltaHM = (Double)AtmoCommonConfig.TORNADO_ALOFT_DELTA_H_M.get();
        this.tornadoIntensityMin = (Double)AtmoCommonConfig.TORNADO_INTENSITY_MIN.get();
        this.tornadoIntensityMax = (Double)AtmoCommonConfig.TORNADO_INTENSITY_MAX.get();
        this.tornadoCellCooldownMinutes = (Integer)AtmoCommonConfig.TORNADO_CELL_COOLDOWN_MINUTES.get();
        this.windBaseRetargetSec = (Double)AtmoCommonConfig.WIND_BASE_RETARGET_SEC.get();
        this.windDirRetargetSec = (Double)AtmoCommonConfig.WIND_DIR_RETARGET_SEC.get();
        this.windGustMeanSec = (Double)AtmoCommonConfig.WIND_GUST_MEAN_SEC.get();
        this.windGustDecayMps = (Double)AtmoCommonConfig.WIND_GUST_DECAY_MPS.get();
        this.windStormGustMult = (Double)AtmoCommonConfig.WIND_STORM_GUST_MULT.get();
        this.windPushThresholdMps = (Double)AtmoCommonConfig.WIND_PUSH_THRESHOLD_MPS.get();
        this.windPlayerPushScale = (Double)AtmoCommonConfig.WIND_PLAYER_PUSH_SCALE.get();
        this.windEntityPushScale = (Double)AtmoCommonConfig.WIND_ENTITY_PUSH_SCALE.get();
        int center = this.width / 2;
        int y = 40;
        this.addTitle("Performance", y);
        this.addConfigWidget((AbstractWidget)Button.builder((Component)this.toggleLabel("Force Shared Executor", this.forceSharedExecutor), b -> {
            this.forceSharedExecutor = !this.forceSharedExecutor;
            b.setMessage(this.toggleLabel("Force Shared Executor", this.forceSharedExecutor));
        }).bounds(center - 100, y += 18, 200, 20).build(), y);
        this.addTitle("Display", y += 32);
        this.addConfigWidget((AbstractWidget)Button.builder((Component)this.toggleLabel("Imperial Units", this.displayUnitsImperial), b -> {
            this.displayUnitsImperial = !this.displayUnitsImperial;
            b.setMessage(this.toggleLabel("Imperial Units", this.displayUnitsImperial));
        }).bounds(center - 100, y += 18, 200, 20).build(), y);
        this.addTitle("Storms", y += 32);
        this.addConfigWidget((AbstractWidget)Button.builder((Component)this.toggleLabel("Tornadoes", this.enableTornadoes), b -> {
            this.enableTornadoes = !this.enableTornadoes;
            b.setMessage(this.toggleLabel("Tornadoes", this.enableTornadoes));
        }).bounds(center - 100, y += 18, 200, 20).build(), y);
        this.addConfigWidget((AbstractWidget)Button.builder((Component)this.toggleLabel("Storm Debris", this.enableStormDebris), b -> {
            this.enableStormDebris = !this.enableStormDebris;
            b.setMessage(this.toggleLabel("Storm Debris", this.enableStormDebris));
        }).bounds(center - 100, y += 32, 200, 20).build(), y);
        this.cloudDistanceBox = new EditBox(this.font, center - 100, y += 32, 200, 20, (Component)Component.literal((String)"Cloud Render Distance"));
        this.cloudDistanceBox.setValue(Integer.toString(this.cloudRenderDistance));
        this.addRenderableWidget((GuiEventListener)this.cloudDistanceBox);
        this.stormBoostMultiplierBox = this.addNumberField(center, y += 32, "Storm Severity Booster", Double.toString(this.stormBoostMultiplier));
        this.maxDebrisBox = this.addNumberField(center, y += 34, "Max Storm Debris Per Chunk", Integer.toString(this.maxStormDebrisPerChunk));
        this.addConfigWidget((AbstractWidget)Button.builder((Component)this.toggleLabel("Auto Repair Glass", this.autoRepairGlass), b -> {
            this.autoRepairGlass = !this.autoRepairGlass;
            b.setMessage(this.toggleLabel("Auto Repair Glass", this.autoRepairGlass));
        }).bounds(center - 100, y += 34, 200, 20).build(), y);
        this.addConfigWidget((AbstractWidget)Button.builder((Component)this.toggleLabel("Damage Glass On Tornado", this.damageGlassOnTornado), b -> {
            this.damageGlassOnTornado = !this.damageGlassOnTornado;
            b.setMessage(this.toggleLabel("Damage Glass On Tornado", this.damageGlassOnTornado));
        }).bounds(center - 100, y += 32, 200, 20).build(), y);
        this.addTitle("Tornado", y += 32);
        this.tornadoCheckIntervalBox = this.addNumberField(center, y += 18, "Check Interval Sec", Double.toString(this.tornadoCheckIntervalSec));
        this.tornadoBaseSpawnRadiusBox = this.addNumberField(center, y += 34, "Base Spawn Radius M", Double.toString(this.tornadoBaseSpawnRadiusM));
        this.tornadoMinTempContrastBox = this.addNumberField(center, y += 34, "Min Temp Contrast C", Double.toString(this.tornadoMinTempContrastC));
        this.tornadoHumidityMinBox = this.addNumberField(center, y += 34, "Humidity Min Percent", Double.toString(this.tornadoHumidityMinPercent));
        this.tornadoPressureGradientGainBox = this.addNumberField(center, y += 34, "Pressure Gradient Gain", Double.toString(this.tornadoPressureGradientGain));
        this.tornadoPressureGradientCapBox = this.addNumberField(center, y += 34, "Pressure Gradient Cap", Double.toString(this.tornadoPressureGradientCap));
        this.tornadoShearMinSpeedDiffBox = this.addNumberField(center, y += 34, "Shear Min Speed Diff Mps", Double.toString(this.tornadoShearMinSpeedDiffMps));
        this.tornadoShearMinDirDiffBox = this.addNumberField(center, y += 34, "Shear Min Dir Diff Deg", Double.toString(this.tornadoShearMinDirDiffDeg));
        this.tornadoStormMultiplierBox = this.addNumberField(center, y += 34, "Storm Multiplier", Double.toString(this.tornadoStormMultiplier));
        this.tornadoRiskMinBox = this.addNumberField(center, y += 34, "Risk Min To Consider", Double.toString(this.tornadoRiskMinToConsider));
        this.tornadoBaseTriggerChanceBox = this.addNumberField(center, y += 34, "Base Trigger Chance", Double.toString(this.tornadoBaseTriggerChance));
        this.tornadoLapseRateBox = this.addNumberField(center, y += 34, "Lapse Rate C Per 100m", Double.toString(this.tornadoLapseRateCPer100m));
        this.tornadoAloftDeltaBox = this.addNumberField(center, y += 34, "Aloft Delta H M", Double.toString(this.tornadoAloftDeltaHM));
        this.tornadoIntensityMinBox = this.addNumberField(center, y += 34, "Intensity Min", Double.toString(this.tornadoIntensityMin));
        this.tornadoIntensityMaxBox = this.addNumberField(center, y += 34, "Intensity Max", Double.toString(this.tornadoIntensityMax));
        this.tornadoCellCooldownBox = this.addNumberField(center, y += 34, "Cell Cooldown Minutes", Integer.toString(this.tornadoCellCooldownMinutes));
        this.addTitle("Wind", y += 34);
        this.windBaseRetargetBox = this.addNumberField(center, y += 18, "Base Retarget Sec", Double.toString(this.windBaseRetargetSec));
        this.windDirRetargetBox = this.addNumberField(center, y += 34, "Dir Retarget Sec", Double.toString(this.windDirRetargetSec));
        this.windGustMeanBox = this.addNumberField(center, y += 34, "Gust Mean Sec", Double.toString(this.windGustMeanSec));
        this.windGustDecayBox = this.addNumberField(center, y += 34, "Gust Decay Mps", Double.toString(this.windGustDecayMps));
        this.windStormGustMultBox = this.addNumberField(center, y += 34, "Storm Gust Mult", Double.toString(this.windStormGustMult));
        this.windPushThresholdBox = this.addNumberField(center, y += 34, "Push Threshold Mps", Double.toString(this.windPushThresholdMps));
        this.windPlayerPushScaleBox = this.addNumberField(center, y += 34, "Player Push Scale", Double.toString(this.windPlayerPushScale));
        this.windEntityPushScaleBox = this.addNumberField(center, y += 34, "Entity Push Scale", Double.toString(this.windEntityPushScale));
        int contentTop = 40;
        int contentBottom = this.height - 50;
        int viewportHeight = Math.max(0, contentBottom - contentTop);
        this.maxScroll = Math.max(0, (y += 34) - contentTop - viewportHeight);
        this.scrollOffset = 0;
        this.updateWidgetPositions();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.done"), b -> {
            this.saveChanges();
            Minecraft.getInstance().setScreen(this.parent);
        }).bounds(center - 100, this.height - 27, 200, 20).build());
    }

    private void addConfigWidget(AbstractWidget widget, int baseY) {
        this.configWidgets.add(widget);
        this.widgetBaseY.add(baseY);
        this.addRenderableWidget((GuiEventListener)widget);
    }

    private EditBox addNumberField(int center, int y, String label, String value) {
        EditBox box = new EditBox(this.font, center - 100, y, 200, 20, (Component)Component.literal((String)label));
        box.setValue(value);
        this.addConfigWidget((AbstractWidget)box, y);
        this.labels.add(new Label(label, center - 100, y - 10));
        return box;
    }

    private void addTitle(String text, int y) {
        this.titles.add(new Title(text, y));
    }

    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        int panelW = 240;
        int panelX = (this.width - panelW) / 2;
        int contentTop = 40;
        int headerTop = 30;
        int contentBottom = this.height - 50;
        int panelBottom = this.height - 20;
        g.fill(panelX - 4, headerTop - 4, panelX + panelW + 4, panelBottom, -1442840576);
        g.drawString(this.font, "Project Atmosphere Config", panelX + 6, headerTop - 14, 0xFFFFFF, false);
        g.enableScissor(panelX - 4, contentTop - 4, panelX + panelW + 4, contentBottom);
        for (Title t : this.titles) {
            g.drawString(this.font, t.text, panelX + 6, t.y - this.scrollOffset, 0xFFFFFF, false);
        }
        for (Label l : this.labels) {
            g.drawString(this.font, l.text, l.x, l.y - this.scrollOffset, 0xFFFFFF, false);
        }
        g.disableScissor();
        ((IScreen)this).sereneseasonsplus$renderNoBackground(g, mouseX, mouseY, partialTick);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.maxScroll > 0 && scrollY != 0.0) {
            this.scrollOffset = Mth.clamp((int)(this.scrollOffset - (int)(scrollY * 20.0)), (int)0, (int)this.maxScroll);
            this.updateWidgetPositions();
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    private void updateWidgetPositions() {
        int contentTop = 40;
        int contentBottom = this.height - 50;
        for (int i = 0; i < this.configWidgets.size(); ++i) {
            boolean inView;
            AbstractWidget w = this.configWidgets.get(i);
            int y = this.widgetBaseY.get(i) - this.scrollOffset;
            w.setY(y);
            w.visible = inView = y >= contentTop && y + w.getHeight() <= contentBottom;
            w.active = inView;
        }
    }

    private Component toggleLabel(String name, boolean enabled) {
        return Component.literal((String)(name + ": " + (enabled ? "ON" : "OFF")));
    }

    private int parseInt(EditBox box, int fallback) {
        try {
            return Integer.parseInt(box.getValue());
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    private double parseDouble(EditBox box, double fallback) {
        try {
            return Double.parseDouble(box.getValue());
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    private void saveChanges() {
        this.maxStormDebrisPerChunk = this.parseInt(this.maxDebrisBox, this.maxStormDebrisPerChunk);
        this.cloudRenderDistance = this.parseInt(this.cloudDistanceBox, this.cloudRenderDistance);
        this.stormBoostMultiplier = this.parseDouble(this.stormBoostMultiplierBox, this.stormBoostMultiplier);
        this.tornadoCheckIntervalSec = this.parseDouble(this.tornadoCheckIntervalBox, this.tornadoCheckIntervalSec);
        this.tornadoBaseSpawnRadiusM = this.parseDouble(this.tornadoBaseSpawnRadiusBox, this.tornadoBaseSpawnRadiusM);
        this.tornadoMinTempContrastC = this.parseDouble(this.tornadoMinTempContrastBox, this.tornadoMinTempContrastC);
        this.tornadoHumidityMinPercent = this.parseDouble(this.tornadoHumidityMinBox, this.tornadoHumidityMinPercent);
        this.tornadoPressureGradientGain = this.parseDouble(this.tornadoPressureGradientGainBox, this.tornadoPressureGradientGain);
        this.tornadoPressureGradientCap = this.parseDouble(this.tornadoPressureGradientCapBox, this.tornadoPressureGradientCap);
        this.tornadoShearMinSpeedDiffMps = this.parseDouble(this.tornadoShearMinSpeedDiffBox, this.tornadoShearMinSpeedDiffMps);
        this.tornadoShearMinDirDiffDeg = this.parseDouble(this.tornadoShearMinDirDiffBox, this.tornadoShearMinDirDiffDeg);
        this.tornadoStormMultiplier = this.parseDouble(this.tornadoStormMultiplierBox, this.tornadoStormMultiplier);
        this.tornadoRiskMinToConsider = this.parseDouble(this.tornadoRiskMinBox, this.tornadoRiskMinToConsider);
        this.tornadoBaseTriggerChance = this.parseDouble(this.tornadoBaseTriggerChanceBox, this.tornadoBaseTriggerChance);
        this.tornadoLapseRateCPer100m = this.parseDouble(this.tornadoLapseRateBox, this.tornadoLapseRateCPer100m);
        this.tornadoAloftDeltaHM = this.parseDouble(this.tornadoAloftDeltaBox, this.tornadoAloftDeltaHM);
        this.tornadoIntensityMin = this.parseDouble(this.tornadoIntensityMinBox, this.tornadoIntensityMin);
        this.tornadoIntensityMax = this.parseDouble(this.tornadoIntensityMaxBox, this.tornadoIntensityMax);
        this.tornadoCellCooldownMinutes = this.parseInt(this.tornadoCellCooldownBox, this.tornadoCellCooldownMinutes);
        this.windBaseRetargetSec = this.parseDouble(this.windBaseRetargetBox, this.windBaseRetargetSec);
        this.windDirRetargetSec = this.parseDouble(this.windDirRetargetBox, this.windDirRetargetSec);
        this.windGustMeanSec = this.parseDouble(this.windGustMeanBox, this.windGustMeanSec);
        this.windGustDecayMps = this.parseDouble(this.windGustDecayBox, this.windGustDecayMps);
        this.windStormGustMult = this.parseDouble(this.windStormGustMultBox, this.windStormGustMult);
        this.windPushThresholdMps = this.parseDouble(this.windPushThresholdBox, this.windPushThresholdMps);
        this.windPlayerPushScale = this.parseDouble(this.windPlayerPushScaleBox, this.windPlayerPushScale);
        this.windEntityPushScale = this.parseDouble(this.windEntityPushScaleBox, this.windEntityPushScale);
        AtmoCommonConfig.FORCE_SHARED_EXECUTOR.set((Object)this.forceSharedExecutor);
        AtmoCommonConfig.DISPLAY_UNITS_IMPERIAL.set((Object)this.displayUnitsImperial);
        AtmoCommonConfig.ENABLE_TORNADOES.set((Object)this.enableTornadoes);
        AtmoCommonConfig.ENABLE_STORM_DEBRIS.set((Object)this.enableStormDebris);
        AtmoCommonConfig.MAX_STORM_DEBRIS_PER_CHUNK.set((Object)this.maxStormDebrisPerChunk);
        AtmoCommonConfig.CLOUD_RENDER_DISTANCE.set((Object)this.cloudRenderDistance);
        AtmoCommonConfig.AUTO_REPAIR_GLASS.set((Object)this.autoRepairGlass);
        AtmoCommonConfig.DAMAGE_GLASS_ON_TORNADO.set((Object)this.damageGlassOnTornado);
        AtmoCommonConfig.TORNADO_CHECK_INTERVAL_SEC.set((Object)this.tornadoCheckIntervalSec);
        AtmoCommonConfig.TORNADO_BASE_SPAWN_RADIUS_M.set((Object)this.tornadoBaseSpawnRadiusM);
        AtmoCommonConfig.TORNADO_MIN_TEMP_CONTRAST_C.set((Object)this.tornadoMinTempContrastC);
        AtmoCommonConfig.TORNADO_HUMIDITY_MIN_PERCENT.set((Object)this.tornadoHumidityMinPercent);
        AtmoCommonConfig.TORNADO_PRESSURE_GRADIENT_GAIN.set((Object)this.tornadoPressureGradientGain);
        AtmoCommonConfig.TORNADO_PRESSURE_GRADIENT_CAP.set((Object)this.tornadoPressureGradientCap);
        AtmoCommonConfig.TORNADO_SHEAR_MIN_SPEED_DIFF_MPS.set((Object)this.tornadoShearMinSpeedDiffMps);
        AtmoCommonConfig.TORNADO_SHEAR_MIN_DIR_DIFF_DEG.set((Object)this.tornadoShearMinDirDiffDeg);
        AtmoCommonConfig.TORNADO_STORM_MULTIPLIER.set((Object)this.tornadoStormMultiplier);
        AtmoCommonConfig.TORNADO_RISK_MIN_TO_CONSIDER.set((Object)this.tornadoRiskMinToConsider);
        AtmoCommonConfig.TORNADO_BASE_TRIGGER_CHANCE.set((Object)this.tornadoBaseTriggerChance);
        AtmoCommonConfig.TORNADO_LAPSE_RATE_C_PER_100M.set((Object)this.tornadoLapseRateCPer100m);
        AtmoCommonConfig.TORNADO_ALOFT_DELTA_H_M.set((Object)this.tornadoAloftDeltaHM);
        AtmoCommonConfig.TORNADO_INTENSITY_MIN.set((Object)this.tornadoIntensityMin);
        AtmoCommonConfig.TORNADO_INTENSITY_MAX.set((Object)this.tornadoIntensityMax);
        AtmoCommonConfig.TORNADO_CELL_COOLDOWN_MINUTES.set((Object)this.tornadoCellCooldownMinutes);
        AtmoCommonConfig.WIND_BASE_RETARGET_SEC.set((Object)this.windBaseRetargetSec);
        AtmoCommonConfig.WIND_DIR_RETARGET_SEC.set((Object)this.windDirRetargetSec);
        AtmoCommonConfig.WIND_GUST_MEAN_SEC.set((Object)this.windGustMeanSec);
        AtmoCommonConfig.WIND_GUST_DECAY_MPS.set((Object)this.windGustDecayMps);
        AtmoCommonConfig.WIND_STORM_GUST_MULT.set((Object)this.windStormGustMult);
        AtmoCommonConfig.WIND_PUSH_THRESHOLD_MPS.set((Object)this.windPushThresholdMps);
        AtmoCommonConfig.WIND_PLAYER_PUSH_SCALE.set((Object)this.windPlayerPushScale);
        AtmoCommonConfig.WIND_ENTITY_PUSH_SCALE.set((Object)this.windEntityPushScale);
        AtmoCommonConfig.STORM_SEVERITY_BOOSTER.set((Object)this.stormBoostMultiplier);
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.parent);
    }

    private static class Label {
        final String text;
        final int x;
        final int y;

        Label(String text, int x, int y) {
            this.text = text;
            this.x = x;
            this.y = y;
        }
    }

    private static class Title {
        final String text;
        final int y;

        Title(String text, int y) {
            this.text = text;
            this.y = y;
        }
    }
}

