/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.tornado;

import dev.nonamecrackers2.simpleclouds.common.cloud.region.CloudRegion;
import dev.nonamecrackers2.simpleclouds.common.cloud.spawning.ServerCloudGenerator;
import dev.nonamecrackers2.simpleclouds.common.world.CloudManager;
import dev.nonamecrackers2.simpleclouds.common.world.ServerCloudManager;
import net.Gabou.projectatmosphere.api.ForecastSampling;
import net.Gabou.projectatmosphere.api.WindVectorApi;
import net.Gabou.projectatmosphere.config.AtmoCommonConfig;
import net.Gabou.projectatmosphere.data.TornadoStorageManager;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.modules.core.CloudLibrary;
import net.Gabou.projectatmosphere.modules.tornado.TornadoSpawnScheduler;
import net.Gabou.projectatmosphere.modules.tornado.TornadoSpawner;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public final class TornadoProbabilityManager {
    private TornadoProbabilityManager() {
    }

    public static void init() {
    }

    public static void onScheduledCheck(ServerLevel level) {
        if (!((Boolean)AtmoCommonConfig.ENABLE_TORNADOES.get()).booleanValue()) {
            return;
        }
        long now = level.getGameTime();
        if (!TornadoSpawnScheduler.isSlotAvailable(now)) {
            return;
        }
        for (BiomeInstanceKey key : ForecastOrchestrator.getActiveBiomeKeys(level)) {
            float riskMin;
            float risk;
            if (!TornadoProbabilityManager.isStormy(key, level) || TornadoProbabilityManager.isCellOnCooldown(key, level, now) || (risk = TornadoProbabilityManager.computeRisk(key, level, now)) < (riskMin = ((Double)AtmoCommonConfig.TORNADO_RISK_MIN_TO_CONSIDER.get()).floatValue())) continue;
            float chance = ((Double)AtmoCommonConfig.TORNADO_BASE_TRIGGER_CHANCE.get()).floatValue() * risk;
            if (!(level.random.nextFloat() < chance)) continue;
            float intensity = TornadoProbabilityManager.map(risk, riskMin, riskMin + 4.0f, ((Double)AtmoCommonConfig.TORNADO_INTENSITY_MIN.get()).floatValue(), ((Double)AtmoCommonConfig.TORNADO_INTENSITY_MAX.get()).floatValue());
            TornadoSpawner.spawn(key, level, TornadoProbabilityManager.clamp01(intensity));
            TornadoStorageManager.setCooldown(key, now + TornadoProbabilityManager.minutesToTicks(((Integer)AtmoCommonConfig.TORNADO_CELL_COOLDOWN_MINUTES.get()).intValue()));
            TornadoSpawnScheduler.recordSpawn(now);
            break;
        }
    }

    public static float computeRisk(BiomeInstanceKey key, ServerLevel level, long nowTick) {
        float risk = 0.0f;
        float tempSurface = ForecastSampling.getTemperatureC(key, level);
        float humidity = ForecastSampling.getHumidityPercent(key, level);
        float tempAloft = tempSurface - ((Double)AtmoCommonConfig.TORNADO_LAPSE_RATE_C_PER_100M.get()).floatValue() * (((Double)AtmoCommonConfig.TORNADO_ALOFT_DELTA_H_M.get()).floatValue() / 100.0f);
        float tempContrast = Math.max(0.0f, tempSurface - tempAloft);
        risk += tempContrast / 10.0f;
        if (humidity >= ((Double)AtmoCommonConfig.TORNADO_HUMIDITY_MIN_PERCENT.get()).floatValue()) {
            risk += 1.0f;
        }
        float pHere = ForecastSampling.getPressureHpa(key, level);
        float pNear = ForecastSampling.minNeighborPressureHpa(key, level);
        float pDiff = Math.abs(pHere - pNear) * ((Double)AtmoCommonConfig.TORNADO_PRESSURE_GRADIENT_GAIN.get()).floatValue();
        risk += Math.min(pDiff, ((Double)AtmoCommonConfig.TORNADO_PRESSURE_GRADIENT_CAP.get()).floatValue());
        WindVectorApi.WindSample wSurf = WindVectorApi.getOrFallback(key);
        WindVectorApi.WindSample wAloft = WindVectorApi.getAloftProxy(key, level);
        float speedDiff = Math.abs(wSurf.speedMps() - wAloft.speedMps());
        float dirDiff = TornadoProbabilityManager.minimalAngleDiffDeg(wSurf.directionDeg(), wAloft.directionDeg());
        if (speedDiff >= ((Double)AtmoCommonConfig.TORNADO_SHEAR_MIN_SPEED_DIFF_MPS.get()).floatValue() && dirDiff >= ((Double)AtmoCommonConfig.TORNADO_SHEAR_MIN_DIR_DIFF_DEG.get()).floatValue()) {
            risk += 2.0f;
        }
        if (TornadoProbabilityManager.isStormy(key, level)) {
            risk *= ((Double)AtmoCommonConfig.TORNADO_STORM_MULTIPLIER.get()).floatValue();
        }
        return risk;
    }

    public static boolean isCellOnCooldown(BiomeInstanceKey key, ServerLevel level, long nowTick) {
        return TornadoStorageManager.isOnCooldown(key, nowTick);
    }

    private static boolean isStormy(BiomeInstanceKey key, ServerLevel level) {
        ServerCloudManager manager = (ServerCloudManager)CloudManager.get((Level)level);
        ServerCloudGenerator generator = manager.getCloudGenerator();
        BlockPos pos = key.samplePos();
        for (CloudRegion region : generator.getClouds()) {
            double r;
            double dz;
            double dx;
            int severity = CloudLibrary.getSeverityFromRessourceLocation(region.getCloudTypeId());
            if (severity < 7 || !((dx = (double)(region.getWorldX() - (float)pos.getX())) * dx + (dz = (double)(region.getWorldZ() - (float)pos.getZ())) * dz <= (r = (double)region.getRadius()) * r)) continue;
            return true;
        }
        return false;
    }

    private static float minimalAngleDiffDeg(float a, float b) {
        float d = Math.abs((a - b + 540.0f) % 360.0f - 180.0f);
        return d;
    }

    private static long minutesToTicks(float m) {
        return (long)(m * 20.0f * 60.0f);
    }

    private static float map(float v, float inMin, float inMax, float outMin, float outMax) {
        float t = (v - inMin) / Math.max(1.0E-4f, inMax - inMin);
        return outMin + TornadoProbabilityManager.clamp01(t) * (outMax - outMin);
    }

    private static float clamp01(float x) {
        return Math.max(0.0f, Math.min(1.0f, x));
    }
}

