/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.util;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.Gabou.projectatmosphere.async.PoolType;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public final class AsyncAtmosphereService {
    private static volatile boolean initialized = false;
    private static ThreadPoolExecutor WEATHER_POOL;
    private static ThreadPoolExecutor STORM_POOL;
    private static ThreadPoolExecutor CLIENT_POOL;
    private static ThreadPoolExecutor SHARED_POOL;

    public static ThreadPoolExecutor getWeatherExecutor() {
        return WEATHER_POOL;
    }

    public static ThreadPoolExecutor getStormExecutor() {
        return STORM_POOL;
    }

    public static ThreadPoolExecutor getClientExecutor() {
        return CLIENT_POOL;
    }

    private AsyncAtmosphereService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(boolean isClient) {
        if (initialized) {
            return;
        }
        Class<AsyncAtmosphereService> clazz = AsyncAtmosphereService.class;
        synchronized (AsyncAtmosphereService.class) {
            int baseQueue;
            boolean SPLIT_POOLS;
            if (initialized) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            ProjectAtmosphere.SystemProfile profile = ProjectAtmosphere.SystemProfile.create(isClient);
            int cpu = Math.max(1, profile.cpuCount);
            long memMB = Math.max(1L, profile.maxMemoryMB);
            boolean lowSpec = profile.isLowSpec();
            boolean goodGpu = profile.isGoodEnoughGPU();
            boolean USE_SHARED = lowSpec || cpu <= 4;
            boolean bl = SPLIT_POOLS = !USE_SHARED;
            int weatherQueueCap = baseQueue = memMB <= 2048L ? 256 : (memMB <= 4096L ? 512 : 1024);
            int stormQueueCap = baseQueue;
            int clientQueueCap = 256;
            int weatherCore = AsyncAtmosphereService.clamp(USE_SHARED ? 1 : Math.min(3, Math.max(2, cpu - 2)), 1, 8);
            int weatherMax = AsyncAtmosphereService.clamp(USE_SHARED ? 1 : Math.min(5, cpu * 2), weatherCore, 16);
            int stormCore = AsyncAtmosphereService.clamp(USE_SHARED ? 1 : Math.min(3, Math.max(2, cpu - 2)), 1, 8);
            int stormMax = AsyncAtmosphereService.clamp(USE_SHARED ? 1 : Math.min(5, cpu * 2), stormCore, 16);
            if (USE_SHARED) {
                SHARED_POOL = new ThreadPoolExecutor(Math.min(2, Math.max(1, cpu - 1)), Math.min(2, Math.max(1, cpu - 1)), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(baseQueue), AsyncAtmosphereService.namedFactory("SharedCalc"), new ThreadPoolExecutor.CallerRunsPolicy());
                SHARED_POOL.allowCoreThreadTimeOut(true);
                WEATHER_POOL = SHARED_POOL;
                STORM_POOL = SHARED_POOL;
                ProjectAtmosphere.LOGGER.info("[AsyncAtmosphere] init(shared) | cpu={} mem={}MB gpuOK={} | shared(core={},q={})", (Object)cpu, (Object)memMB, (Object)goodGpu, (Object)SHARED_POOL.getCorePoolSize(), (Object)baseQueue);
            } else {
                WEATHER_POOL = new ThreadPoolExecutor(weatherCore, weatherMax, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(weatherQueueCap), AsyncAtmosphereService.namedFactory("WeatherMgr"), new ThreadPoolExecutor.CallerRunsPolicy());
                WEATHER_POOL.allowCoreThreadTimeOut(true);
                STORM_POOL = new ThreadPoolExecutor(stormCore, stormMax, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(stormQueueCap), AsyncAtmosphereService.namedFactory("StormCalc"), new ThreadPoolExecutor.CallerRunsPolicy());
                STORM_POOL.allowCoreThreadTimeOut(true);
                ProjectAtmosphere.LOGGER.info("[AsyncAtmosphere] init(split)  | cpu={} mem={}MB gpuOK={} | weather(core={},max={},q={}) storm(core={},max={},q={})", (Object)cpu, (Object)memMB, (Object)goodGpu, (Object)weatherCore, (Object)weatherMax, (Object)weatherQueueCap, (Object)stormCore, (Object)stormMax, (Object)stormQueueCap);
            }
            CLIENT_POOL = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(256), AsyncAtmosphereService.namedFactory("ClientMgr"), new ThreadPoolExecutor.CallerRunsPolicy());
            ProjectAtmosphere.LOGGER.info("[AsyncAtmosphere] client(core=1,q={}) | profile.gpu='{}'", (Object)256, (Object)AsyncAtmosphereService.safeGpuName(profile));
            initialized = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void init() {
        AsyncAtmosphereService.init(false);
    }

    public static void runStorm(Runnable task) {
        AsyncAtmosphereService.ensureInit();
        Objects.requireNonNull(task, "task");
        AsyncAtmosphereService.executeSafe(STORM_POOL, AsyncAtmosphereService.wrap(task, "Storm"));
    }

    public static void runWeather(Runnable task) {
        AsyncAtmosphereService.ensureInit();
        Objects.requireNonNull(task, "task");
        AsyncAtmosphereService.executeSafe(WEATHER_POOL, AsyncAtmosphereService.wrap(task, "Weather"));
    }

    public static void runClient(Runnable task) {
        AsyncAtmosphereService.ensureInit();
        Objects.requireNonNull(task, "task");
        AsyncAtmosphereService.executeSafe(CLIENT_POOL, AsyncAtmosphereService.wrap(task, "Client"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        if (!initialized) {
            return;
        }
        Class<AsyncAtmosphereService> clazz = AsyncAtmosphereService.class;
        synchronized (AsyncAtmosphereService.class) {
            if (!initialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            ProjectAtmosphere.LOGGER.info("[AsyncAtmosphere] shutdown");
            if (SHARED_POOL != null && SHARED_POOL == WEATHER_POOL) {
                AsyncAtmosphereService.shutdownPool("Shared", SHARED_POOL);
                WEATHER_POOL = null;
                STORM_POOL = null;
                SHARED_POOL = null;
            } else {
                AsyncAtmosphereService.shutdownPool("Weather", WEATHER_POOL);
                AsyncAtmosphereService.shutdownPool("Storm", STORM_POOL);
            }
            AsyncAtmosphereService.shutdownPool("Client", CLIENT_POOL);
            WEATHER_POOL = null;
            STORM_POOL = null;
            CLIENT_POOL = null;
            initialized = false;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void runOnMainThread(Runnable task) {
        Objects.requireNonNull(task, "task");
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            Minecraft mc = Minecraft.getInstance();
            if (mc != null) {
                mc.execute(task);
            } else {
                ProjectAtmosphere.LOGGER.warn("[AsyncAtmosphere] Tried to schedule on client thread but Minecraft was null");
            }
        } else {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                server.execute(task);
            } else {
                ProjectAtmosphere.LOGGER.warn("[AsyncAtmosphere] Tried to schedule on server thread but server was null");
            }
        }
    }

    public static <T> T callOnMainThread(Callable<T> task) {
        MinecraftServer server;
        Objects.requireNonNull(task, "task");
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            Minecraft mc = Minecraft.getInstance();
            if (mc != null) {
                try {
                    return task.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (EffectiveSide.get() == LogicalSide.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null && server.isSameThread()) {
            try {
                return task.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        CompletableFuture future = new CompletableFuture();
        AsyncAtmosphereService.runOnMainThread(() -> {
            try {
                future.complete(task.call());
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        try {
            return future.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void runWithCallback(PoolType pool, Callable<T> asyncWork, Consumer<T> callback) {
        AsyncAtmosphereService.ensureInit();
        Objects.requireNonNull(pool, "pool");
        Objects.requireNonNull(asyncWork, "asyncWork");
        Objects.requireNonNull(callback, "callback");
        ThreadPoolExecutor exec = switch (pool) {
            default -> throw new MatchException(null, null);
            case PoolType.WEATHER -> WEATHER_POOL;
            case PoolType.STORM -> STORM_POOL;
            case PoolType.CLIENT -> CLIENT_POOL;
        };
        AsyncAtmosphereService.executeSafe(exec, AsyncAtmosphereService.wrap(() -> {
            try {
                Object result = asyncWork.call();
                if (result != null) {
                    AsyncAtmosphereService.runOnMainThread(() -> {
                        try {
                            callback.accept(result);
                        }
                        catch (Throwable t) {
                            ProjectAtmosphere.LOGGER.error("[AsyncAtmosphere] callback failed", t);
                        }
                    });
                }
            }
            catch (Throwable t) {
                ProjectAtmosphere.LOGGER.error("[AsyncAtmosphere] asyncWork failed", t);
            }
        }, pool.name()));
    }

    private static void ensureInit() {
        if (!initialized) {
            AsyncAtmosphereService.init(false);
        }
    }

    private static void executeSafe(ExecutorService svc, Runnable r) {
        if (svc == null || svc.isShutdown()) {
            ProjectAtmosphere.LOGGER.warn("[AsyncAtmosphere] executor not available; running in caller thread");
            r.run();
            return;
        }
        try {
            svc.execute(r);
        }
        catch (RejectedExecutionException rex) {
            ProjectAtmosphere.LOGGER.warn("[AsyncAtmosphere] task rejected; running in caller thread", (Throwable)rex);
            r.run();
        }
    }

    private static Runnable wrap(Runnable r, String tag) {
        return () -> {
            try {
                r.run();
            }
            catch (Throwable t) {
                ProjectAtmosphere.LOGGER.error("[{}] task failed", (Object)tag, (Object)t);
                throw t;
            }
        };
    }

    private static ThreadFactory namedFactory(String base) {
        AtomicInteger idx = new AtomicInteger(1);
        return r -> {
            Thread t = new Thread(r, base + "-" + idx.getAndIncrement());
            t.setDaemon(false);
            t.setPriority(5);
            return t;
        };
    }

    private static void shutdownPool(String name, ExecutorService svc) {
        if (svc == null) {
            return;
        }
        svc.shutdown();
        try {
            if (!svc.awaitTermination(5L, TimeUnit.SECONDS)) {
                ProjectAtmosphere.LOGGER.warn("[AsyncAtmosphere] {} pool timed out; forcing shutdownNow()", (Object)name);
                svc.shutdownNow();
            } else {
                ProjectAtmosphere.LOGGER.info("[AsyncAtmosphere] {} pool terminated", (Object)name);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            ProjectAtmosphere.LOGGER.warn("[AsyncAtmosphere] {} pool shutdown interrupted; forcing shutdownNow()", (Object)name);
            svc.shutdownNow();
        }
    }

    private static int clamp(int v, int lo, int hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    private static String safeGpuName(ProjectAtmosphere.SystemProfile p) {
        try {
            return String.valueOf(p.getGPUName());
        }
        catch (Throwable t) {
            return "unknown";
        }
    }
}

