/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere;

import dev.nonamecrackers2.simpleclouds.api.SimpleCloudsAPI;
import dev.nonamecrackers2.simpleclouds.common.cloud.SimpleCloudsConstants;
import java.util.Map;
import java.util.Objects;
import net.Gabou.projectatmosphere.ClientSystemProfile;
import net.Gabou.projectatmosphere.ServerSystemProfile;
import net.Gabou.projectatmosphere.compat.CompatHandler;
import net.Gabou.projectatmosphere.compat.SimpleCloudsCompat;
import net.Gabou.projectatmosphere.config.AtmoCommonConfig;
import net.Gabou.projectatmosphere.event.BiomeChangeManager;
import net.Gabou.projectatmosphere.event.EventHandler;
import net.Gabou.projectatmosphere.event.SeasonTracker;
import net.Gabou.projectatmosphere.event.TemperatureTickHandler;
import net.Gabou.projectatmosphere.manager.AtmosphereManager;
import net.Gabou.projectatmosphere.modules.temperature.config.BiomeTempUserConfig;
import net.Gabou.projectatmosphere.modules.tornado.TornadoProbabilityManager;
import net.Gabou.projectatmosphere.network.NetworkHandler;
import net.Gabou.projectatmosphere.registry.ClientOnlyRegistrar;
import net.Gabou.projectatmosphere.registry.ModBlocks;
import net.Gabou.projectatmosphere.registry.ModItems;
import net.Gabou.projectatmosphere.registry.ModParticles;
import net.Gabou.projectatmosphere.registry.ModSounds;
import net.Gabou.projectatmosphere.registry.ModTabs;
import net.Gabou.projectatmosphere.seasons.SeasonBootstrap;
import net.Gabou.projectatmosphere.util.AsyncAtmosphereService;
import net.Gabou.projectatmosphere.util.TickCounter;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.locale.Language;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="projectatmosphere")
@Mod.EventBusSubscriber(modid="projectatmosphere")
public class ProjectAtmosphere {
    public static final float DEFAULT_REGION_RADIUS = 1500.0f;
    public static final int DEFAULT_RADIUS = 50000;
    public static long seed;
    public static final String MODID = "projectatmosphere";
    public static final Logger LOGGER;
    public static boolean DEBUG_MODE;
    private static float seaLevel;
    private static boolean seaLevelInitialized;

    public ProjectAtmosphere(FMLJavaModLoadingContext context) {
        LOGGER.info("Project Atmosphere is loading!");
        IEventBus modEventBus = context.getModEventBus();
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AtmoCommonConfig.COMMON_SPEC);
        CompatHandler.init();
        ModItems.register(modEventBus);
        ModSounds.register(modEventBus);
        NetworkHandler.init();
        SimpleCloudsConstants.SPAWN_RADIUS = Math.min(10000, 10000);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(event -> this.clientSetup((FMLClientSetupEvent)event, context));
        MinecraftForge.EVENT_BUS.register(TemperatureTickHandler.class);
        MinecraftForge.EVENT_BUS.register(SeasonTracker.class);
        MinecraftForge.EVENT_BUS.register(BiomeChangeManager.class);
        MinecraftForge.EVENT_BUS.register(EventHandler.class);
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.phase == TickEvent.Phase.END) {
                TickCounter.onServerTick();
            }
        });
        ModParticles.register(modEventBus);
        ModTabs.REGISTRY.register(modEventBus);
        ModBlocks.REGISTRY.register(modEventBus);
        SeasonBootstrap.initOrCrash();
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        ServerLevel world = event.getServer().m_129880_(ServerLevel.f_46428_);
        if (world != null) {
            if (!world.f_46443_) {
                AsyncAtmosphereService.init(false);
                SimpleCloudsCompat.init(world);
                seed = world.m_7328_();
            } else {
                AsyncAtmosphereService.init(true);
            }
        }
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        ServerLevel overworld = server.m_129783_();
        AtmosphereManager.onServerStarted(overworld);
        ProjectAtmosphere.initSeaLevel((Level)overworld);
        if (DEBUG_MODE) {
            LOGGER.info("BiomeSampler initialized with live biome source.");
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player;
        ServerLevel world;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (world = Objects.requireNonNull((player = (ServerPlayer)player2).m_20194_()).m_129880_(ServerLevel.f_46428_)) != null) {
            AtmosphereManager.onPlayerLogout(world, player);
        }
    }

    private void initModules() {
        ProjectAtmosphere.isSereneLoaded();
        ProjectAtmosphere.sendInfo();
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        AsyncAtmosphereService.shutdown();
        ServerLevel world = event.getServer().m_129880_(ServerLevel.f_46428_);
        if (world != null) {
            AtmosphereManager.onServerStopping(world);
            seed = 0L;
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        if (DEBUG_MODE) {
            LOGGER.info("Setting up Project Atmosphere (Common)");
        }
        this.initModules();
        TornadoProbabilityManager.init();
        event.enqueueWork(() -> {
            SimpleCloudsAPI.getApi().getHooks().setExternalWeatherControl(true);
            BiomeTempUserConfig.load();
        });
    }

    private void clientSetup(FMLClientSetupEvent event, FMLJavaModLoadingContext context) {
        event.enqueueWork(() -> {
            if (DEBUG_MODE) {
                LOGGER.info("Setting up Project Atmosphere (Client)");
            }
            ClientOnlyRegistrar.registerClient(MinecraftForge.EVENT_BUS, context);
            Map translations = Language.m_128107_().getLanguageData();
            translations.put("sandstorm.debug.blocked", "Nothing to report. Stay alert.");
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.BAROMETER_BLOCK.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.THERMOMETER_BLOCK.get()), (RenderType)RenderType.m_110466_());
        });
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        AtmosphereManager.onRegisterCommands(event);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (DEBUG_MODE) {
            LOGGER.info("Player logged in!");
        }
        AtmosphereManager.onPlayerLogin(player2.m_20194_().m_129880_(ServerLevel.f_46428_), player2);
    }

    @SubscribeEvent
    public static void onConfigLoaded(ModConfigEvent event) {
    }

    private static void sendInfo() {
        if (DEBUG_MODE) {
            LOGGER.info("All modules subsystems have been initialized (Serene Seasons detected).");
        }
    }

    private static void isSereneLoaded() {
        if (!ModList.get().isLoaded("sereneseasons") && DEBUG_MODE) {
            LOGGER.info("Serene Seasons is not found\u2014skipping all modules subsystems.");
        }
    }

    static void initSeaLevel(Level level) {
        if (!seaLevelInitialized) {
            seaLevel = level.m_5736_();
            seaLevelInitialized = true;
        }
    }

    public static float getSeaLevel() {
        if (!seaLevelInitialized) {
            LOGGER.warn("Sea level requested before initialization; defaulting to 60f.");
            return 60.0f;
        }
        return seaLevel;
    }

    static {
        LOGGER = LogManager.getLogger((String)MODID);
        DEBUG_MODE = true;
        seaLevelInitialized = false;
    }

    public static abstract class SystemProfile {
        public final int cpuCount = Runtime.getRuntime().availableProcessors();
        public final long maxMemoryMB = Runtime.getRuntime().maxMemory() / 0x100000L;

        public boolean isLowSpecCPU() {
            return this.cpuCount <= 4;
        }

        public boolean isLowMemory() {
            return this.maxMemoryMB <= 2048L;
        }

        public boolean isLowSpec() {
            return this.isLowSpecCPU() || this.isLowMemory() || !this.isGoodEnoughGPU();
        }

        public abstract boolean isGoodEnoughGPU();

        public abstract String getGPUName();

        public static SystemProfile create(boolean isClient) {
            return isClient ? new ClientSystemProfile() : new ServerSystemProfile();
        }
    }
}

