/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.api;

import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.wind.WindEngine;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.server.level.ServerLevel;

public final class WindVectorApi {
    private WindVectorApi() {
    }

    public static WindSample getSurface(BiomeInstanceKey key) {
        WindVector vector = WindEngine.getCurrentLowWindVector(key, 0L);
        return new WindSample(vector.baseSpeed(), (float)Math.toDegrees(vector.angleRadians()));
    }

    public static WindSample getOrFallback(BiomeInstanceKey key) {
        return WindVectorApi.getSurface(key);
    }

    public static WindSample getAloftProxy(BiomeInstanceKey key, ServerLevel level) {
        WindVector vector = WindEngine.getCurrentHighWindVector(key, level.m_46467_());
        float dir = (float)Math.toDegrees(vector.angleRadians());
        float speed = vector.baseSpeed();
        return new WindSample(speed, dir);
    }

    public record WindSample(float speedMps, float directionDeg) {
    }
}

