/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.api.common.cloud.region;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.Gabou.projectatmosphere.api.common.cloud.region.TornadoDescriptor;
import org.jetbrains.annotations.Nullable;

public interface ITornadoRegion {
    public static final String TORNADO_LIST_KEY = "projectatmosphere_tornadoes";

    public List<TornadoDescriptor> getTornadoes();

    public void setTornadoes(List<TornadoDescriptor> var1);

    default public void clearTornadoes() {
        this.getTornadoes().clear();
    }

    default public List<TornadoDescriptor> getTornadoesView() {
        return Collections.unmodifiableList(this.getTornadoes());
    }

    default public void addTornado(TornadoDescriptor descriptor) {
        this.getTornadoes().add(descriptor);
    }

    default public boolean removeTornado(UUID id) {
        return this.getTornadoes().removeIf(descriptor -> descriptor.getId().equals(id));
    }

    @Nullable
    default public TornadoDescriptor findTornado(UUID id) {
        for (TornadoDescriptor descriptor : this.getTornadoes()) {
            if (!descriptor.getId().equals(id)) continue;
            return descriptor;
        }
        return null;
    }

    default public void replaceTornado(TornadoDescriptor descriptor) {
        List<TornadoDescriptor> list = this.getTornadoes();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getId().equals(descriptor.getId())) continue;
            list.set(i, descriptor);
            return;
        }
        list.add(descriptor);
    }

    public static List<TornadoDescriptor> copy(List<TornadoDescriptor> source) {
        return new ArrayList<TornadoDescriptor>(source);
    }
}

