/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.api.common.cloud.region;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class TornadoDescriptor {
    public static final String KEY_UUID = "uuid";
    public static final String KEY_CONTROLLER = "controller";
    public static final String KEY_OFFSET_X = "offset_x";
    public static final String KEY_OFFSET_Z = "offset_z";
    public static final String KEY_VELOCITY_X = "velocity_x";
    public static final String KEY_VELOCITY_Z = "velocity_z";
    public static final String KEY_RADIUS = "radius";
    public static final String KEY_HEIGHT = "height";
    public static final String KEY_BOTTOM = "bottom";
    private final UUID id;
    private final ResourceLocation controllerId;
    private float offsetX;
    private float offsetZ;
    private float velocityX;
    private float velocityZ;
    private float radius;
    private float height;
    private float bottomY;

    public TornadoDescriptor(UUID id, ResourceLocation controllerId, float offsetX, float offsetZ, float velocityX, float velocityZ, float radius, float bottomY, float height) {
        this.id = id;
        this.controllerId = controllerId;
        this.offsetX = offsetX;
        this.offsetZ = offsetZ;
        this.velocityX = velocityX;
        this.velocityZ = velocityZ;
        this.radius = radius;
        this.bottomY = bottomY;
        this.height = height;
    }

    public TornadoDescriptor(ResourceLocation controllerId, float offsetX, float offsetZ, float velocityX, float velocityZ, float radius, float bottomY, float height) {
        this(UUID.randomUUID(), controllerId, offsetX, offsetZ, velocityX, velocityZ, radius, bottomY, height);
    }

    public UUID getId() {
        return this.id;
    }

    public ResourceLocation getControllerId() {
        return this.controllerId;
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(float offsetX) {
        this.offsetX = offsetX;
    }

    public float getOffsetZ() {
        return this.offsetZ;
    }

    public void setOffsetZ(float offsetZ) {
        this.offsetZ = offsetZ;
    }

    public float getVelocityX() {
        return this.velocityX;
    }

    public void setVelocityX(float velocityX) {
        this.velocityX = velocityX;
    }

    public float getVelocityZ() {
        return this.velocityZ;
    }

    public void setVelocityZ(float velocityZ) {
        this.velocityZ = velocityZ;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public float getBottomY() {
        return this.bottomY;
    }

    public void setBottomY(float bottomY) {
        this.bottomY = bottomY;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void tick(float regionDeltaX, float regionDeltaZ) {
        this.offsetX += regionDeltaX + this.velocityX;
        this.offsetZ += regionDeltaZ + this.velocityZ;
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_(KEY_UUID, this.id);
        if (this.controllerId != null) {
            tag.m_128359_(KEY_CONTROLLER, this.controllerId.toString());
        }
        tag.m_128350_(KEY_OFFSET_X, this.offsetX);
        tag.m_128350_(KEY_OFFSET_Z, this.offsetZ);
        tag.m_128350_(KEY_VELOCITY_X, this.velocityX);
        tag.m_128350_(KEY_VELOCITY_Z, this.velocityZ);
        tag.m_128350_(KEY_RADIUS, this.radius);
        tag.m_128350_(KEY_HEIGHT, this.height);
        tag.m_128350_(KEY_BOTTOM, this.bottomY);
        return tag;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130077_(this.id);
        buf.m_236821_((Object)this.controllerId, FriendlyByteBuf::m_130085_);
        buf.writeFloat(this.offsetX);
        buf.writeFloat(this.offsetZ);
        buf.writeFloat(this.velocityX);
        buf.writeFloat(this.velocityZ);
        buf.writeFloat(this.radius);
        buf.writeFloat(this.height);
        buf.writeFloat(this.bottomY);
    }

    public static TornadoDescriptor read(FriendlyByteBuf buf) {
        UUID uuid = buf.m_130259_();
        ResourceLocation controller = (ResourceLocation)buf.m_236868_(FriendlyByteBuf::m_130281_);
        float offsetX = buf.readFloat();
        float offsetZ = buf.readFloat();
        float velocityX = buf.readFloat();
        float velocityZ = buf.readFloat();
        float radius = buf.readFloat();
        float height = buf.readFloat();
        float bottom = buf.readFloat();
        return new TornadoDescriptor(uuid, controller, offsetX, offsetZ, velocityX, velocityZ, radius, bottom, height);
    }

    public static TornadoDescriptor fromTag(CompoundTag tag) {
        UUID uuid = tag.m_128403_(KEY_UUID) ? tag.m_128342_(KEY_UUID) : UUID.randomUUID();
        ResourceLocation controller = tag.m_128425_(KEY_CONTROLLER, 8) ? new ResourceLocation(tag.m_128461_(KEY_CONTROLLER)) : null;
        float offsetX = tag.m_128457_(KEY_OFFSET_X);
        float offsetZ = tag.m_128457_(KEY_OFFSET_Z);
        float velocityX = tag.m_128457_(KEY_VELOCITY_X);
        float velocityZ = tag.m_128457_(KEY_VELOCITY_Z);
        float radius = tag.m_128457_(KEY_RADIUS);
        float height = tag.m_128441_(KEY_HEIGHT) ? tag.m_128457_(KEY_HEIGHT) : 64.0f;
        float bottom = tag.m_128441_(KEY_BOTTOM) ? tag.m_128457_(KEY_BOTTOM) : 0.0f;
        return new TornadoDescriptor(uuid, controller, offsetX, offsetZ, velocityX, velocityZ, radius, bottom, height);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TornadoDescriptor)) {
            return false;
        }
        TornadoDescriptor other = (TornadoDescriptor)obj;
        return Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "TornadoDescriptor{id=" + String.valueOf(this.id) + ", controller=" + String.valueOf(this.controllerId) + ", offsetX=" + this.offsetX + ", offsetZ=" + this.offsetZ + ", radius=" + this.radius + ", height=" + this.height + "}";
    }
}

