/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.blocks;

import dev.nonamecrackers2.simpleclouds.common.cloud.region.CloudRegion;
import dev.nonamecrackers2.simpleclouds.common.world.CloudManager;
import java.util.List;
import net.Gabou.projectatmosphere.modules.core.CloudLibrary;
import net.Gabou.projectatmosphere.registry.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StormSirenBlock
extends Block {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    private static final int CHECK_RADIUS = 400;
    private static final float INTENSITY_THRESHOLD = 6.0f;

    public StormSirenBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos pos = ctx.m_8083_();
        Level level = ctx.m_43725_();
        if (pos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(pos.m_7494_()).m_60629_(ctx)) {
            return (BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        level.m_7731_(pos.m_7494_(), (BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        if (half == DoubleBlockHalf.UPPER) {
            BlockPos below = pos.m_7495_();
            BlockState belowState = level.m_8055_(below);
            if (belowState.m_60734_() == this) {
                level.m_46961_(below, !player.m_7500_());
            }
        } else {
            BlockPos above = pos.m_7494_();
            BlockState aboveState = level.m_8055_(above);
            if (aboveState.m_60734_() == this) {
                level.m_46961_(above, false);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (!level.f_46443_ && state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            level.m_186460_(pos, (Block)this, 200);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            return;
        }
        List<CloudRegion> lst = CloudManager.get((Level)level).getClouds().stream().filter(cloudRegion -> CloudLibrary.getSeverityFromRessourceLocation(cloudRegion.getCloudTypeId()) >= 6).toList();
        if (!lst.isEmpty() && lst.stream().anyMatch(cloudRegion -> {
            double dz;
            double dx = cloudRegion.getWorldX() - (float)pos.m_123341_();
            return dx * dx + (dz = (double)(cloudRegion.getWorldZ() - (float)pos.m_123343_())) * dz < 160000.0;
        })) {
            level.m_5594_(null, pos, (SoundEvent)ModSounds.WEATHER_SIREN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        level.m_186460_(pos, (Block)this, 200);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }
}

