/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.nonamecrackers2.simpleclouds.client.renderer.SimpleCloudsRenderer;
import dev.nonamecrackers2.simpleclouds.common.config.SimpleCloudsConfig;
import java.util.concurrent.atomic.AtomicBoolean;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.Gabou.projectatmosphere.client.MyShaders;
import net.Gabou.projectatmosphere.modules.tornado.TornadoInstance;
import net.Gabou.projectatmosphere.modules.tornado.TornadoLevel;
import net.Gabou.projectatmosphere.modules.tornado.TornadoManager;
import net.Gabou.projectatmosphere.particles.DebrisParticleData;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class TornadoRenderHandler {
    private static final ResourceLocation NOISE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"projectatmosphere", (String)"textures/effects/noise.png");
    private static final ResourceLocation TORNADO_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"projectatmosphere", (String)"textures/effects/base.png");
    private static final ResourceLocation FLOWMAP_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"projectatmosphere", (String)"textures/effects/flowmap.png");
    private static final ResourceLocation NORMALMAP_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"projectatmosphere", (String)"textures/effects/tornado_normal.png");
    private static final float SPAWN_DESCENT_DURATION = 10.0f;

    public static void renderTornado(PoseStack stack, double tornadoX, double tornadoY, double tornadoZ, float twistSpeed, ClientLevel level, Camera camera, Minecraft minecraft, TornadoInstance tornado) {
        Uniform scaleUniform;
        Uniform flowIntensity;
        Uniform coreUniform;
        Uniform dustUniform;
        Uniform heightUniform;
        Uniform topRadiusUniform;
        Uniform baseRadiusUniform;
        Uniform twistUniform;
        Uniform timeUniform;
        Uniform projMat;
        ShaderInstance shader = MyShaders.TORNADO;
        if (shader == null) {
            return;
        }
        AtomicBoolean boundBaseToClouds = new AtomicBoolean(false);
        SimpleCloudsRenderer.getOptionalInstance().ifPresent(scr -> {
            RenderTarget cloudRT = scr.getCloudTarget();
            if (cloudRT == null) {
                ProjectAtmosphere.LOGGER.warn("Cloud render target is null, cannot bind clouds as tornado base texture.");
                return;
            }
            shader.m_173350_("Sampler0", (Object)cloudRT);
            shader.m_173350_("CloudScene", (Object)cloudRT);
            Uniform u = shader.m_173348_("ScreenSizeX");
            Uniform u1 = shader.m_173348_("ScreenSizeY");
            if (u != null && u1 != null) {
                u.m_5985_((float)cloudRT.f_83915_);
                u1.m_5985_((float)cloudRT.f_83916_);
            }
            boundBaseToClouds.set(true);
        });
        if (!boundBaseToClouds.get()) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TORNADO_TEXTURE);
            RenderSystem.setShaderTexture((int)4, (ResourceLocation)TORNADO_TEXTURE);
        }
        RenderSystem.setShaderTexture((int)1, (ResourceLocation)FLOWMAP_TEXTURE);
        RenderSystem.setShaderTexture((int)2, (ResourceLocation)NORMALMAP_TEXTURE);
        RenderSystem.setShaderTexture((int)3, (ResourceLocation)NOISE_TEXTURE);
        RenderSystem.setShader(() -> shader);
        shader.m_173363_();
        int segments = 64;
        int rings = 128;
        float baseRadius = 20.0f;
        float topRadius = 5.0f;
        float height = 356.0f;
        stack.m_85836_();
        stack.m_85837_(tornadoX, tornadoY, tornadoZ);
        Matrix4f matrix = stack.m_85850_().m_252922_();
        Uniform modelView = shader.m_173348_("ModelViewMat");
        if (modelView != null) {
            modelView.m_5679_(matrix);
        }
        if ((projMat = shader.m_173348_("ProjMat")) != null) {
            projMat.m_5679_(RenderSystem.getProjectionMatrix());
        }
        if ((timeUniform = shader.m_173348_("Time")) != null) {
            timeUniform.m_5985_(TornadoManager.getShaderTime());
        }
        if ((twistUniform = shader.m_173348_("TwistSpeed")) != null) {
            twistUniform.m_5985_(twistSpeed);
        }
        if ((baseRadiusUniform = shader.m_173348_("BaseRadius")) != null) {
            baseRadiusUniform.m_5985_(baseRadius);
        }
        if ((topRadiusUniform = shader.m_173348_("TopRadius")) != null) {
            topRadiusUniform.m_5985_(topRadius);
        }
        if ((heightUniform = shader.m_173348_("Height")) != null) {
            heightUniform.m_5985_(height);
        }
        if ((dustUniform = shader.m_173348_("DustIntensity")) != null) {
            dustUniform.m_5985_(0.5f);
        }
        if ((coreUniform = shader.m_173348_("CoreTightness")) != null) {
            coreUniform.m_5985_(0.2f);
        }
        if ((flowIntensity = shader.m_173348_("FlowIntensity")) != null) {
            flowIntensity.m_5985_(0.1f);
        }
        if ((scaleUniform = shader.m_173348_("Scale")) != null) {
            float scale = (float)(tornado.getLevel().getBaseDamage() / TornadoLevel.F1.getBaseDamage());
            scaleUniform.m_5985_(scale);
        }
        float partialTicks = minecraft.m_91296_();
        float sunAngle = level.m_46942_(partialTicks);
        float angle = sunAngle * ((float)Math.PI * 2);
        float xLight = Mth.m_14089_((float)angle);
        float yLight = Mth.m_14031_((float)angle);
        float zLight = 0.2f;
        float length = Mth.m_14116_((float)(xLight * xLight + yLight * yLight + zLight * zLight));
        xLight /= length;
        yLight /= length;
        zLight /= length;
        Uniform lightX = shader.m_173348_("LightDirX");
        Uniform lightY = shader.m_173348_("LightDirY");
        Uniform lightZ = shader.m_173348_("LightDirZ");
        if (lightX != null) {
            lightX.m_5985_(xLight);
        }
        if (lightY != null) {
            lightY.m_5985_(yLight);
        }
        if (lightZ != null) {
            lightZ.m_5985_(zLight);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buffer = tess.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85817_);
        float windSpeed = tornado.wind.gustSpeed();
        float windAngleDeg = tornado.wind.angleRadians();
        float windAngleRad = (float)Math.toRadians(windAngleDeg);
        double windX = Math.cos(windAngleRad) * (double)windSpeed;
        double windZ = Math.sin(windAngleRad) * (double)windSpeed;
        Vec3 horizontalWind = new Vec3(windX, 5.0, windZ);
        float spawnProgress = Mth.m_14036_((float)(tornado.getLifetimeSeconds() / 10.0f), (float)0.0f, (float)1.0f);
        float cutoffY = height * (1.0f - spawnProgress);
        float time = TornadoManager.getShaderTime();
        for (int i = rings - 1; i >= 0; --i) {
            float y0 = (float)i * (height / (float)rings);
            float y1 = (float)(i + 1) * (height / (float)rings);
            if (y1 < cutoffY) break;
            if (y0 < cutoffY) {
                y0 = cutoffY;
            }
            float t0 = y0 / height;
            float t1 = y1 / height;
            for (int j = 0; j < segments; ++j) {
                float u0 = (float)j / (float)segments;
                float u1 = ((float)j + 1.0f) / (float)segments;
                float U_EPS = 1.0E-6f;
                float u0s = j == 0 ? u0 + 1.0E-6f : u0;
                float u1s = j == segments - 1 ? 0.999999f : u1;
                float twist = 10.995574f;
                float angleOffset0 = twist * (1.0f - t0);
                float angleOffset1 = twist * (1.0f - t1);
                float angle0_0 = (float)(Math.PI * 2 * (double)u0 + (double)angleOffset0);
                float angle0_1 = (float)(Math.PI * 2 * (double)u1 + (double)angleOffset0);
                float angle1_0 = (float)(Math.PI * 2 * (double)u0 + (double)angleOffset1);
                float angle1_1 = (float)(Math.PI * 2 * (double)u1 + (double)angleOffset1);
                float x00 = TornadoRenderHandler.tornadoShapeRadius(y0, angle0_0, time) * (float)Math.cos(angle0_0);
                float z00 = TornadoRenderHandler.tornadoShapeRadius(y0, angle0_0, time) * (float)Math.sin(angle0_0);
                float x01 = TornadoRenderHandler.tornadoShapeRadius(y0, angle0_1, time) * (float)Math.cos(angle0_1);
                float z01 = TornadoRenderHandler.tornadoShapeRadius(y0, angle0_1, time) * (float)Math.sin(angle0_1);
                float x10 = TornadoRenderHandler.tornadoShapeRadius(y1, angle1_0, time) * (float)Math.cos(angle1_0);
                float z10 = TornadoRenderHandler.tornadoShapeRadius(y1, angle1_0, time) * (float)Math.sin(angle1_0);
                float x11 = TornadoRenderHandler.tornadoShapeRadius(y1, angle1_1, time) * (float)Math.cos(angle1_1);
                float z11 = TornadoRenderHandler.tornadoShapeRadius(y1, angle1_1, time) * (float)Math.sin(angle1_1);
                float wiggleFreq = 5.0f;
                float wiggleAmp = 0.5f;
                x00 = (float)((double)x00 + Math.sin(y0 * 0.1f + angle0_0 * wiggleFreq) * (double)wiggleAmp);
                z00 = (float)((double)z00 + Math.cos(y0 * 0.1f + angle0_0 * wiggleFreq) * (double)wiggleAmp);
                x01 = (float)((double)x01 + Math.sin(y0 * 0.1f + angle0_1 * wiggleFreq) * (double)wiggleAmp);
                z01 = (float)((double)z01 + Math.cos(y0 * 0.1f + angle0_1 * wiggleFreq) * (double)wiggleAmp);
                x10 = (float)((double)x10 + Math.sin(y1 * 0.1f + angle1_0 * wiggleFreq) * (double)wiggleAmp);
                z10 = (float)((double)z10 + Math.cos(y1 * 0.1f + angle1_0 * wiggleFreq) * (double)wiggleAmp);
                x11 = (float)((double)x11 + Math.sin(y1 * 0.1f + angle1_1 * wiggleFreq) * (double)wiggleAmp);
                z11 = (float)((double)z11 + Math.cos(y1 * 0.1f + angle1_1 * wiggleFreq) * (double)wiggleAmp);
                float epsilon = 1.0E-4f;
                float v0 = (y0 + epsilon) / height;
                float v1 = (y1 - epsilon) / height;
                float bendScale = 1.5f;
                float bendFactor0 = y0 / height * bendScale * windSpeed;
                float bendFactor1 = y1 / height * bendScale * windSpeed;
                float offsetX0 = (float)horizontalWind.f_82479_ * bendFactor0;
                float offsetZ0 = (float)horizontalWind.f_82481_ * bendFactor0;
                float offsetX1 = (float)horizontalWind.f_82479_ * bendFactor1;
                float offsetZ1 = (float)horizontalWind.f_82481_ * bendFactor1;
                x01 += offsetX0;
                z01 += offsetZ0;
                buffer.m_252986_(matrix, x00 += offsetX0, y0, z00 += offsetZ0).m_7421_(u0s, v0).m_5752_();
                buffer.m_252986_(matrix, x10 += offsetX1, y1, z10 += offsetZ1).m_7421_(u0s, v1).m_5752_();
                buffer.m_252986_(matrix, x11 += offsetX1, y1, z11 += offsetZ1).m_7421_(u1s, v1).m_5752_();
                buffer.m_252986_(matrix, x00, y0, z00).m_7421_(u0s, v0).m_5752_();
                buffer.m_252986_(matrix, x11, y1, z11).m_7421_(u1s, v1).m_5752_();
                buffer.m_252986_(matrix, x01, y0, z01).m_7421_(u1s, v0).m_5752_();
            }
        }
        int bowlRings = 24;
        float bowlHeight = 12.0f;
        float angleDeg = 18.0f;
        float targetTopR = (topRadius -= 3.0f) * 1.6f;
        float factor = 1.6f;
        float p = 1.0f;
        float flareSlope = 0.3f;
        float maxBowlRadius = topRadius + flareSlope * bowlHeight;
        for (int i = 0; i < bowlRings; ++i) {
            float t0 = (float)i / (float)bowlRings;
            float t1 = ((float)i + 1.0f) / (float)bowlRings;
            float y0 = height + t0 * bowlHeight;
            float y1 = height + t1 * bowlHeight;
            float r0 = TornadoRenderHandler.coneRadiusByAngle(y0, height, topRadius, bowlHeight, angleDeg, p);
            float r1 = TornadoRenderHandler.coneRadiusByAngle(y1, height, topRadius, bowlHeight, angleDeg, p);
            float twist = 10.995574f;
            float aOff0 = twist * (1.0f - Math.min(1.0f, y0 / height));
            float aOff1 = twist * (1.0f - Math.min(1.0f, y1 / height));
            for (int j = 0; j < segments; ++j) {
                float u0 = (float)j / (float)segments;
                float u1 = ((float)j + 1.0f) / (float)segments;
                float a00 = (float)(Math.PI * 2 * (double)u0 + (double)aOff0);
                float a01 = (float)(Math.PI * 2 * (double)u1 + (double)aOff0);
                float a10 = (float)(Math.PI * 2 * (double)u0 + (double)aOff1);
                float a11 = (float)(Math.PI * 2 * (double)u1 + (double)aOff1);
                float x00 = r0 * (float)Math.cos(a00);
                float z00 = r0 * (float)Math.sin(a00);
                float x01 = r0 * (float)Math.cos(a01);
                float z01 = r0 * (float)Math.sin(a01);
                float x10 = r1 * (float)Math.cos(a10);
                float z10 = r1 * (float)Math.sin(a10);
                float x11 = r1 * (float)Math.cos(a11);
                float z11 = r1 * (float)Math.sin(a11);
                float b0 = y0 / (height + bowlHeight) * 1.5f * windSpeed;
                float b1 = y1 / (height + bowlHeight) * 1.5f * windSpeed;
                x00 += (float)horizontalWind.f_82479_ * b0;
                z00 += (float)horizontalWind.f_82481_ * b0;
                x01 += (float)horizontalWind.f_82479_ * b0;
                z01 += (float)horizontalWind.f_82481_ * b0;
                x10 += (float)horizontalWind.f_82479_ * b1;
                z10 += (float)horizontalWind.f_82481_ * b1;
                x11 += (float)horizontalWind.f_82479_ * b1;
                z11 += (float)horizontalWind.f_82481_ * b1;
                float epsilon = 1.0E-4f;
                float v0 = Math.min(1.0f - epsilon, y0 / height);
                float v1 = Math.min(1.0f - epsilon, y1 / height);
                buffer.m_252986_(matrix, x00, y0, z00).m_7421_(u0, v0).m_5752_();
                buffer.m_252986_(matrix, x10, y1, z10).m_7421_(u0, v1).m_5752_();
                buffer.m_252986_(matrix, x11, y1, z11).m_7421_(u1, v1).m_5752_();
                buffer.m_252986_(matrix, x00, y0, z00).m_7421_(u0, v0).m_5752_();
                buffer.m_252986_(matrix, x11, y1, z11).m_7421_(u1, v1).m_5752_();
                buffer.m_252986_(matrix, x01, y0, z01).m_7421_(u1, v0).m_5752_();
            }
        }
        tess.m_85914_();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        stack.m_85849_();
    }

    public static void spawnDebrisParticles(TornadoInstance tornado, ClientLevel level) {
        for (int i = 0; i < 10; ++i) {
            double maxRadius = 16.0;
            double radius = Math.sqrt(level.f_46441_.m_188500_()) * maxRadius;
            double height = level.f_46441_.m_188500_() * (double)((Integer)SimpleCloudsConfig.CLIENT.cloudHeight.get()).intValue();
            float angularSpeed = 4.0f;
            level.m_7106_((ParticleOptions)new DebrisParticleData(tornado, radius, height, angularSpeed), tornado.position.f_82479_, tornado.position.f_82480_, tornado.position.f_82481_, 0.0, 0.01, 0.0);
        }
    }

    private static float tornadoShapeRadius(float y, float angle, float time) {
        float yAdj = y + 45.0f;
        float zcurve = (float)Math.pow(yAdj, 1.5) * 0.03f;
        float base = zcurve + 5.5f;
        float scale = Mth.m_14036_((float)(zcurve * 0.2f), (float)0.1f, (float)1.0f);
        float radius = base + scale * Mth.m_14031_((float)(time - Mth.m_14116_((float)yAdj) + angle)) * 5.0f;
        float ridgedNoise = 1.0f - 2.0f * Math.abs(Mth.m_14031_((float)(time * 1.5f + 0.1f * yAdj + angle)));
        return radius -= ridgedNoise * 1.2f;
    }

    static float coneRadiusByAngle(float y, float seamY, float topRadius, float bowlHeight, float angleDeg, float p) {
        float t = Mth.m_14036_((float)((y - seamY) / bowlHeight), (float)0.0f, (float)1.0f);
        float slope = (float)Math.tan(Math.toRadians(angleDeg));
        float targetR = topRadius + slope * bowlHeight;
        float linear = topRadius + (targetR - topRadius) * t;
        return p == 1.0f ? linear : topRadius + (targetR - topRadius) * (float)Math.pow(t, p);
    }
}

