/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.Gabou.projectatmosphere.compat.CompatHandler;
import net.Gabou.projectatmosphere.manager.AtmosphereManager;
import net.Gabou.projectatmosphere.manager.ForecastDataStorage;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.util.RegionInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber
public class BiomeChangeManager {
    private static final Map<UUID, RegionTrack> regionTrack = new HashMap<UUID, RegionTrack>();
    private static final Map<UUID, Pair<ResourceLocation, Boolean>> lastBiome = new HashMap<UUID, Pair<ResourceLocation, Boolean>>();
    private static final int RUN_INTERVAL_TICKS = 2000;
    private static final int MOVE_THRESHOLD = 40000;
    private static final boolean sandStormsLoaded = CompatHandler.isSandStormsLoaded();
    private static final Set<String> SANDSTORM_KEYWORDS = Set.of("desert", "badlands", "mesa", "wasteland", "volcanic_plains", "lush_desert", "cold_desert", "dryland", "scrubland", "shrubland", "rocky_shrubland", "tundra", "dead_forest", "old_growth_dead_forest", "arid", "savanna_badlands", "red_desert", "ash", "barren", "dry");

    public static Map<UUID, Pair<ResourceLocation, Boolean>> getLastBiome() {
        return lastBiome;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END || ev.side.isClient()) {
            return;
        }
        Player player = ev.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ServerLevel level = player2.m_284548_();
        long t = player2.m_284548_().m_46468_() % 24000L;
        if (t % 2000L != 0L) {
            return;
        }
        UUID uuid = player2.m_20148_();
        BlockPos pos = player2.m_20183_();
        RegionInstanceKey region = RegionInstanceKey.from(pos);
        RegionTrack track = regionTrack.computeIfAbsent(uuid, id -> new RegionTrack(region, pos));
        ResourceLocation nowBiome = BiomeChangeManager.getBiomeKeyAt(player2);
        Pair<ResourceLocation, Boolean> last = lastBiome.get(uuid);
        if (last == null || !((ResourceLocation)last.getKey()).equals((Object)nowBiome)) {
            lastBiome.put(uuid, (Pair<ResourceLocation, Boolean>)Pair.of((Object)nowBiome, (Object)BiomeChangeManager.isDesert(nowBiome)));
        }
        if (!track.region().equals(region)) {
            track = new RegionTrack(region, pos);
            regionTrack.put(uuid, track);
            BiomeChangeManager.onRegionChanged(player2, region, nowBiome);
            return;
        }
        if (track.center().m_123333_((Vec3i)pos) > 40000) {
            track = new RegionTrack(region, pos);
            regionTrack.put(uuid, track);
            BiomeChangeManager.onRegionChanged(player2, region, nowBiome);
        }
    }

    public static boolean isDesert(ResourceLocation biomeId) {
        return BiomeChangeManager.isSandstormBiome(biomeId);
    }

    private static boolean isSandstormBiome(ResourceLocation biomeKey) {
        if (biomeKey == null) {
            return false;
        }
        String path = biomeKey.m_135815_().toLowerCase();
        for (String keyword : SANDSTORM_KEYWORDS) {
            if (!path.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    private static ResourceLocation getBiomeKeyAt(ServerPlayer p) {
        BlockPos pos = p.m_20183_();
        return p.m_284548_().m_204166_(pos).m_203543_().map(ResourceKey::m_135782_).orElse(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"plains"));
    }

    private static void onRegionChanged(ServerPlayer player, RegionInstanceKey region, ResourceLocation currentBiome) {
        UUID uuid = player.m_20148_();
        BlockPos currentPos = player.m_20183_();
        ForecastDataStorage.playerData.put(uuid, currentPos);
        lastBiome.put(uuid, (Pair<ResourceLocation, Boolean>)Pair.of((Object)currentBiome, (Object)BiomeChangeManager.isDesert(currentBiome)));
        ForecastOrchestrator.clearActiveBiomeKeysForPlayer(player);
        ForecastOrchestrator.getNearbyBiomeKeys(player.m_284548_(), player, 500.0);
        AtmosphereManager.updateForecastAround(player.m_284548_(), currentPos);
        player.m_213846_((Component)Component.m_237113_((String)("[Atmosphere] Entered region " + String.valueOf(region) + ". Forecast regenerated.")));
    }

    private record RegionTrack(RegionInstanceKey region, BlockPos center) {
    }
}

