/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.manager;

import dev.nonamecrackers2.simpleclouds.common.cloud.SimpleCloudsConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.Gabou.projectatmosphere.async.BiomeSampler;
import net.Gabou.projectatmosphere.compat.CompatHandler;
import net.Gabou.projectatmosphere.compat.ToughAsNailsCompat;
import net.Gabou.projectatmosphere.manager.ForecastPointerRegistry;
import net.Gabou.projectatmosphere.manager.SandStormManager;
import net.Gabou.projectatmosphere.modules.atmosphere.AtmosphericStateRegistry;
import net.Gabou.projectatmosphere.modules.atmosphere.RegionAtmosphereState;
import net.Gabou.projectatmosphere.modules.core.BiomeForecast;
import net.Gabou.projectatmosphere.modules.core.ForecastRegion;
import net.Gabou.projectatmosphere.modules.core.ForecastType;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.humidity.HumidityGenerator;
import net.Gabou.projectatmosphere.modules.pressure.PressureGenerator;
import net.Gabou.projectatmosphere.modules.temperature.util.TemperatureGenerator;
import net.Gabou.projectatmosphere.modules.temperature.variation.VariationGenerator;
import net.Gabou.projectatmosphere.modules.wind.WindGenerator;
import net.Gabou.projectatmosphere.network.BiomeDayTemperaturePacket;
import net.Gabou.projectatmosphere.network.NetworkHandler;
import net.Gabou.projectatmosphere.util.AsyncAtmosphereService;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.Gabou.projectatmosphere.util.RegionInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraftforge.network.PacketDistributor;

public class ForecastGenerator {
    private static final int SAMPLE_STEP = 64;
    static long seed = 0L;
    static final boolean sandStormLoaded = CompatHandler.isSandStormsLoaded();
    public static final int MAX_POSITIONS_PER_BIOME;
    static final float SEA_LEVEL;
    public static String message;
    static final int RADIUS;
    static final Set<BiomeInstanceKey> biomeSamples;
    private static Map<ResourceLocation, List<BiomeInstanceKey>> biomeIndex;
    private static final Map<ResourceLocation, Integer> biomeSampleCounts;
    private static final Map<ResourceLocation, BiomeForecast> AVERAGE_FORECASTS;
    static final Map<BiomeInstanceKey, BiomeForecast> FORECAST_MAP;
    static final Map<RegionInstanceKey, ForecastRegion> REGION_FORECASTS;
    private static final Map<ResourceLocation, List<BiomeForecast>> grouped;

    public static Map<ResourceLocation, List<BiomeInstanceKey>> getBiomeIndex() {
        return Collections.unmodifiableMap(biomeIndex);
    }

    public static void groupBiomeByType() {
        biomeIndex = biomeSamples.stream().collect(Collectors.groupingBy(BiomeInstanceKey::biomeType));
    }

    static void computeAverageForecastsByBiomeType() {
        HashMap<ResourceLocation, float[]> map = new HashMap<ResourceLocation, float[]>();
        for (Map.Entry<ResourceLocation, List<BiomeForecast>> entry : grouped.entrySet()) {
            List<BiomeForecast> list = entry.getValue();
            if (list.isEmpty()) continue;
            BiomeForecast avg = AVERAGE_FORECASTS.computeIfAbsent(entry.getKey(), k -> new BiomeForecast());
            avg.setTemperature(ForecastGenerator.averageWeek(list, BiomeForecast::getTemperature));
            avg.setHumidity(ForecastGenerator.averageWeek(list, BiomeForecast::getHumidity));
            avg.setPressure(ForecastGenerator.averageWeek(list, BiomeForecast::getPressure));
            avg.setWind(ForecastGenerator.averageWindWeek(list, BiomeForecast::getWind));
            avg.setBiomeKey(list.get(0).getBiomeKey());
            float representative = ForecastGenerator.deriveRepresentativeTemperature(avg);
            map.put(entry.getKey(), ForecastGenerator.buildFlatCurve(representative));
        }
        NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new BiomeDayTemperaturePacket(map));
    }

    private static void computeAverageTemperatureWeek() {
        for (Map.Entry<ResourceLocation, List<BiomeForecast>> entry : grouped.entrySet()) {
            List<BiomeForecast> list = entry.getValue();
            if (list.isEmpty()) continue;
            BiomeForecast avg = AVERAGE_FORECASTS.computeIfAbsent(entry.getKey(), k -> new BiomeForecast());
            avg.setTemperature(ForecastGenerator.averageWeek(list, BiomeForecast::getTemperature));
        }
    }

    private static void computeAverageHumidityWeek() {
        for (Map.Entry<ResourceLocation, List<BiomeForecast>> entry : grouped.entrySet()) {
            List<BiomeForecast> list = entry.getValue();
            if (list.isEmpty()) continue;
            BiomeForecast avg = AVERAGE_FORECASTS.computeIfAbsent(entry.getKey(), k -> new BiomeForecast());
            avg.setHumidity(ForecastGenerator.averageWeek(list, BiomeForecast::getHumidity));
        }
    }

    private static void computeAveragePressureWeek() {
        for (Map.Entry<ResourceLocation, List<BiomeForecast>> entry : grouped.entrySet()) {
            List<BiomeForecast> list = entry.getValue();
            if (list.isEmpty()) continue;
            BiomeForecast avg = AVERAGE_FORECASTS.computeIfAbsent(entry.getKey(), k -> new BiomeForecast());
            avg.setPressure(ForecastGenerator.averageWeek(list, BiomeForecast::getPressure));
        }
    }

    private static void computeAverageWindWeek() {
        for (Map.Entry<ResourceLocation, List<BiomeForecast>> entry : grouped.entrySet()) {
            List<BiomeForecast> list = entry.getValue();
            if (list.isEmpty()) continue;
            BiomeForecast avg = AVERAGE_FORECASTS.computeIfAbsent(entry.getKey(), k -> new BiomeForecast());
            avg.setWind(ForecastGenerator.averageWindWeek(list, BiomeForecast::getWind));
        }
    }

    public static void groupForecastsByBiome() {
        for (Map.Entry<BiomeInstanceKey, BiomeForecast> entry : FORECAST_MAP.entrySet()) {
            ResourceLocation biomeType = entry.getKey().biomeType();
            grouped.computeIfAbsent(biomeType, k -> new ArrayList()).add(entry.getValue());
        }
    }

    public static BiomeForecast getAverageForecast(ResourceLocation biomeType) {
        return AVERAGE_FORECASTS.get(biomeType);
    }

    public static Set<BiomeInstanceKey> getBiomeSamples() {
        return biomeSamples;
    }

    static void clearBiomeSamples() {
        biomeSamples.clear();
        biomeIndex.clear();
    }

    static void generateForecastForSavedRegion(ServerLevel level) {
        ForecastGenerator.buildRegionForecasts();
        SandStormManager.dailyAndSand(level);
    }

    static void generateForecastForRegion(BlockPos center, ServerLevel level) {
        BiomeForecast forecast;
        BiomeInstanceKey key;
        long forecastEnd;
        long samplingEnd;
        long start = System.nanoTime();
        int minBiomeWidthBlocks = 40;
        biomeSamples.clear();
        biomeSampleCounts.clear();
        biomeIndex.clear();
        FORECAST_MAP.clear();
        long day = AsyncAtmosphereService.callOnMainThread(() -> level.m_46468_() / 24000L);
        BiomeSource biomeSource = AsyncAtmosphereService.callOnMainThread(() -> level.m_7726_().m_8481_().m_62218_());
        long samplingStart = System.nanoTime();
        int baseX = center.m_123341_();
        int baseY = center.m_123342_();
        int baseZ = center.m_123343_();
        boolean belowSeaLevel = (float)baseY < SEA_LEVEL;
        BiomeSampler sampler = new BiomeSampler(ProjectAtmosphere.seed, level.m_9598_(), biomeSource);
        int samplesPerAxis = RADIUS * 2 / 64 + 1;
        int estimatedSamples = samplesPerAxis * samplesPerAxis;
        final class BiomeStats {
            int count = 0;
            int minX;
            int maxX;
            int minZ;
            int maxZ;
            final List<BiomeInstanceKey> samples = new ArrayList<BiomeInstanceKey>(MAX_POSITIONS_PER_BIOME);

            BiomeStats(int x, int z) {
                this.minX = this.maxX = x;
                this.minZ = this.maxZ = z;
            }

            void updateBounds(int x, int z) {
                if (x < this.minX) {
                    this.minX = x;
                }
                if (x > this.maxX) {
                    this.maxX = x;
                }
                if (z < this.minZ) {
                    this.minZ = z;
                }
                if (z > this.maxZ) {
                    this.maxZ = z;
                }
            }
        }
        HashMap<ResourceLocation, BiomeStats> biomeStats = new HashMap<ResourceLocation, BiomeStats>(estimatedSamples / 4 + 16);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        if (!belowSeaLevel) {
            for (int dx = -RADIUS; dx <= RADIUS; dx += 64) {
                int x = baseX + dx;
                for (int dz = -RADIUS; dz <= RADIUS; dz += 64) {
                    int z = baseZ + dz;
                    mutablePos.m_122178_(x, baseY, z);
                    ResourceLocation biomeId = sampler.getBiomeId(x, baseY, z);
                    String path = biomeId.m_135815_();
                    if (path.equals("lush_caves") || path.equals("dripstone_caves") || path.equals("deep_dark")) continue;
                    BiomeStats stats = (BiomeStats)biomeStats.get(biomeId);
                    if (stats == null) {
                        stats = new BiomeStats(x, z);
                        biomeStats.put(biomeId, stats);
                    } else {
                        stats.updateBounds(x, z);
                    }
                    if (stats.count >= MAX_POSITIONS_PER_BIOME) continue;
                    BiomeInstanceKey key2 = new BiomeInstanceKey(biomeId, mutablePos.m_7949_());
                    stats.samples.add(key2);
                    ++stats.count;
                }
            }
        }
        for (Map.Entry entry : biomeStats.entrySet()) {
            ResourceLocation biomeId = (ResourceLocation)entry.getKey();
            BiomeStats stats = (BiomeStats)entry.getValue();
            int widthX = stats.maxX - stats.minX;
            int widthZ = stats.maxZ - stats.minZ;
            if (widthX < 40 && widthZ < 40) continue;
            biomeSampleCounts.put(biomeId, stats.count);
            biomeSamples.addAll(stats.samples);
        }
        for (BiomeInstanceKey key3 : biomeSamples) {
            biomeIndex.computeIfAbsent(key3.biomeType(), k -> new ArrayList()).add(key3);
        }
        long forecastStart = samplingEnd = System.nanoTime();
        if (CompatHandler.isToughAsNailsLoaded()) {
            HashSet processed = new HashSet(biomeIndex.size());
            for (BiomeInstanceKey key4 : biomeSamples) {
                ResourceLocation biomeId = key4.biomeType();
                if (!processed.add(biomeId)) continue;
                long perBiomeStart = System.nanoTime();
                float[][] forecast2 = ToughAsNailsCompat.injectForecastForTAN(key4, level);
                BiomeForecast bf = new BiomeForecast();
                bf.setTemperature(forecast2);
                bf.setToughAsNailsFlag(true);
                bf.setBiomeKey(key4);
                ForecastGenerator.putForecast(key4, bf);
                if (!ProjectAtmosphere.DEBUG_MODE) continue;
                long perBiomeEnd = System.nanoTime();
                long micros = (perBiomeEnd - perBiomeStart) / 1000L;
                ProjectAtmosphere.LOGGER.info("[Atmosphere] Tough As Nails forecast for " + String.valueOf(biomeId) + " at " + String.valueOf(key4.samplePos()) + " took " + micros + " \u00b5s");
            }
            ForecastGenerator.groupForecastsByBiome();
        } else {
            for (BiomeInstanceKey key5 : biomeSamples) {
                BiomeForecast forecast3 = new BiomeForecast();
                forecast3.setTemperature(ForecastGenerator.generateTemperature(key5, level));
                forecast3.setBiomeKey(key5);
                ForecastGenerator.putForecast(key5, forecast3);
            }
            ForecastGenerator.groupForecastsByBiome();
        }
        ForecastGenerator.computeAverageTemperatureWeek();
        long postStart = forecastEnd = System.nanoTime();
        for (Map.Entry<BiomeInstanceKey, BiomeForecast> entry : FORECAST_MAP.entrySet()) {
            key = entry.getKey();
            forecast = entry.getValue();
            forecast.setHumidity(ForecastGenerator.generateHumidity(key, level, day));
        }
        ForecastGenerator.computeAverageHumidityWeek();
        for (Map.Entry<BiomeInstanceKey, BiomeForecast> entry : FORECAST_MAP.entrySet()) {
            key = entry.getKey();
            forecast = entry.getValue();
            forecast.setPressure(ForecastGenerator.generatePressure(key, day));
        }
        ForecastGenerator.computeAveragePressureWeek();
        WindGenerator.buildNeighborIndex(ForecastGenerator.getBiomeSamples());
        for (Map.Entry<BiomeInstanceKey, BiomeForecast> entry : FORECAST_MAP.entrySet()) {
            key = entry.getKey();
            forecast = entry.getValue();
            forecast.setWind(ForecastGenerator.generateWind(key));
        }
        ForecastGenerator.computeAverageWindWeek();
        ForecastGenerator.buildRegionForecasts();
        SandStormManager.dailyAndSand(level);
        long end = System.nanoTime();
        long totalMs = (end - start) / 1000000L;
        if (ProjectAtmosphere.DEBUG_MODE) {
            long samplingMs = (samplingEnd - samplingStart) / 1000000L;
            long forecastMs = (forecastEnd - forecastStart) / 1000000L;
            long postMs = (end - postStart) / 1000000L;
            String message = "[Atmosphere] Forecast region generation took " + totalMs + " ms. sampling=" + samplingMs + " ms, forecast=" + forecastMs + " ms, post=" + postMs + " ms. samples=" + biomeSamples.size() + ", biomes=" + biomeIndex.size();
            ProjectAtmosphere.LOGGER.info(message);
            ForecastGenerator.message = message;
        } else {
            ProjectAtmosphere.LOGGER.info("[Atmosphere] Forecast region generation took " + totalMs + " ms for " + biomeSamples.size() + " samples across " + biomeIndex.size() + " biomes.");
        }
    }

    private static float[][] generateTemperature(BiomeInstanceKey key, ServerLevel level) {
        return VariationGenerator.applyVariationToWeek(TemperatureGenerator.generateWeekForecast(level, key.samplePos(), key.biomeType()));
    }

    private static float[][] generateHumidity(BiomeInstanceKey key, ServerLevel level, Long day) {
        return HumidityGenerator.generateWeekForecast(level, key, day);
    }

    private static float[][] generatePressure(BiomeInstanceKey key, Long day) {
        return PressureGenerator.generateWeekForecast(key, day);
    }

    private static WindVector[] generateWind(BiomeInstanceKey key) {
        return WindGenerator.generateWindWeek(key);
    }

    private static void buildRegionForecasts() {
        REGION_FORECASTS.clear();
        for (Map.Entry<BiomeInstanceKey, BiomeForecast> entry : FORECAST_MAP.entrySet()) {
            BiomeInstanceKey biomeKey = entry.getKey();
            if (biomeKey == null || biomeKey.samplePos() == null) continue;
            RegionInstanceKey regionKey = RegionInstanceKey.from(biomeKey.samplePos());
            ForecastRegion region = REGION_FORECASTS.computeIfAbsent(regionKey, key -> new ForecastRegion((RegionInstanceKey)key, biomeKey.samplePos()));
            region.addBiomeForecast(biomeKey, entry.getValue());
        }
        for (ForecastRegion region : REGION_FORECASTS.values()) {
            region.finalizeAggregation();
            AtmosphericStateRegistry.initializeState(region.getKey(), region);
        }
        AtmosphericStateRegistry.rebuildNeighbors();
    }

    public static Map<BiomeInstanceKey, BiomeForecast> getForecastMap() {
        return FORECAST_MAP;
    }

    public static Map<RegionInstanceKey, ForecastRegion> getRegionForecasts() {
        return REGION_FORECASTS;
    }

    static void clearForecasts() {
        FORECAST_MAP.clear();
        REGION_FORECASTS.clear();
        grouped.clear();
        biomeSamples.clear();
        biomeIndex.clear();
        biomeSampleCounts.clear();
        AVERAGE_FORECASTS.clear();
        AtmosphericStateRegistry.clear();
        SandStormManager.clearSandstormForecasts();
        ForecastPointerRegistry.clear();
        ProjectAtmosphere.LOGGER.info("[Atmosphere] Cleared all forecasts and samples.");
    }

    static void putForecast(BiomeInstanceKey key, BiomeForecast forecast) {
        FORECAST_MAP.put(key, forecast);
        if (biomeSamples.add(key)) {
            biomeSampleCounts.put(key.biomeType(), biomeSampleCounts.getOrDefault(key.biomeType(), 0) + 1);
        }
    }

    static BiomeForecast getForecast(BiomeInstanceKey key) {
        return FORECAST_MAP.get(key);
    }

    static float getHumidityValue(BiomeInstanceKey key, long tick) {
        RegionAtmosphereState state = AtmosphericStateRegistry.getState(key);
        if (state == null) {
            return 0.0f;
        }
        return state.getHumidityPercent();
    }

    static float getTemperatureValue(BiomeInstanceKey key, long tick) {
        RegionAtmosphereState state = AtmosphericStateRegistry.getState(key);
        if (state != null) {
            return state.getTemperature();
        }
        BiomeForecast fallback = ForecastGenerator.getClosestValidForecast(key, ForecastType.TEMPERATURE);
        if (fallback != null) {
            float[] curve = fallback.getTemperatureDay();
            if (curve != null && curve.length > 0) {
                int minuteOfDay = (int)(tick % 24000L / 100L);
                return curve[Math.min(minuteOfDay, curve.length - 1)];
            }
            float[][] week = fallback.getTemperature();
            if (week != null && week.length > 0) {
                return ForecastGenerator.averageDailyMidpoint(week);
            }
        }
        return 0.0f;
    }

    static float getPressureValue(BiomeInstanceKey key, long tick) {
        RegionAtmosphereState state = AtmosphericStateRegistry.getState(key);
        if (state == null) {
            return 0.0f;
        }
        return state.getPressure();
    }

    static WindVector getWindValue(BiomeInstanceKey key, long worldTime) {
        RegionAtmosphereState state = AtmosphericStateRegistry.getState(key);
        if (state == null || state.getWind() == null) {
            return WindVector.fromBase(0.0f, 0.0f);
        }
        return state.getWind();
    }

    public static BiomeForecast getClosestValidForecast(BiomeInstanceKey key, ForecastType type) {
        BiomeForecast pointer = ForecastPointerRegistry.getPointer(key);
        if (pointer != null) {
            return pointer;
        }
        BiomeForecast average = ForecastGenerator.getAverageForecast(key.biomeType());
        if (average != null) {
            return average;
        }
        ProjectAtmosphere.LOGGER.warn("[Atmosphere] No forecast data available for {}. Returning fallback.", (Object)key);
        return ForecastGenerator.buildFallbackForecast(key);
    }

    private static BiomeForecast buildFallbackForecast(BiomeInstanceKey key) {
        BiomeForecast fallback = new BiomeForecast();
        fallback.setBiomeKey(key);
        fallback.setTemperature(new float[7][2]);
        fallback.setHumidity(new float[7][2]);
        fallback.setPressure(new float[7][2]);
        Object[] windWeek = new WindVector[7];
        Arrays.fill(windWeek, WindVector.fromBase(0.0f, 0.0f));
        fallback.setWind((WindVector[])windWeek);
        fallback.setWindDay(WindVector.fromBase(0.0f, 0.0f));
        return fallback;
    }

    private static float[][] averageWeek(List<BiomeForecast> forecasts, Function<BiomeForecast, float[][]> extractor) {
        int days = 7;
        int cols = 2;
        float[][] result = new float[days][cols];
        for (BiomeForecast f : forecasts) {
            float[][] data = extractor.apply(f);
            if (data == null) continue;
            for (int d = 0; d < days; ++d) {
                for (int c = 0; c < cols; ++c) {
                    float[] fArray = result[d];
                    int n = c;
                    fArray[n] = fArray[n] + data[d][c];
                }
            }
        }
        int size = forecasts.size();
        for (int d = 0; d < days; ++d) {
            int c = 0;
            while (c < cols) {
                float[] fArray = result[d];
                int n = c++;
                fArray[n] = fArray[n] / (float)size;
            }
        }
        return result;
    }

    private static WindVector averageWind(List<BiomeForecast> forecasts, Function<BiomeForecast, WindVector> extractor) {
        if (forecasts.isEmpty()) {
            return WindVector.fromBase(0.0f, 0.0f);
        }
        float sumX = 0.0f;
        float sumZ = 0.0f;
        float sumGust = 0.0f;
        for (BiomeForecast f : forecasts) {
            WindVector wind = f.getWindDay();
            if (wind == null) continue;
            float angle = wind.angleRadians();
            float speed = wind.baseSpeed();
            sumX += speed * (float)Math.cos(angle);
            sumZ += speed * (float)Math.sin(angle);
            sumGust += wind.gustSpeed();
        }
        int size = forecasts.size();
        float avgX = sumX / (float)size;
        float avgZ = sumZ / (float)size;
        float avgSpeed = (float)Math.sqrt(avgX * avgX + avgZ * avgZ);
        float avgAngle = (float)Math.atan2(avgZ, avgX);
        float avgGust = sumGust / (float)size;
        return new WindVector(avgSpeed, avgAngle, avgGust);
    }

    private static WindVector[] averageWindWeek(List<BiomeForecast> forecasts, Function<BiomeForecast, WindVector[]> extractor) {
        Object[] result = new WindVector[7];
        if (forecasts.isEmpty()) {
            Arrays.fill(result, WindVector.fromBase(0.0f, 0.0f));
            return result;
        }
        for (int day = 0; day < 7; ++day) {
            float sumX = 0.0f;
            float sumZ = 0.0f;
            float sumGust = 0.0f;
            int count = 0;
            for (BiomeForecast forecast : forecasts) {
                WindVector wind;
                WindVector[] windWeek = extractor.apply(forecast);
                if (windWeek == null || windWeek.length != 7 || (wind = windWeek[day]) == null) continue;
                float speed = wind.baseSpeed();
                float angle = wind.angleRadians();
                float gust = wind.gustSpeed();
                sumX += speed * (float)Math.cos(angle);
                sumZ += speed * (float)Math.sin(angle);
                sumGust += gust;
                ++count;
            }
            if (count > 0) {
                float avgX = sumX / (float)count;
                float avgZ = sumZ / (float)count;
                float avgSpeed = (float)Math.sqrt(avgX * avgX + avgZ * avgZ);
                float avgAngle = (float)Math.atan2(avgZ, avgX);
                float avgGust = sumGust / (float)count;
                result[day] = new WindVector(avgSpeed, avgAngle, avgGust);
                continue;
            }
            result[day] = WindVector.fromBase(0.0f, 0.0f);
        }
        return result;
    }

    private static float deriveRepresentativeTemperature(BiomeForecast avg) {
        RegionAtmosphereState state;
        if (avg.getBiomeKey() != null && (state = AtmosphericStateRegistry.getState(avg.getBiomeKey())) != null) {
            return state.getTemperature();
        }
        return ForecastGenerator.averageDailyMidpoint(avg.getTemperature());
    }

    private static float[] buildFlatCurve(float value) {
        float[] arr = new float[24];
        Arrays.fill(arr, value);
        return arr;
    }

    private static float averageDailyMidpoint(float[][] week) {
        if (week == null || week.length == 0) {
            return 0.0f;
        }
        float sum = 0.0f;
        int count = 0;
        for (float[] day : week) {
            if (day == null || day.length == 0) continue;
            sum = day.length == 1 ? (sum += day[0]) : (sum += (day[0] + day[Math.min(1, day.length - 1)]) * 0.5f);
            ++count;
        }
        return count == 0 ? 0.0f : sum / (float)count;
    }

    static {
        SEA_LEVEL = AsyncAtmosphereService.callOnMainThread(ProjectAtmosphere::getSeaLevel).floatValue();
        message = "";
        MAX_POSITIONS_PER_BIOME = CompatHandler.isToughAsNailsLoaded() ? 500 : 1000;
        RADIUS = SimpleCloudsConstants.SPAWN_RADIUS;
        biomeSamples = ConcurrentHashMap.newKeySet();
        biomeIndex = new ConcurrentHashMap<ResourceLocation, List<BiomeInstanceKey>>();
        biomeSampleCounts = new ConcurrentHashMap<ResourceLocation, Integer>();
        AVERAGE_FORECASTS = new ConcurrentHashMap<ResourceLocation, BiomeForecast>();
        FORECAST_MAP = new ConcurrentHashMap<BiomeInstanceKey, BiomeForecast>();
        REGION_FORECASTS = new ConcurrentHashMap<RegionInstanceKey, ForecastRegion>();
        grouped = new ConcurrentHashMap<ResourceLocation, List<BiomeForecast>>();
    }
}

