/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.manager;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.Gabou.projectatmosphere.manager.ForecastGenerator;
import net.Gabou.projectatmosphere.modules.core.BiomeForecast;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;

public final class ForecastPointerRegistry {
    private static final ConcurrentMap<BiomeInstanceKey, BiomeForecast> POINTERS = new ConcurrentHashMap<BiomeInstanceKey, BiomeForecast>();

    public static void setPointer(BiomeInstanceKey key, BiomeForecast forecast) {
        if (key != null && forecast != null) {
            POINTERS.put(key, forecast);
        }
    }

    public static BiomeForecast getPointer(BiomeInstanceKey key) {
        if (key == null) {
            return null;
        }
        BiomeForecast averageForecast = ForecastGenerator.getAverageForecast(key.biomeType());
        if (averageForecast == null) {
            return (BiomeForecast)POINTERS.get(key);
        }
        return POINTERS.getOrDefault(key, averageForecast);
    }

    public static boolean hasPointer(BiomeInstanceKey key) {
        return POINTERS.containsKey(key);
    }

    public static void clear() {
        POINTERS.clear();
    }

    private ForecastPointerRegistry() {
    }
}

